/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfo;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoCollection;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoImpl;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.utils.CollectionUtils;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class AppInfoWithLiveness
extends AppInfoWithSubtyping {
    private final Set<DexType> liveTypes;
    private final Set<DexType> instantiatedAnnotationTypes;
    public final Set<DexType> instantiatedAppServices;
    final Set<DexType> instantiatedTypes;
    private final IdentityHashMap<DexType, Boolean> indirectlyInstantiatedTypes = new IdentityHashMap();
    final SortedSet<DexMethod> targetedMethods;
    public final Set<DexMethod> failedResolutionTargets;
    public final SortedSet<DexMethod> bootstrapMethods;
    public final SortedSet<DexMethod> methodsTargetedByInvokeDynamic;
    final SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect;
    public final SortedSet<DexMethod> liveMethods;
    private final FieldAccessInfoCollectionImpl fieldAccessInfoCollection;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes;
    public final SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes;
    public final Set<DexCallSite> callSites;
    final Set<DexReference> pinnedItems;
    public final Map<DexReference, ProguardMemberRule> mayHaveSideEffects;
    public final Map<DexReference, ProguardMemberRule> noSideEffects;
    public final Map<DexReference, ProguardMemberRule> assumedValues;
    public final Set<DexMethod> alwaysInline;
    public final Set<DexMethod> forceInline;
    public final Set<DexMethod> neverInline;
    public final Set<DexMethod> whyAreYouNotInlining;
    public final Set<DexMethod> keepConstantArguments;
    public final Set<DexMethod> keepUnusedArguments;
    public final Set<DexType> alwaysClassInline;
    public final Set<DexType> neverClassInline;
    public final Set<DexType> neverMerge;
    public final Set<DexType> constClassReferences;
    private final Set<DexReference> neverPropagateValue;
    public final Object2BooleanMap<DexReference> identifierNameStrings;
    final Set<DexType> prunedTypes;
    final Map<DexField, Int2ReferenceMap<DexField>> switchMaps;
    final Map<DexType, Map<DexField, EnumValueInfo>> enumValueInfoMaps;
    final Set<DexType> instantiatedLambdas;

    private AppInfoWithLiveness(DexApplication application, Set<DexType> liveTypes, Set<DexType> instantiatedAnnotationTypes, Set<DexType> instantiatedAppServices, Set<DexType> instantiatedTypes, SortedSet<DexMethod> targetedMethods, Set<DexMethod> failedResolutionTargets, SortedSet<DexMethod> bootstrapMethods, SortedSet<DexMethod> methodsTargetedByInvokeDynamic, SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect, SortedSet<DexMethod> liveMethods, FieldAccessInfoCollectionImpl fieldAccessInfoCollection, SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes, Set<DexCallSite> callSites, Set<DexReference> pinnedItems, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> whyAreYouNotInlining, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> alwaysClassInline, Set<DexType> neverClassInline, Set<DexType> neverMerge, Set<DexReference> neverPropagateValue, Object2BooleanMap<DexReference> identifierNameStrings, Set<DexType> prunedTypes, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Map<DexField, EnumValueInfo>> enumValueInfoMaps, Set<DexType> instantiatedLambdas, Set<DexType> constClassReferences) {
        super(application);
        this.liveTypes = liveTypes;
        this.instantiatedAnnotationTypes = instantiatedAnnotationTypes;
        this.instantiatedAppServices = instantiatedAppServices;
        this.instantiatedTypes = instantiatedTypes;
        this.targetedMethods = targetedMethods;
        this.failedResolutionTargets = failedResolutionTargets;
        this.bootstrapMethods = bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = liveMethods;
        this.fieldAccessInfoCollection = fieldAccessInfoCollection;
        this.pinnedItems = pinnedItems;
        this.mayHaveSideEffects = mayHaveSideEffects;
        this.noSideEffects = noSideEffects;
        this.assumedValues = assumedValues;
        this.virtualInvokes = virtualInvokes;
        this.interfaceInvokes = interfaceInvokes;
        this.superInvokes = superInvokes;
        this.directInvokes = directInvokes;
        this.staticInvokes = staticInvokes;
        this.callSites = callSites;
        this.alwaysInline = alwaysInline;
        this.forceInline = forceInline;
        this.neverInline = neverInline;
        this.whyAreYouNotInlining = whyAreYouNotInlining;
        this.keepConstantArguments = keepConstantArguments;
        this.keepUnusedArguments = keepUnusedArguments;
        this.alwaysClassInline = alwaysClassInline;
        this.neverClassInline = neverClassInline;
        this.neverMerge = neverMerge;
        this.neverPropagateValue = neverPropagateValue;
        this.identifierNameStrings = identifierNameStrings;
        this.prunedTypes = prunedTypes;
        this.switchMaps = switchMaps;
        this.enumValueInfoMaps = enumValueInfoMaps;
        this.instantiatedLambdas = instantiatedLambdas;
        this.constClassReferences = constClassReferences;
    }

    public AppInfoWithLiveness(AppInfoWithSubtyping appInfoWithSubtyping, Set<DexType> liveTypes, Set<DexType> instantiatedAnnotationTypes, Set<DexType> instantiatedAppServices, Set<DexType> instantiatedTypes, SortedSet<DexMethod> targetedMethods, Set<DexMethod> failedResolutionTargets, SortedSet<DexMethod> bootstrapMethods, SortedSet<DexMethod> methodsTargetedByInvokeDynamic, SortedSet<DexMethod> virtualMethodsTargetedByInvokeDirect, SortedSet<DexMethod> liveMethods, FieldAccessInfoCollectionImpl fieldAccessInfoCollection, SortedMap<DexMethod, Set<DexEncodedMethod>> virtualInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> interfaceInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> superInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> directInvokes, SortedMap<DexMethod, Set<DexEncodedMethod>> staticInvokes, Set<DexCallSite> callSites, Set<DexReference> pinnedItems, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> whyAreYouNotInlining, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> alwaysClassInline, Set<DexType> neverClassInline, Set<DexType> neverMerge, Set<DexReference> neverPropagateValue, Object2BooleanMap<DexReference> identifierNameStrings, Set<DexType> prunedTypes, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Map<DexField, EnumValueInfo>> enumValueInfoMaps, Set<DexType> instantiatedLambdas, Set<DexType> constClassReferences) {
        super(appInfoWithSubtyping);
        this.liveTypes = liveTypes;
        this.instantiatedAnnotationTypes = instantiatedAnnotationTypes;
        this.instantiatedAppServices = instantiatedAppServices;
        this.instantiatedTypes = instantiatedTypes;
        this.targetedMethods = targetedMethods;
        this.failedResolutionTargets = failedResolutionTargets;
        this.bootstrapMethods = bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = liveMethods;
        this.fieldAccessInfoCollection = fieldAccessInfoCollection;
        this.pinnedItems = pinnedItems;
        this.mayHaveSideEffects = mayHaveSideEffects;
        this.noSideEffects = noSideEffects;
        this.assumedValues = assumedValues;
        this.virtualInvokes = virtualInvokes;
        this.interfaceInvokes = interfaceInvokes;
        this.superInvokes = superInvokes;
        this.directInvokes = directInvokes;
        this.staticInvokes = staticInvokes;
        this.callSites = callSites;
        this.alwaysInline = alwaysInline;
        this.forceInline = forceInline;
        this.neverInline = neverInline;
        this.whyAreYouNotInlining = whyAreYouNotInlining;
        this.keepConstantArguments = keepConstantArguments;
        this.keepUnusedArguments = keepUnusedArguments;
        this.alwaysClassInline = alwaysClassInline;
        this.neverClassInline = neverClassInline;
        this.neverMerge = neverMerge;
        this.neverPropagateValue = neverPropagateValue;
        this.identifierNameStrings = identifierNameStrings;
        this.prunedTypes = prunedTypes;
        this.switchMaps = switchMaps;
        this.enumValueInfoMaps = enumValueInfoMaps;
        this.instantiatedLambdas = instantiatedLambdas;
        this.constClassReferences = constClassReferences;
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous) {
        this(previous, previous.liveTypes, previous.instantiatedAnnotationTypes, previous.instantiatedAppServices, previous.instantiatedTypes, previous.targetedMethods, previous.failedResolutionTargets, previous.bootstrapMethods, previous.methodsTargetedByInvokeDynamic, previous.virtualMethodsTargetedByInvokeDirect, previous.liveMethods, previous.fieldAccessInfoCollection, previous.virtualInvokes, previous.interfaceInvokes, previous.superInvokes, previous.directInvokes, previous.staticInvokes, previous.callSites, previous.pinnedItems, previous.mayHaveSideEffects, previous.noSideEffects, previous.assumedValues, previous.alwaysInline, previous.forceInline, previous.neverInline, previous.whyAreYouNotInlining, previous.keepConstantArguments, previous.keepUnusedArguments, previous.alwaysClassInline, previous.neverClassInline, previous.neverMerge, previous.neverPropagateValue, previous.identifierNameStrings, previous.prunedTypes, previous.switchMaps, previous.enumValueInfoMaps, previous.instantiatedLambdas, previous.constClassReferences);
        this.copyMetadataFromPrevious(previous);
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous, DexApplication application, Collection<DexType> removedClasses, Collection<DexReference> additionalPinnedItems) {
        this(application, previous.liveTypes, previous.instantiatedAnnotationTypes, previous.instantiatedAppServices, previous.instantiatedTypes, previous.targetedMethods, previous.failedResolutionTargets, previous.bootstrapMethods, previous.methodsTargetedByInvokeDynamic, previous.virtualMethodsTargetedByInvokeDirect, previous.liveMethods, previous.fieldAccessInfoCollection, previous.virtualInvokes, previous.interfaceInvokes, previous.superInvokes, previous.directInvokes, previous.staticInvokes, previous.callSites, additionalPinnedItems == null ? previous.pinnedItems : CollectionUtils.mergeSets(previous.pinnedItems, additionalPinnedItems), previous.mayHaveSideEffects, previous.noSideEffects, previous.assumedValues, previous.alwaysInline, previous.forceInline, previous.neverInline, previous.whyAreYouNotInlining, previous.keepConstantArguments, previous.keepUnusedArguments, previous.alwaysClassInline, previous.neverClassInline, previous.neverMerge, previous.neverPropagateValue, previous.identifierNameStrings, removedClasses == null ? previous.prunedTypes : CollectionUtils.mergeSets(previous.prunedTypes, removedClasses), previous.switchMaps, previous.enumValueInfoMaps, previous.instantiatedLambdas, previous.constClassReferences);
        this.copyMetadataFromPrevious(previous);
        assert (removedClasses == null || this.assertNoItemRemoved(previous.pinnedItems, removedClasses));
    }

    private AppInfoWithLiveness(AppInfoWithLiveness previous, DirectMappedDexApplication application, GraphLense lense) {
        super(application);
        this.liveTypes = AppInfoWithLiveness.rewriteItems(previous.liveTypes, lense::lookupType);
        this.instantiatedAnnotationTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedAnnotationTypes, lense::lookupType);
        this.instantiatedAppServices = AppInfoWithLiveness.rewriteItems(previous.instantiatedAppServices, lense::lookupType);
        this.instantiatedTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedTypes, lense::lookupType);
        this.instantiatedLambdas = AppInfoWithLiveness.rewriteItems(previous.instantiatedLambdas, lense::lookupType);
        this.targetedMethods = lense.rewriteMethodsConservatively(previous.targetedMethods);
        this.failedResolutionTargets = lense.rewriteMethodsConservatively(previous.failedResolutionTargets);
        this.bootstrapMethods = lense.rewriteMethodsConservatively(previous.bootstrapMethods);
        this.methodsTargetedByInvokeDynamic = lense.rewriteMethodsConservatively(previous.methodsTargetedByInvokeDynamic);
        this.virtualMethodsTargetedByInvokeDirect = lense.rewriteMethodsConservatively(previous.virtualMethodsTargetedByInvokeDirect);
        this.liveMethods = lense.rewriteMethodsConservatively(previous.liveMethods);
        this.fieldAccessInfoCollection = previous.fieldAccessInfoCollection.rewrittenWithLens(application, lense);
        this.pinnedItems = lense.rewriteReferencesConservatively(previous.pinnedItems);
        this.virtualInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.virtualInvokes, lense::lookupMethodInAllContexts);
        this.interfaceInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.interfaceInvokes, lense::lookupMethodInAllContexts);
        this.superInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.superInvokes, lense::lookupMethodInAllContexts);
        this.directInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.directInvokes, lense::lookupMethodInAllContexts);
        this.staticInvokes = AppInfoWithLiveness.rewriteKeysConservativelyWhileMergingValues(previous.staticInvokes, lense::lookupMethodInAllContexts);
        this.callSites = previous.callSites;
        this.prunedTypes = previous.prunedTypes;
        this.mayHaveSideEffects = GraphLense.rewriteReferenceKeys(previous.mayHaveSideEffects, lense::lookupReference);
        this.noSideEffects = GraphLense.rewriteReferenceKeys(previous.noSideEffects, lense::lookupReference);
        this.assumedValues = GraphLense.rewriteReferenceKeys(previous.assumedValues, lense::lookupReference);
        assert (lense.assertDefinitionsNotModified(previous.alwaysInline.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.alwaysInline = lense.rewriteMethodsWithRenamedSignature(previous.alwaysInline);
        this.forceInline = lense.rewriteMethodsWithRenamedSignature(previous.forceInline);
        this.neverInline = lense.rewriteMethodsWithRenamedSignature(previous.neverInline);
        this.whyAreYouNotInlining = lense.rewriteMethodsWithRenamedSignature(previous.whyAreYouNotInlining);
        this.keepConstantArguments = lense.rewriteMethodsWithRenamedSignature(previous.keepConstantArguments);
        this.keepUnusedArguments = lense.rewriteMethodsWithRenamedSignature(previous.keepUnusedArguments);
        assert (lense.assertDefinitionsNotModified(previous.neverMerge.stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.alwaysClassInline = AppInfoWithLiveness.rewriteItems(previous.alwaysClassInline, lense::lookupType);
        this.neverClassInline = AppInfoWithLiveness.rewriteItems(previous.neverClassInline, lense::lookupType);
        this.neverMerge = AppInfoWithLiveness.rewriteItems(previous.neverMerge, lense::lookupType);
        this.neverPropagateValue = lense.rewriteReferencesConservatively(previous.neverPropagateValue);
        this.identifierNameStrings = lense.rewriteReferencesConservatively(previous.identifierNameStrings);
        assert (lense.assertDefinitionsNotModified(previous.switchMaps.keySet().stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList())));
        this.switchMaps = GraphLense.rewriteReferenceKeys(previous.switchMaps, lense::lookupField);
        this.enumValueInfoMaps = GraphLense.rewriteReferenceKeys(previous.enumValueInfoMaps, lense::lookupType);
        this.constClassReferences = previous.constClassReferences;
    }

    public AppInfoWithLiveness(AppInfoWithLiveness previous, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Map<DexField, EnumValueInfo>> enumValueInfoMaps) {
        super(previous);
        this.liveTypes = previous.liveTypes;
        this.instantiatedAnnotationTypes = previous.instantiatedAnnotationTypes;
        this.instantiatedAppServices = previous.instantiatedAppServices;
        this.instantiatedTypes = previous.instantiatedTypes;
        this.instantiatedLambdas = previous.instantiatedLambdas;
        this.targetedMethods = previous.targetedMethods;
        this.failedResolutionTargets = previous.failedResolutionTargets;
        this.bootstrapMethods = previous.bootstrapMethods;
        this.methodsTargetedByInvokeDynamic = previous.methodsTargetedByInvokeDynamic;
        this.virtualMethodsTargetedByInvokeDirect = previous.virtualMethodsTargetedByInvokeDirect;
        this.liveMethods = previous.liveMethods;
        this.fieldAccessInfoCollection = previous.fieldAccessInfoCollection;
        this.pinnedItems = previous.pinnedItems;
        this.mayHaveSideEffects = previous.mayHaveSideEffects;
        this.noSideEffects = previous.noSideEffects;
        this.assumedValues = previous.assumedValues;
        this.virtualInvokes = previous.virtualInvokes;
        this.interfaceInvokes = previous.interfaceInvokes;
        this.superInvokes = previous.superInvokes;
        this.directInvokes = previous.directInvokes;
        this.staticInvokes = previous.staticInvokes;
        this.callSites = previous.callSites;
        this.alwaysInline = previous.alwaysInline;
        this.forceInline = previous.forceInline;
        this.neverInline = previous.neverInline;
        this.whyAreYouNotInlining = previous.whyAreYouNotInlining;
        this.keepConstantArguments = previous.keepConstantArguments;
        this.keepUnusedArguments = previous.keepUnusedArguments;
        this.alwaysClassInline = previous.alwaysClassInline;
        this.neverClassInline = previous.neverClassInline;
        this.neverMerge = previous.neverMerge;
        this.neverPropagateValue = previous.neverPropagateValue;
        this.identifierNameStrings = previous.identifierNameStrings;
        this.prunedTypes = previous.prunedTypes;
        this.switchMaps = switchMaps;
        this.enumValueInfoMaps = enumValueInfoMaps;
        this.constClassReferences = previous.constClassReferences;
        previous.markObsolete();
    }

    public boolean isLiveProgramClass(DexProgramClass clazz) {
        return this.liveTypes.contains(clazz.type);
    }

    public boolean isLiveProgramType(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz != null && clazz.isProgramClass() && this.isLiveProgramClass(clazz.asProgramClass());
    }

    public boolean isNonProgramTypeOrLiveProgramType(DexType type) {
        if (this.liveTypes.contains(type)) {
            return true;
        }
        if (this.prunedTypes.contains(type)) {
            return false;
        }
        DexClass clazz = this.definitionFor(type);
        return clazz == null || !clazz.isProgramClass();
    }

    public Collection<DexClass> computeReachableInterfaces(Set<DexCallSite> desugaredCallSites) {
        Set<DexClass> interfaces = Sets.newIdentityHashSet();
        Set<DexType> seen = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        for (DexProgramClass clazz : this.classes()) {
            worklist.add(clazz.type);
        }
        for (DexCallSite callSite : desugaredCallSites) {
            for (DexEncodedMethod method : this.lookupLambdaImplementedMethods(callSite)) {
                worklist.add(method.method.holder);
            }
        }
        for (DexCallSite callSite : this.callSites) {
            for (DexEncodedMethod method : this.lookupLambdaImplementedMethods(callSite)) {
                worklist.add(method.method.holder);
            }
        }
        while (!worklist.isEmpty()) {
            DexClass definition;
            DexType type = (DexType)worklist.pop();
            if (!seen.add(type) || (definition = this.definitionFor(type)) == null) continue;
            if (definition.isInterface()) {
                interfaces.add(definition);
            }
            if (definition.superType != null) {
                worklist.add(definition.superType);
            }
            Collections.addAll(worklist, definition.interfaces.values);
        }
        return interfaces;
    }

    public boolean isLockCandidate(DexType type) {
        return this.constClassReferences.contains(type);
    }

    public AppInfoWithLiveness withStaticFieldWrites(Map<DexEncodedField, Set<DexEncodedMethod>> writesWithContexts) {
        assert (this.checkIfObsolete());
        if (writesWithContexts.isEmpty()) {
            return this;
        }
        AppInfoWithLiveness result = new AppInfoWithLiveness(this);
        writesWithContexts.forEach((encodedField, contexts) -> {
            DexField field = encodedField.field;
            FieldAccessInfoImpl fieldAccessInfo = result.fieldAccessInfoCollection.get(field);
            if (fieldAccessInfo == null) {
                fieldAccessInfo = new FieldAccessInfoImpl(field);
                result.fieldAccessInfoCollection.extend(field, fieldAccessInfo);
            }
            for (DexEncodedMethod context : contexts) {
                fieldAccessInfo.recordWrite(field, context);
            }
        });
        return result;
    }

    public AppInfoWithLiveness withoutStaticFieldsWrites(Set<DexField> noLongerWrittenFields) {
        assert (this.checkIfObsolete());
        if (noLongerWrittenFields.isEmpty()) {
            return this;
        }
        AppInfoWithLiveness result = new AppInfoWithLiveness(this);
        result.fieldAccessInfoCollection.forEach(info -> {
            if (noLongerWrittenFields.contains(info.getField())) {
                info.clearWrites();
            }
        });
        return result;
    }

    private <T extends PresortedComparable<T>> SortedSet<T> filter(Set<T> items, Predicate<T> predicate) {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, items.stream().filter(predicate).collect(Collectors.toList()));
    }

    public Map<DexField, EnumValueInfo> getEnumValueInfoMapFor(DexType enumClass) {
        assert (this.checkIfObsolete());
        return this.enumValueInfoMaps.get(enumClass);
    }

    public Int2ReferenceMap<DexField> getSwitchMapFor(DexField field) {
        assert (this.checkIfObsolete());
        return this.switchMaps.get(field);
    }

    public FieldAccessInfoCollection<? extends FieldAccessInfo> getFieldAccessInfoCollection() {
        return this.fieldAccessInfoCollection;
    }

    private boolean assertNoItemRemoved(Collection<DexReference> items, Collection<DexType> types) {
        ImmutableSet<DexType> typeSet = ImmutableSet.copyOf(types);
        for (DexReference item : items) {
            DexType typeToCheck;
            if (item.isDexType()) {
                typeToCheck = item.asDexType();
            } else if (item.isDexMethod()) {
                typeToCheck = item.asDexMethod().holder;
            } else {
                assert (item.isDexField());
                typeToCheck = item.asDexField().holder;
            }
            assert (!typeSet.contains(typeToCheck));
        }
        return true;
    }

    private boolean isInstantiatedDirectly(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        DexType type = clazz.type;
        return type.isD8R8SynthesizedClassType() || this.instantiatedTypes.contains(type) || this.instantiatedAnnotationTypes.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstantiatedIndirectly(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        if (this.hasAnyInstantiatedLambdas(clazz)) {
            return true;
        }
        DexType type = clazz.type;
        IdentityHashMap<DexType, Boolean> identityHashMap = this.indirectlyInstantiatedTypes;
        synchronized (identityHashMap) {
            if (this.indirectlyInstantiatedTypes.containsKey(type)) {
                return this.indirectlyInstantiatedTypes.get(type);
            }
            for (DexType directSubtype : this.allImmediateSubtypes(type)) {
                DexProgramClass directSubClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(directSubtype));
                if (directSubClass != null && !this.isInstantiatedDirectlyOrIndirectly(directSubClass)) continue;
                this.indirectlyInstantiatedTypes.put(type, Boolean.TRUE);
                return true;
            }
            this.indirectlyInstantiatedTypes.put(type, Boolean.FALSE);
            return false;
        }
    }

    public boolean isInstantiatedDirectlyOrIndirectly(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        return this.isInstantiatedDirectly(clazz) || this.isInstantiatedIndirectly(clazz);
    }

    public boolean isFieldRead(DexEncodedField encodedField) {
        assert (this.checkIfObsolete());
        DexField field = encodedField.field;
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field);
        if (info != null && info.isRead()) {
            return true;
        }
        return this.isPinned(field) || field.holder.isD8R8SynthesizedClassType() || this.isLibraryOrClasspathField(encodedField);
    }

    public boolean isFieldWritten(DexEncodedField encodedField) {
        assert (this.checkIfObsolete());
        return this.isFieldWrittenByFieldPutInstruction(encodedField) || this.isPinned(encodedField.field);
    }

    public boolean isFieldWrittenByFieldPutInstruction(DexEncodedField encodedField) {
        assert (this.checkIfObsolete());
        DexField field = encodedField.field;
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field);
        if (info != null && info.isWritten()) {
            return true;
        }
        if (field.holder.isD8R8SynthesizedClassType()) {
            return true;
        }
        return this.isLibraryOrClasspathField(encodedField);
    }

    public boolean isFieldOnlyWrittenInMethod(DexEncodedField field, DexEncodedMethod method) {
        assert (this.checkIfObsolete());
        assert (this.isFieldWritten(field)) : "Expected field `" + field.toSourceString() + "` to be written";
        if (!this.isPinned(field.field)) {
            FieldAccessInfoImpl fieldAccessInfo = this.fieldAccessInfoCollection.get(field.field);
            return fieldAccessInfo != null && fieldAccessInfo.isWritten() && !fieldAccessInfo.isWrittenOutside(method);
        }
        return false;
    }

    public boolean isStaticFieldWrittenOnlyInEnclosingStaticInitializer(DexEncodedField field) {
        assert (this.checkIfObsolete());
        assert (this.isFieldWritten(field)) : "Expected field `" + field.toSourceString() + "` to be written";
        DexEncodedMethod staticInitializer = this.definitionFor(field.field.holder).asProgramClass().getClassInitializer();
        return staticInitializer != null && this.isFieldOnlyWrittenInMethod(field, staticInitializer);
    }

    public boolean mayPropagateValueFor(DexReference reference) {
        assert (this.checkIfObsolete());
        return !this.isPinned(reference) && !this.neverPropagateValue.contains(reference);
    }

    private boolean isLibraryOrClasspathField(DexEncodedField field) {
        DexClass holder = this.definitionFor(field.field.holder);
        return holder == null || holder.isLibraryClass() || holder.isClasspathClass();
    }

    private static <T extends PresortedComparable<T>> ImmutableSortedSet<T> rewriteItems(Set<T> original, Function<T, T> rewrite) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        for (PresortedComparable item : original) {
            builder.add((PresortedComparable)rewrite.apply(item));
        }
        return builder.build();
    }

    private static <T extends PresortedComparable<T>, S> SortedMap<T, Set<S>> rewriteKeysConservativelyWhileMergingValues(Map<T, Set<S>> original, Function<T, Set<T>> rewrite) {
        TreeMap<PresortedComparable, Set> result = new TreeMap<PresortedComparable, Set>(PresortedComparable::slowCompare);
        for (PresortedComparable item : original.keySet()) {
            Set<T> rewrittenKeys = rewrite.apply(item);
            for (PresortedComparable rewrittenKey : rewrittenKeys) {
                result.computeIfAbsent(rewrittenKey, k -> Sets.newIdentityHashSet()).addAll((Collection)original.get(item));
            }
        }
        return Collections.unmodifiableSortedMap(result);
    }

    @Override
    protected boolean hasAnyInstantiatedLambdas(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        return this.instantiatedLambdas.contains(clazz.type);
    }

    @Override
    public boolean hasLiveness() {
        assert (this.checkIfObsolete());
        return true;
    }

    @Override
    public AppInfoWithLiveness withLiveness() {
        assert (this.checkIfObsolete());
        return this;
    }

    public boolean isPinned(DexReference reference) {
        assert (this.checkIfObsolete());
        return this.pinnedItems.contains(reference);
    }

    public boolean hasPinnedInstanceInitializer(DexType type) {
        assert (type.isClassType());
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.definitionFor(type));
        if (clazz != null) {
            for (DexEncodedMethod method : clazz.directMethods()) {
                if (!method.isInstanceInitializer() || !this.isPinned(method.method)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canVirtualMethodBeImplementedInExtraSubclass(DexProgramClass clazz, DexMethod method) {
        ResolutionResult resolutionResult;
        if (this.hasAnyInstantiatedLambdas(clazz)) {
            return true;
        }
        if (this.isPinned(clazz.type) && (resolutionResult = this.resolveMethod(clazz, method)).isSingleResolution()) {
            DexEncodedMethod resolutionTarget = resolutionResult.getSingleTarget();
            return !resolutionTarget.isProgramMethod(this) || resolutionTarget.isLibraryMethodOverride().isPossiblyTrue() || this.isVirtualMethodPinnedDirectlyOrInAncestor(clazz, method);
        }
        return false;
    }

    private boolean isVirtualMethodPinnedDirectlyOrInAncestor(DexProgramClass currentClass, DexMethod method) {
        Set<DexProgramClass> visited = SetUtils.newIdentityHashSet(currentClass);
        ArrayDeque<DexProgramClass> worklist = new ArrayDeque<DexProgramClass>(visited);
        while (!worklist.isEmpty()) {
            DexClass clazz = (DexClass)worklist.removeFirst();
            assert (visited.contains(clazz));
            DexEncodedMethod methodInClass = clazz.lookupVirtualMethod(method);
            if (methodInClass != null && this.isPinned(methodInClass.method)) {
                return true;
            }
            for (DexType superType : clazz.allImmediateSupertypes()) {
                DexProgramClass superClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(superType));
                if (superClass == null || !visited.add(superClass)) continue;
                worklist.addLast(superClass);
            }
        }
        return false;
    }

    public Set<DexReference> getPinnedItems() {
        assert (this.checkIfObsolete());
        return this.pinnedItems;
    }

    public AppInfoWithLiveness prunedCopyFrom(DexApplication application, Collection<DexType> removedClasses, Collection<DexReference> additionalPinnedItems) {
        assert (this.checkIfObsolete());
        return new AppInfoWithLiveness(this, application, removedClasses, additionalPinnedItems);
    }

    public AppInfoWithLiveness rewrittenWithLense(DirectMappedDexApplication application, GraphLense lense) {
        assert (this.checkIfObsolete());
        return new AppInfoWithLiveness(this, application, lense);
    }

    public boolean wasPruned(DexType type) {
        assert (this.checkIfObsolete());
        return this.prunedTypes.contains(type);
    }

    public Set<DexType> getPrunedTypes() {
        assert (this.checkIfObsolete());
        return this.prunedTypes;
    }

    public DexEncodedMethod lookupSingleTarget(Invoke.Type type, DexMethod target, DexType invocationContext) {
        assert (this.checkIfObsolete());
        DexType holder = target.holder;
        if (!holder.isClassType()) {
            return null;
        }
        switch (type) {
            case VIRTUAL: {
                return this.lookupSingleVirtualTarget(target, invocationContext);
            }
            case INTERFACE: {
                return this.lookupSingleInterfaceTarget(target, invocationContext);
            }
            case DIRECT: {
                return this.lookupDirectTarget(target);
            }
            case STATIC: {
                return this.lookupStaticTarget(target);
            }
            case SUPER: {
                return this.lookupSuperTarget(target, invocationContext);
            }
        }
        return null;
    }

    private DexEncodedMethod validateSingleVirtualTarget(DexEncodedMethod singleTarget, DexEncodedMethod resolutionResult) {
        assert (resolutionResult.isVirtualMethod());
        if (singleTarget == null || singleTarget == DexEncodedMethod.SENTINEL) {
            return null;
        }
        if (this.isInvalidSingleVirtualTarget(singleTarget, resolutionResult)) {
            return null;
        }
        return singleTarget;
    }

    private boolean isInvalidSingleVirtualTarget(DexEncodedMethod singleTarget, DexEncodedMethod resolutionResult) {
        assert (resolutionResult.isVirtualMethod());
        return !singleTarget.accessFlags.isAtLeastAsVisibleAs(resolutionResult.accessFlags);
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method, DexType invocationContext) {
        assert (this.checkIfObsolete());
        return this.lookupSingleVirtualTarget(method, invocationContext, method.holder, null);
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method, DexType invocationContext, DexType refinedReceiverType, ClassTypeLatticeElement receiverLowerBoundType) {
        assert (this.checkIfObsolete());
        DexProgramClass invocationClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(invocationContext));
        assert (invocationClass != null);
        ResolutionResult resolutionResult = this.resolveMethodOnClass(method.holder, method);
        if (!resolutionResult.isAccessibleForVirtualDispatchFrom(invocationClass, this)) {
            return null;
        }
        DexEncodedMethod topTarget = resolutionResult.getSingleTarget();
        if (topTarget == null) {
            return null;
        }
        if (topTarget.isPrivateMethod()) {
            return topTarget;
        }
        if (receiverLowerBoundType != null && receiverLowerBoundType.getClassType() == refinedReceiverType) {
            ResolutionResult refinedResolutionResult;
            if (resolutionResult.isSingleResolution() && resolutionResult.isVirtualTarget() && (refinedResolutionResult = this.resolveMethod(refinedReceiverType, method)).isSingleResolution() && refinedResolutionResult.isVirtualTarget()) {
                return this.validateSingleVirtualTarget(refinedResolutionResult.getSingleTarget(), resolutionResult.getSingleTarget());
            }
            return null;
        }
        assert (method != null);
        assert (this.isSubtype(refinedReceiverType, method.holder));
        if (method.holder.isArrayType()) {
            return null;
        }
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isNotProgramClass()) {
            return null;
        }
        assert (!holder.isInterface());
        boolean refinedReceiverIsStrictSubType = refinedReceiverType != method.holder;
        DexProgramClass refinedHolder = (refinedReceiverIsStrictSubType ? this.definitionFor(refinedReceiverType) : holder).asProgramClass();
        if (refinedHolder == null) {
            return null;
        }
        assert (!refinedHolder.isInterface());
        if (method.isSingleVirtualMethodCached(refinedReceiverType)) {
            return method.getSingleVirtualMethodCache(refinedReceiverType);
        }
        ResolutionResult topMethod = this.resolveMethodOnClass(holder, method);
        if (!topMethod.isSingleResolution() || !topMethod.isVirtualTarget()) {
            method.setSingleVirtualMethodCache(refinedReceiverType, null);
            return null;
        }
        ResolutionResult refinedResolutionResult = refinedReceiverIsStrictSubType ? this.resolveMethodOnClass(refinedHolder, method) : topMethod;
        DexEncodedMethod topSingleTarget = refinedResolutionResult.getSingleTarget();
        DexClass topHolder = this.definitionFor(topSingleTarget.method.holder);
        boolean topIsFromInterface = topHolder.isInterface();
        DexEncodedMethod result = this.validateSingleVirtualTarget(this.findSingleTargetFromSubtypes(refinedHolder, method, topSingleTarget, !refinedHolder.accessFlags.isAbstract(), topIsFromInterface), topMethod.getSingleTarget());
        assert (result != DexEncodedMethod.SENTINEL);
        method.setSingleVirtualMethodCache(refinedReceiverType, result);
        return result;
    }

    private DexEncodedMethod findSingleTargetFromSubtypes(DexProgramClass clazz, DexMethod method, DexEncodedMethod candidate, boolean candidateIsReachable, boolean checkForInterfaceConflicts) {
        if (this.canVirtualMethodBeImplementedInExtraSubclass(clazz, method)) {
            return DexEncodedMethod.SENTINEL;
        }
        DexEncodedMethod result = candidateIsReachable ? candidate : null;
        for (DexType subtype : this.allImmediateExtendsSubtypes(clazz.type)) {
            boolean newCandidateIsReachable;
            DexProgramClass subclass = DexProgramClass.asProgramClassOrNull(this.definitionFor(subtype));
            if (subclass == null) {
                return DexEncodedMethod.SENTINEL;
            }
            DexEncodedMethod target = subclass.lookupVirtualMethod(method);
            if (target != null && !target.isPrivateMethod() && !subclass.accessFlags.isAbstract()) {
                if (result != null && result != target) {
                    return DexEncodedMethod.SENTINEL;
                }
                result = target;
            }
            if (checkForInterfaceConflicts && this.interfacesMayHaveDefaultFor(subclass.interfaces, method)) {
                return DexEncodedMethod.SENTINEL;
            }
            DexEncodedMethod newCandidate = target == null ? candidate : target;
            DexEncodedMethod subtypeTarget = this.findSingleTargetFromSubtypes(subclass, method, newCandidate, newCandidateIsReachable = !subclass.accessFlags.isAbstract() || target == null && candidateIsReachable, checkForInterfaceConflicts);
            if (subtypeTarget == null) continue;
            if (result != null && result != subtypeTarget) {
                return DexEncodedMethod.SENTINEL;
            }
            result = subtypeTarget;
        }
        return result;
    }

    private boolean interfacesMayHaveDefaultFor(DexTypeList ifaces, DexMethod method) {
        for (DexType iface : ifaces.values) {
            DexClass clazz = this.definitionFor(iface);
            if (clazz == null || clazz.isNotProgramClass()) {
                return true;
            }
            DexEncodedMethod candidate = clazz.lookupMethod(method);
            if (candidate != null && !candidate.accessFlags.isAbstract()) {
                return true;
            }
            if (!this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) continue;
            return true;
        }
        return false;
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method, DexType invocationContext) {
        assert (this.checkIfObsolete());
        return this.lookupSingleInterfaceTarget(method, invocationContext, method.holder, null);
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method, DexType invocationContext, DexType refinedReceiverType, ClassTypeLatticeElement receiverLowerBoundType) {
        assert (this.checkIfObsolete());
        DexProgramClass invocationClass = DexProgramClass.asProgramClassOrNull(this.definitionFor(invocationContext));
        assert (invocationClass != null);
        if (receiverLowerBoundType != null && receiverLowerBoundType.getClassType() == refinedReceiverType) {
            ResolutionResult refinedResolutionResult;
            ResolutionResult resolutionResult = this.resolveMethod(method.holder, method, true);
            if (resolutionResult.isSingleResolution() && resolutionResult.isVirtualTarget() && (refinedResolutionResult = this.resolveMethod(refinedReceiverType, method)).isSingleResolution() && refinedResolutionResult.isVirtualTarget()) {
                return this.validateSingleVirtualTarget(refinedResolutionResult.getSingleTarget(), resolutionResult.getSingleTarget());
            }
            return null;
        }
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(this.definitionFor(method.holder));
        if (holder == null || !holder.accessFlags.isInterface()) {
            return null;
        }
        ResolutionResult topResolution = this.resolveMethodOnInterface(holder, method);
        if (!topResolution.isAccessibleForVirtualDispatchFrom(invocationClass, this)) {
            return null;
        }
        DexEncodedMethod topTarget = topResolution.getSingleTarget();
        if (topTarget == null) {
            return null;
        }
        if (topTarget.isPrivateMethod()) {
            return topTarget;
        }
        if (this.canVirtualMethodBeImplementedInExtraSubclass(holder, method)) {
            return null;
        }
        DexProgramClass refinedReceiverClass = this.definitionFor(refinedReceiverType).asProgramClass();
        if (refinedReceiverClass == null) {
            return null;
        }
        if (this.hasAnyInstantiatedLambdas(refinedReceiverClass)) {
            return null;
        }
        Set<DexType> subtypesToExplore = this.isInstantiatedDirectly(refinedReceiverClass) ? Iterables.concat(ImmutableList.of(refinedReceiverType), this.subtypes(refinedReceiverType)) : this.subtypes(refinedReceiverType);
        DexEncodedMethod result = null;
        for (DexType type : subtypesToExplore) {
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.definitionFor(type));
            if (clazz == null) {
                return null;
            }
            if (this.canVirtualMethodBeImplementedInExtraSubclass(clazz, method)) {
                return null;
            }
            if (!this.isInstantiatedDirectly(clazz)) continue;
            DexEncodedMethod resolutionResult = this.resolveMethod(clazz, method).getSingleTarget();
            if (resolutionResult == null || this.isInvalidSingleVirtualTarget(resolutionResult, topTarget)) {
                return null;
            }
            if (result != null && result != resolutionResult) {
                return null;
            }
            result = resolutionResult;
        }
        assert (result == null || !this.isInvalidSingleVirtualTarget(result, topTarget));
        return result == null || !result.isVirtualMethod() ? null : result;
    }

    public AppInfoWithLiveness addSwitchMaps(Map<DexField, Int2ReferenceMap<DexField>> switchMaps) {
        assert (this.checkIfObsolete());
        assert (this.switchMaps.isEmpty());
        return new AppInfoWithLiveness(this, switchMaps, this.enumValueInfoMaps);
    }

    public AppInfoWithLiveness addEnumValueInfoMaps(Map<DexType, Map<DexField, EnumValueInfo>> enumValueInfoMaps) {
        assert (this.checkIfObsolete());
        assert (this.enumValueInfoMaps.isEmpty());
        return new AppInfoWithLiveness(this, this.switchMaps, enumValueInfoMaps);
    }

    public static final class EnumValueInfo {
        public final DexType type;
        public final int ordinal;

        public EnumValueInfo(DexType type, int ordinal) {
            this.type = type;
            this.ordinal = ordinal;
        }
    }
}

