/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.graph.AccessControl;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.CachedHashValueDexItem;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoImpl;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.graph.ProgramMethod;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoEnqueuerUseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoEnqueuerExtension;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstantValueUtils;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryAPIConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierNameStringUtils;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AnnotationRemover;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.DefaultEnqueuerUseRegistry;
import shadow.bundletool.com.android.tools.r8.shaking.DelayedRootSetActionItem;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerUseRegistryFactory;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerUtils;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerWorklist;
import shadow.bundletool.com.android.tools.r8.shaking.GraphReporter;
import shadow.bundletool.com.android.tools.r8.shaking.IfRuleClassPartEquivalence;
import shadow.bundletool.com.android.tools.r8.shaking.IfRuleEvaluator;
import shadow.bundletool.com.android.tools.r8.shaking.KeepReason;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassFilter;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIfRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleBase;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.shaking.ScopedDexMethodSet;
import shadow.bundletool.com.android.tools.r8.utils.Action;
import shadow.bundletool.com.android.tools.r8.utils.DequeUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class Enqueuer {
    private final boolean forceProguardCompatibility;
    private final Mode mode;
    private Set<EnqueuerAnalysis> analyses = Sets.newIdentityHashSet();
    private final AppInfoWithSubtyping appInfo;
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private ProguardClassFilter dontWarnPatterns;
    private final EnqueuerUseRegistryFactory useRegistryFactory;
    private final Map<DexMethod, Set<DexEncodedMethod>> virtualInvokes = new IdentityHashMap<DexMethod, Set<DexEncodedMethod>>();
    private final Map<DexMethod, Set<DexEncodedMethod>> interfaceInvokes = new IdentityHashMap<DexMethod, Set<DexEncodedMethod>>();
    private final Map<DexMethod, Set<DexEncodedMethod>> superInvokes = new IdentityHashMap<DexMethod, Set<DexEncodedMethod>>();
    private final Map<DexMethod, Set<DexEncodedMethod>> directInvokes = new IdentityHashMap<DexMethod, Set<DexEncodedMethod>>();
    private final Map<DexMethod, Set<DexEncodedMethod>> staticInvokes = new IdentityHashMap<DexMethod, Set<DexEncodedMethod>>();
    private final FieldAccessInfoCollectionImpl fieldAccessInfoCollection = new FieldAccessInfoCollectionImpl();
    private final Set<DexCallSite> callSites = Sets.newIdentityHashSet();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final Map<DexProgramClass, ReachableVirtualMethodsSet> reachableVirtualMethods = Maps.newIdentityHashMap();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> superInvokeDependencies = Maps.newIdentityHashMap();
    private final Map<DexProgramClass, SetWithReason<DexEncodedField>> reachableInstanceFields = Maps.newIdentityHashMap();
    private final SetWithReportedReason<DexProgramClass> liveTypes;
    private final SetWithReportedReason<DexProgramClass> initializedTypes;
    private final Set<DexClass> liveNonProgramTypes = Sets.newIdentityHashSet();
    private final Map<DexProgramClass, Set<DexProgramClass>> unusedInterfaceTypes = new IdentityHashMap<DexProgramClass, Set<DexProgramClass>>();
    private final SetWithReason<DexAnnotation> liveAnnotations;
    private final SetWithReason<DexProgramClass> instantiatedTypes;
    private final Set<DexProgramClass> directAndIndirectlyInstantiatedTypes = Sets.newIdentityHashSet();
    private final SetWithReason<DexEncodedMethod> targetedMethods;
    private final Set<DexMethod> failedResolutionTargets;
    private final Set<DexMethod> bootstrapMethods = Sets.newIdentityHashSet();
    private final Set<DexMethod> methodsTargetedByInvokeDynamic = Sets.newIdentityHashSet();
    private final Set<DexMethod> lambdaMethodsTargetedByInvokeDynamic = Sets.newIdentityHashSet();
    private final Set<DexMethod> virtualMethodsTargetedByInvokeDirect = Sets.newIdentityHashSet();
    private final LiveMethodsSet liveMethods;
    private final SetWithReason<DexEncodedField> liveFields;
    private final Set<DexType> instantiatedAppServices = Sets.newIdentityHashSet();
    private final SetWithReason<DexProgramClass> instantiatedInterfaceTypes;
    private final EnqueuerWorklist workList;
    private final Set<DexEncodedMethod> pendingReflectiveUses = Sets.newLinkedHashSet();
    private final Map<DexMethod, MarkedResolutionTarget> virtualTargetsMarkedAsReachable = Maps.newIdentityHashMap();
    private final Set<DexReference> reportedMissing = Sets.newIdentityHashSet();
    private final Set<DexReference> pinnedItems = Sets.newIdentityHashSet();
    private final Set<DexType> constClassReferences = Sets.newIdentityHashSet();
    private final Map<DexType, Set<DexAnnotation>> deferredAnnotations = new IdentityHashMap<DexType, Set<DexAnnotation>>();
    private Map<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>> activeIfRules;
    private final Map<DexType, ScopedDexMethodSet> scopedMethodsForLiveTypes = new IdentityHashMap<DexType, ScopedDexMethodSet>();
    private final GraphReporter graphReporter;
    private Map<DexMethod, ProgramMethod> syntheticInterfaceMethodBridges = new IdentityHashMap<DexMethod, ProgramMethod>();

    Enqueuer(AppView<? extends AppInfoWithSubtyping> appView, GraphConsumer keptGraphConsumer, Mode mode) {
        assert (appView.appServices() != null);
        InternalOptions options = appView.options();
        this.appInfo = appView.appInfo();
        this.appView = appView;
        this.forceProguardCompatibility = options.forceProguardCompatibility;
        this.graphReporter = new GraphReporter(appView, keptGraphConsumer);
        this.mode = mode;
        this.options = options;
        this.useRegistryFactory = this.createUseRegistryFactory();
        this.workList = EnqueuerWorklist.createWorklist(appView);
        if (options.protoShrinking().enableGeneratedMessageLiteShrinking && mode.isInitialOrFinalTreeShaking()) {
            this.registerAnalysis(new ProtoEnqueuerExtension(appView));
        }
        this.liveTypes = new SetWithReportedReason();
        this.liveAnnotations = new SetWithReason<DexAnnotation>(this.graphReporter::registerAnnotation);
        this.initializedTypes = new SetWithReportedReason();
        this.instantiatedTypes = new SetWithReason<DexProgramClass>(this.graphReporter::registerClass);
        this.targetedMethods = new SetWithReason<DexEncodedMethod>(this.graphReporter::registerMethod);
        this.failedResolutionTargets = SetUtils.newIdentityHashSet(2);
        this.liveMethods = new LiveMethodsSet(this.graphReporter::registerMethod);
        this.liveFields = new SetWithReason<DexEncodedField>(this.graphReporter::registerField);
        this.instantiatedInterfaceTypes = new SetWithReason<DexProgramClass>(this.graphReporter::registerInterface);
    }

    public Mode getMode() {
        return this.mode;
    }

    public GraphReporter getGraphReporter() {
        return this.graphReporter;
    }

    private EnqueuerUseRegistryFactory createUseRegistryFactory() {
        if (this.mode.isFinalTreeShaking()) {
            return this.appView.withGeneratedMessageLiteShrinker(ignore -> ProtoEnqueuerUseRegistry.getFactory(), DefaultEnqueuerUseRegistry::new);
        }
        return DefaultEnqueuerUseRegistry::new;
    }

    public EnqueuerUseRegistryFactory getUseRegistryFactory() {
        return this.useRegistryFactory;
    }

    public Enqueuer registerAnalysis(EnqueuerAnalysis analysis) {
        this.analyses.add(analysis);
        return this;
    }

    private boolean isProgramClass(DexType type) {
        return this.getProgramClassOrNull(type) != null;
    }

    private DexProgramClass getProgramClassOrNull(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz != null) {
            if (clazz.isProgramClass()) {
                return clazz.asProgramClass();
            }
            if (this.liveNonProgramTypes.add(clazz) && clazz.isLibraryClass()) {
                this.ensureMethodsContinueToWidenAccess(clazz);
                this.warnIfLibraryTypeInheritsFromProgramType(clazz.asLibraryClass());
            }
        }
        this.reportMissingClass(type);
        return null;
    }

    private void warnIfLibraryTypeInheritsFromProgramType(DexLibraryClass clazz) {
        if (clazz.superType != null) {
            this.ensureFromLibraryOrThrow(clazz.superType, clazz);
        }
        for (DexType iface : clazz.interfaces.values) {
            this.ensureFromLibraryOrThrow(iface, clazz);
        }
    }

    private Set<DexField> getNonPinnedWrittenFields(Predicate<DexEncodedField> predicate) {
        Set<DexField> result = Sets.newIdentityHashSet();
        this.fieldAccessInfoCollection.forEach(info -> {
            if (info == FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO) {
                return;
            }
            DexEncodedField encodedField = this.appView.definitionFor(info.getField());
            if (encodedField == null) {
                assert (false);
                return;
            }
            if (encodedField.isProgramField(this.appInfo) && info.isWritten() && predicate.test(encodedField)) {
                result.add(encodedField.field);
            }
        });
        result.removeAll(this.pinnedItems.stream().filter(DexReference::isDexField).map(DexReference::asDexField).collect(Collectors.toSet()));
        return result;
    }

    private static <T> SetWithReason<T> newSetWithoutReasonReporter() {
        return new SetWithReason<Object>((f, r) -> {});
    }

    private void enqueueRootItems(Map<DexReference, Set<ProguardKeepRuleBase>> items) {
        items.entrySet().forEach(this::enqueueRootItem);
    }

    private void enqueueRootItem(Map.Entry<DexReference, Set<ProguardKeepRuleBase>> root) {
        DexDefinition item = this.appView.definitionFor(root.getKey());
        if (item != null) {
            this.enqueueRootItem(item, root.getValue());
        }
    }

    private void enqueueRootItem(DexDefinition item, Set<ProguardKeepRuleBase> rules) {
        this.internalEnqueueRootItem(item, rules, null);
    }

    private void internalEnqueueRootItem(DexDefinition item, Set<ProguardKeepRuleBase> rules, DexDefinition precondition) {
        if (item.isDexClass()) {
            DexProgramClass clazz = item.asDexClass().asProgramClass();
            GraphReporter.KeepReasonWitness witness = this.graphReporter.reportKeepClass(precondition, rules, clazz);
            if (clazz.isInterface() && !clazz.accessFlags.isAnnotation()) {
                this.markInterfaceAsInstantiated(clazz, witness);
            } else {
                this.workList.enqueueMarkInstantiatedAction(clazz, null, witness);
                if (clazz.hasDefaultInitializer()) {
                    DexEncodedMethod defaultInitializer = clazz.getDefaultInitializer();
                    if (this.forceProguardCompatibility) {
                        this.workList.enqueueMarkMethodKeptAction(clazz, defaultInitializer, this.graphReporter.reportCompatKeepDefaultInitializer(clazz, defaultInitializer));
                    }
                    if (clazz.isExternalizable(this.appView)) {
                        this.enqueueMarkMethodLiveAction(clazz, defaultInitializer, witness);
                    }
                }
            }
        } else if (item.isDexEncodedField()) {
            DexEncodedField dexEncodedField = item.asDexEncodedField();
            DexProgramClass holder = this.getProgramClassOrNull(dexEncodedField.field.holder);
            if (holder != null) {
                this.workList.enqueueMarkFieldKeptAction(holder, dexEncodedField, this.graphReporter.reportKeepField(precondition, rules, dexEncodedField));
            }
        } else if (item.isDexEncodedMethod()) {
            DexEncodedMethod encodedMethod = item.asDexEncodedMethod();
            DexProgramClass holder = this.getProgramClassOrNull(encodedMethod.method.holder);
            if (holder != null) {
                this.workList.enqueueMarkMethodKeptAction(holder, encodedMethod, this.graphReporter.reportKeepMethod(precondition, rules, encodedMethod));
            }
        } else {
            throw new IllegalArgumentException(item.toString());
        }
        this.pinnedItems.add(item.toReference());
    }

    private void markInterfaceAsInstantiated(DexProgramClass clazz, GraphReporter.KeepReasonWitness witness) {
        assert (clazz.isInterface() && !clazz.accessFlags.isAnnotation());
        if (!this.instantiatedInterfaceTypes.add(clazz, witness)) {
            return;
        }
        this.populateInstantiatedTypesCache(clazz);
        this.markTypeAsLive(clazz, witness);
    }

    private void enqueueFirstNonSerializableClassInitializer(DexProgramClass clazz, KeepReason reason) {
        assert (clazz.isSerializable(this.appView));
        while (clazz.isSerializable(this.appView)) {
            DexProgramClass superClass = this.getProgramClassOrNull(clazz.superType);
            if (superClass == null) {
                return;
            }
            clazz = superClass;
        }
        if (clazz.hasDefaultInitializer()) {
            this.enqueueMarkMethodLiveAction(clazz, clazz.getDefaultInitializer(), reason);
        }
    }

    private boolean enqueueMarkMethodLiveAction(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
        assert (method.method.holder == clazz.type);
        if (this.liveMethods.add(clazz, method, reason)) {
            this.workList.enqueueMarkMethodLiveAction(clazz, method, reason);
            return true;
        }
        return false;
    }

    private void compatEnqueueHolderIfDependentNonStaticMember(DexClass holder, Set<ProguardKeepRuleBase> compatRules) {
        if (!this.forceProguardCompatibility || compatRules == null) {
            return;
        }
        this.enqueueRootItem(holder, compatRules);
    }

    private boolean registerMethodWithTargetAndContext(Map<DexMethod, Set<DexEncodedMethod>> seen, DexMethod method, DexEncodedMethod context) {
        DexType baseHolder = method.holder.toBaseType(this.appView.dexItemFactory());
        if (baseHolder.isClassType()) {
            this.markTypeAsLive(baseHolder, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, context));
            return seen.computeIfAbsent(method, ignore -> Sets.newIdentityHashSet()).add(context);
        }
        return false;
    }

    public boolean registerFieldRead(DexField field, DexEncodedMethod context) {
        return this.registerFieldAccess(field, context, true);
    }

    public boolean registerFieldWrite(DexField field, DexEncodedMethod context) {
        return this.registerFieldAccess(field, context, false);
    }

    public boolean registerFieldAccess(DexField field, DexEncodedMethod context) {
        boolean changed = this.registerFieldAccess(field, context, true);
        return changed |= this.registerFieldAccess(field, context, false);
    }

    private boolean registerFieldAccess(DexField field, DexEncodedMethod context, boolean isRead) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field);
        if (info == null) {
            DexEncodedField encodedField = this.appInfo.resolveField(field);
            if (encodedField == null) {
                this.fieldAccessInfoCollection.extend(field, FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO);
                return true;
            }
            info = this.fieldAccessInfoCollection.get(encodedField.field);
            if (info == null) {
                info = new FieldAccessInfoImpl(encodedField.field);
                this.fieldAccessInfoCollection.extend(encodedField.field, info);
            }
            if (field != encodedField.field) {
                this.fieldAccessInfoCollection.extend(field, info);
            }
        } else if (info == FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO) {
            return false;
        }
        return isRead ? info.recordRead(field, context) : info.recordWrite(field, context);
    }

    void traceCallSite(DexCallSite callSite, ProgramMethod context) {
        LambdaDescriptor descriptor;
        DexProgramClass bootstrapClass;
        this.callSites.add(callSite);
        List<DexType> directInterfaces = LambdaDescriptor.getInterfaces(callSite, this.appInfo);
        if (directInterfaces != null) {
            for (DexType lambdaInstantiatedInterface : directInterfaces) {
                this.markLambdaInstantiated(lambdaInstantiatedInterface, context.method);
            }
        } else if (!this.appInfo.isStringConcat(callSite.bootstrapMethod) && this.options.reporter != null) {
            StringDiagnostic message = new StringDiagnostic("Unknown bootstrap method " + callSite.bootstrapMethod, context.holder.origin);
            this.options.reporter.warning(message);
        }
        if ((bootstrapClass = this.getProgramClassOrNull(callSite.bootstrapMethod.asMethod().holder)) != null) {
            this.bootstrapMethods.add(callSite.bootstrapMethod.asMethod());
        }
        if ((descriptor = LambdaDescriptor.tryInfer(callSite, this.appInfo)) == null) {
            return;
        }
        DexMethodHandle implHandle = descriptor.implHandle;
        assert (implHandle != null);
        DexMethod method = implHandle.asMethod();
        if (descriptor.delegatesToLambdaImplMethod()) {
            this.lambdaMethodsTargetedByInvokeDynamic.add(method);
        }
        if (!this.methodsTargetedByInvokeDynamic.add(method)) {
            return;
        }
        switch (implHandle.type) {
            case INVOKE_STATIC: {
                this.traceInvokeStaticFromLambda(method, context);
                break;
            }
            case INVOKE_INTERFACE: {
                this.traceInvokeInterfaceFromLambda(method, context);
                break;
            }
            case INVOKE_INSTANCE: {
                this.traceInvokeVirtualFromLambda(method, context);
                break;
            }
            case INVOKE_DIRECT: {
                this.traceInvokeDirectFromLambda(method, context);
                break;
            }
            case INVOKE_CONSTRUCTOR: {
                this.traceNewInstanceFromLambda(method.holder, context);
                break;
            }
            default: {
                throw new Unreachable();
            }
        }
        if (directInterfaces == null) {
            return;
        }
        ScopedDexMethodSet seen = new ScopedDexMethodSet();
        for (DexType iface : directInterfaces) {
            DexProgramClass ifaceClazz = this.getProgramClassOrNull(iface);
            if (ifaceClazz == null) continue;
            this.transitionDefaultMethodsForInstantiatedClass(iface, seen);
        }
    }

    boolean traceCheckCast(DexType type, DexEncodedMethod currentMethod) {
        return this.traceConstClassOrCheckCast(type, currentMethod);
    }

    boolean traceConstClass(DexType type, DexEncodedMethod currentMethod) {
        DexProgramClass baseClass;
        DexType baseType = type.toBaseType(this.appView.dexItemFactory());
        if (baseType.isClassType() && (baseClass = this.getProgramClassOrNull(baseType)) != null) {
            this.constClassReferences.add(baseType);
        }
        return this.traceConstClassOrCheckCast(type, currentMethod);
    }

    private boolean traceConstClassOrCheckCast(DexType type, DexEncodedMethod currentMethod) {
        if (!this.forceProguardCompatibility) {
            return this.traceTypeReference(type, currentMethod);
        }
        DexType baseType = type.toBaseType(this.appView.dexItemFactory());
        if (baseType.isClassType()) {
            DexProgramClass baseClass = this.getProgramClassOrNull(baseType);
            if (baseClass != null) {
                this.markClassAsInstantiatedWithCompatRule(baseClass, this.graphReporter.reportCompatInstantiated(baseClass, currentMethod));
            }
            return true;
        }
        return false;
    }

    void traceMethodHandle(DexMethodHandle methodHandle, UseRegistry.MethodHandleUse use, DexEncodedMethod currentMethod) {
        DexType type;
        DexProgramClass clazz;
        if (methodHandle.isMethodHandle() && use != UseRegistry.MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY && (clazz = this.getProgramClassOrNull(type = methodHandle.asMethod().holder)) != null) {
            KeepReason reason = KeepReason.methodHandleReferencedIn(currentMethod);
            if (clazz.isInterface() && !clazz.accessFlags.isAnnotation()) {
                this.markInterfaceAsInstantiated(clazz, this.graphReporter.registerInterface(clazz, reason));
            } else {
                this.markInstantiated(clazz, null, reason);
            }
        }
    }

    boolean traceTypeReference(DexType type, DexEncodedMethod currentMethod) {
        this.markTypeAsLive(type, this.classReferencedFromReporter(currentMethod));
        return true;
    }

    boolean traceInvokeDirect(DexMethod invokedMethod, ProgramMethod context) {
        DexEncodedMethod currentMethod = context.method;
        DexProgramClass currentHolder = context.holder;
        boolean skipTracing = this.registerDeferredActionForDeadProtoBuilder(invokedMethod.holder, currentMethod, () -> this.workList.enqueueTraceInvokeDirectAction(invokedMethod, currentHolder, currentMethod));
        if (skipTracing) {
            return false;
        }
        return this.traceInvokeDirect(invokedMethod, context, KeepReason.invokedFrom(currentHolder, currentMethod));
    }

    private boolean registerDeferredActionForDeadProtoBuilder(DexType type, DexEncodedMethod currentMethod, Action action) {
        DexProgramClass clazz = this.getProgramClassOrNull(type);
        if (clazz != null) {
            return this.appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.deferDeadProtoBuilders(clazz, currentMethod, () -> this.liveTypes.registerDeferredAction(clazz, action)), false);
        }
        return false;
    }

    boolean traceInvokeDirectFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeDirect(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context.method));
    }

    private boolean traceInvokeDirect(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        DexEncodedMethod currentMethod = context.method;
        if (!this.registerMethodWithTargetAndContext(this.directInvokes, invokedMethod, currentMethod)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeDirect `%s`.", invokedMethod);
        }
        this.handleInvokeOfDirectTarget(invokedMethod, reason);
        return true;
    }

    boolean traceInvokeInterface(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeInterface(invokedMethod, context, KeepReason.invokedFrom(context.holder, context.method));
    }

    boolean traceInvokeInterfaceFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeInterface(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context.method));
    }

    private boolean traceInvokeInterface(DexMethod method, ProgramMethod context, KeepReason keepReason) {
        DexEncodedMethod currentMethod = context.method;
        if (!this.registerMethodWithTargetAndContext(this.interfaceInvokes, method, currentMethod)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeInterface `%s`.", method);
        }
        this.markVirtualMethodAsReachable(method, true, context, keepReason);
        return true;
    }

    boolean traceInvokeStatic(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeStatic(invokedMethod, context, KeepReason.invokedFrom(context.holder, context.method));
    }

    boolean traceInvokeStaticFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeStatic(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context.method));
    }

    private boolean traceInvokeStatic(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        DexEncodedMethod currentMethod = context.method;
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (dexItemFactory.classMethods.isReflectiveClassLookup(invokedMethod) || dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod)) {
            this.identifierNameStrings.add(invokedMethod);
            this.pendingReflectiveUses.add(currentMethod);
        }
        if (invokedMethod == dexItemFactory.enumMethods.valueOf) {
            this.pendingReflectiveUses.add(currentMethod);
        }
        if (dexItemFactory.serviceLoaderMethods.isLoadMethod(invokedMethod)) {
            this.pendingReflectiveUses.add(currentMethod);
        }
        if (invokedMethod == dexItemFactory.proxyMethods.newProxyInstance) {
            this.pendingReflectiveUses.add(currentMethod);
        }
        if (!this.registerMethodWithTargetAndContext(this.staticInvokes, invokedMethod, currentMethod)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeStatic `%s`.", invokedMethod);
        }
        this.handleInvokeOfStaticTarget(invokedMethod, reason);
        return true;
    }

    boolean traceInvokeSuper(DexMethod invokedMethod, ProgramMethod context) {
        DexProgramClass currentHolder = context.holder;
        DexEncodedMethod currentMethod = context.method;
        DexMethod actualTarget = this.getInvokeSuperTarget(invokedMethod, currentMethod);
        if (!this.registerMethodWithTargetAndContext(this.superInvokes, invokedMethod, currentMethod)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeSuper `%s`.", actualTarget);
        }
        this.workList.enqueueMarkReachableSuperAction(invokedMethod, currentMethod);
        return true;
    }

    boolean traceInvokeVirtual(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeVirtual(invokedMethod, context, KeepReason.invokedFrom(context.holder, context.method));
    }

    boolean traceInvokeVirtualFromLambda(DexMethod invokedMethod, ProgramMethod context) {
        return this.traceInvokeVirtual(invokedMethod, context, KeepReason.invokedFromLambdaCreatedIn(context.method));
    }

    private boolean traceInvokeVirtual(DexMethod invokedMethod, ProgramMethod context, KeepReason reason) {
        if (invokedMethod == this.appView.dexItemFactory().classMethods.newInstance || invokedMethod == this.appView.dexItemFactory().constructorMethods.newInstance) {
            this.pendingReflectiveUses.add(context.method);
        } else if (this.appView.dexItemFactory().classMethods.isReflectiveMemberLookup(invokedMethod)) {
            this.identifierNameStrings.add(invokedMethod);
            this.pendingReflectiveUses.add(context.method);
        }
        if (!this.registerMethodWithTargetAndContext(this.virtualInvokes, invokedMethod, context.method)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register invokeVirtual `%s`.", invokedMethod);
        }
        this.markVirtualMethodAsReachable(invokedMethod, false, context, reason);
        return true;
    }

    boolean traceNewInstance(DexType type, ProgramMethod context) {
        DexEncodedMethod currentMethod = context.method;
        boolean skipTracing = this.registerDeferredActionForDeadProtoBuilder(type, currentMethod, () -> this.workList.enqueueTraceNewInstanceAction(type, context));
        if (skipTracing) {
            return false;
        }
        return this.traceNewInstance(type, context, KeepReason.instantiatedIn(currentMethod));
    }

    boolean traceNewInstanceFromLambda(DexType type, ProgramMethod context) {
        return this.traceNewInstance(type, context, KeepReason.invokedFromLambdaCreatedIn(context.method));
    }

    private boolean traceNewInstance(DexType type, ProgramMethod context, KeepReason keepReason) {
        DexEncodedMethod currentMethod = context.method;
        DexProgramClass clazz = this.getProgramClassOrNull(type);
        if (clazz != null) {
            if (clazz.isInterface()) {
                this.markTypeAsLive(clazz, this.graphReporter.registerClass(clazz, keepReason));
            } else {
                this.markInstantiated(clazz, currentMethod, keepReason);
            }
        }
        return true;
    }

    boolean traceInstanceFieldRead(DexField field, DexEncodedMethod currentMethod) {
        if (!this.registerFieldRead(field, currentMethod)) {
            return false;
        }
        this.markFieldAsTargeted(field, currentMethod);
        DexEncodedField encodedField = this.appInfo.resolveField(field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return false;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(encodedField.field.holder);
        if (clazz == null) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register Iget `%s`.", field);
        }
        if (this.appView.options().enableUnusedInterfaceRemoval && encodedField.field != field) {
            this.markTypeAsLive(clazz, this.graphReporter.reportClassReferencedFrom(clazz, currentMethod));
            this.markTypeAsLive(encodedField.field.type, this.classReferencedFromReporter(currentMethod));
        }
        this.workList.enqueueMarkReachableFieldAction(clazz, encodedField, KeepReason.fieldReferencedIn(currentMethod));
        return true;
    }

    boolean traceInstanceFieldWrite(DexField field, DexEncodedMethod currentMethod) {
        if (!this.registerFieldWrite(field, currentMethod)) {
            return false;
        }
        this.markFieldAsTargeted(field, currentMethod);
        DexEncodedField encodedField = this.appInfo.resolveField(field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return false;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(encodedField.field.holder);
        if (clazz == null) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register Iput `%s`.", field);
        }
        if (this.appView.options().enableUnusedInterfaceRemoval && encodedField.field != field) {
            this.markTypeAsLive(clazz, this.graphReporter.reportClassReferencedFrom(clazz, currentMethod));
            this.markTypeAsLive(encodedField.field.type, this.classReferencedFromReporter(currentMethod));
        }
        KeepReason reason = KeepReason.fieldReferencedIn(currentMethod);
        this.workList.enqueueMarkReachableFieldAction(clazz, encodedField, reason);
        return true;
    }

    boolean traceStaticFieldRead(DexField field, DexEncodedMethod currentMethod) {
        boolean skipTracing;
        if (!this.registerFieldRead(field, currentMethod)) {
            return false;
        }
        DexEncodedField encodedField = this.appInfo.resolveField(field);
        if (encodedField == null) {
            this.markFieldAsTargeted(field, currentMethod);
            this.reportMissingField(field);
            return false;
        }
        if (!this.isProgramClass(encodedField.field.holder)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register Sget `%s`.", field);
        }
        if (this.appView.options().protoShrinking().enableGeneratedExtensionRegistryShrinking && (skipTracing = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(encodedField, this.fieldAccessInfoCollection, this.pinnedItems), false).booleanValue())) {
            return false;
        }
        if (encodedField.field != field) {
            this.markFieldAsTargeted(field, currentMethod);
        }
        this.markStaticFieldAsLive(encodedField, KeepReason.fieldReferencedIn(currentMethod));
        return true;
    }

    boolean traceStaticFieldWrite(DexField field, DexEncodedMethod currentMethod) {
        boolean skipTracing;
        if (!this.registerFieldWrite(field, currentMethod)) {
            return false;
        }
        DexEncodedField encodedField = this.appInfo.resolveField(field);
        if (encodedField == null) {
            this.markFieldAsTargeted(field, currentMethod);
            this.reportMissingField(field);
            return false;
        }
        if (!this.isProgramClass(encodedField.field.holder)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register Sput `%s`.", field);
        }
        if (this.appView.options().protoShrinking().enableGeneratedExtensionRegistryShrinking && (skipTracing = this.appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(encodedField, this.fieldAccessInfoCollection, this.pinnedItems), false).booleanValue())) {
            return false;
        }
        if (encodedField.field != field) {
            this.markFieldAsTargeted(field, currentMethod);
        }
        this.markStaticFieldAsLive(encodedField, KeepReason.fieldReferencedIn(currentMethod));
        return true;
    }

    private Function<DexProgramClass, GraphReporter.KeepReasonWitness> classReferencedFromReporter(DexEncodedMethod currentMethod) {
        return clazz -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, currentMethod);
    }

    private void transitionReachableVirtualMethods(DexProgramClass clazz, ScopedDexMethodSet seen) {
        ReachableVirtualMethodsSet reachableMethods = this.reachableVirtualMethods.get(clazz);
        if (reachableMethods != null) {
            this.transitionNonAbstractMethodsToLiveAndShadow(clazz, reachableMethods, seen);
        }
    }

    private DexMethod getInvokeSuperTarget(DexMethod method, DexEncodedMethod currentMethod) {
        DexClass methodHolderClass = this.appView.definitionFor(method.holder);
        if (methodHolderClass != null && methodHolderClass.isInterface()) {
            return method;
        }
        DexClass holderClass = this.appView.definitionFor(currentMethod.method.holder);
        if (holderClass == null || holderClass.superType == null || holderClass.isInterface()) {
            return method;
        }
        return this.appView.dexItemFactory().createMethod(holderClass.superType, method.proto, method.name);
    }

    private boolean verifyMethodIsTargeted(DexEncodedMethod method) {
        assert (!method.isClassInitializer()) : "Class initializers are never targeted";
        assert (this.targetedMethods.contains(method));
        return true;
    }

    private boolean verifyTypeIsLive(DexProgramClass clazz) {
        assert (this.liveTypes.contains(clazz));
        return true;
    }

    private void markTypeAsLive(DexType type, KeepReason reason) {
        if (type.isArrayType()) {
            this.markTypeAsLive(type.toBaseType(this.appView.dexItemFactory()), reason);
            return;
        }
        if (!type.isClassType()) {
            return;
        }
        DexProgramClass holder = this.getProgramClassOrNull(type);
        if (holder == null) {
            return;
        }
        this.markTypeAsLive(holder, this.scopedMethodsForLiveTypes.computeIfAbsent(type, ignore -> new ScopedDexMethodSet()), this.graphReporter.registerClass(holder, reason));
    }

    private void markTypeAsLive(DexType type, Function<DexProgramClass, GraphReporter.KeepReasonWitness> reason) {
        if (type.isArrayType()) {
            this.markTypeAsLive(type.toBaseType(this.appView.dexItemFactory()), reason);
            return;
        }
        if (!type.isClassType()) {
            return;
        }
        DexProgramClass holder = this.getProgramClassOrNull(type);
        if (holder == null) {
            return;
        }
        this.markTypeAsLive(holder, this.scopedMethodsForLiveTypes.computeIfAbsent(type, ignore -> new ScopedDexMethodSet()), reason.apply(holder));
    }

    private void markTypeAsLive(DexProgramClass clazz, GraphReporter.KeepReasonWitness witness) {
        this.markTypeAsLive(clazz, this.scopedMethodsForLiveTypes.computeIfAbsent(clazz.type, ignore -> new ScopedDexMethodSet()), witness);
    }

    private void markTypeAsLive(DexProgramClass holder, ScopedDexMethodSet seen, GraphReporter.KeepReasonWitness witness) {
        Set<DexAnnotation> annotations;
        if (!this.liveTypes.add(holder, witness)) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Type `%s` has become live.", holder.type);
        }
        KeepReason reason = KeepReason.reachableFromLiveType(holder.type);
        for (DexType iface : holder.interfaces.values) {
            this.markInterfaceTypeAsLiveViaInheritanceClause(iface, holder);
        }
        if (holder.superType != null) {
            ScopedDexMethodSet seenForSuper = this.scopedMethodsForLiveTypes.computeIfAbsent(holder.superType, ignore -> new ScopedDexMethodSet());
            seen.setParent(seenForSuper);
            this.markTypeAsLive(holder.superType, reason);
        }
        this.transitionUnusedInterfaceToLive(holder);
        this.ensureMethodsContinueToWidenAccess(holder, seen, reason);
        if (holder.isSerializable(this.appView)) {
            this.enqueueFirstNonSerializableClassInitializer(holder, reason);
        }
        if (!holder.annotations.isEmpty()) {
            this.processAnnotations(holder, holder.annotations.annotations);
        }
        if ((annotations = this.deferredAnnotations.remove(holder.type)) != null && !annotations.isEmpty()) {
            assert (holder.accessFlags.isAnnotation());
            assert (annotations.stream().allMatch(a -> a.annotation.type == holder.type));
            annotations.forEach(annotation -> this.handleAnnotation(holder, (DexAnnotation)annotation));
        }
        this.rootSet.forEachDependentStaticMember(holder, this.appView, this::enqueueDependentItem);
        this.compatEnqueueHolderIfDependentNonStaticMember(holder, this.rootSet.getDependentKeepClassCompatRule(holder.getType()));
    }

    private void ensureMethodsContinueToWidenAccess(DexClass clazz) {
        assert (!clazz.isProgramClass());
        ScopedDexMethodSet seen = this.scopedMethodsForLiveTypes.computeIfAbsent(clazz.type, ignore -> new ScopedDexMethodSet());
        clazz.virtualMethods().forEach(seen::addMethodIfMoreVisible);
    }

    private void ensureMethodsContinueToWidenAccess(DexProgramClass clazz, ScopedDexMethodSet seen, KeepReason reason) {
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (seen.addMethodIfMoreVisible(method) != ScopedDexMethodSet.AddMethodIfMoreVisibleResult.ADDED_MORE_VISIBLE || !clazz.isProgramClass() || !this.appView.appInfo().methodDefinedInInterfaces(method, clazz.type)) continue;
            this.markMethodAsTargeted(clazz, method, reason);
        }
    }

    private void markInterfaceTypeAsLiveViaInheritanceClause(DexType type, DexProgramClass implementer) {
        DexProgramClass clazz = this.getProgramClassOrNull(type);
        if (clazz == null) {
            return;
        }
        if (!this.appView.options().enableUnusedInterfaceRemoval || this.mode.isTracingMainDex()) {
            this.markTypeAsLive(clazz, this.graphReporter.reportClassReferencedFrom(clazz, implementer));
        } else if (this.liveTypes.contains(clazz)) {
            this.graphReporter.reportClassReferencedFrom(clazz, implementer);
        } else {
            this.unusedInterfaceTypes.computeIfAbsent(clazz, ignore -> Sets.newIdentityHashSet()).add(implementer);
        }
    }

    private void enqueueDependentItem(DexDefinition precondition, DexDefinition consequent, Set<ProguardKeepRuleBase> reasons) {
        this.internalEnqueueRootItem(consequent, reasons, precondition);
    }

    private void processAnnotations(DexDefinition holder, DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            this.processAnnotation(holder, annotation);
        }
    }

    private void processAnnotation(DexDefinition holder, DexAnnotation annotation) {
        this.handleAnnotation(holder, annotation);
    }

    private void handleAnnotation(DexDefinition holder, DexAnnotation annotation) {
        boolean isLive;
        assert (!holder.isDexClass() || holder.asDexClass().isProgramClass());
        DexType type = annotation.annotation.type;
        DexClass clazz = this.appView.definitionFor(type);
        boolean annotationTypeIsLibraryClass = clazz == null || clazz.isNotProgramClass();
        boolean bl = isLive = annotationTypeIsLibraryClass || this.liveTypes.contains(clazz.asProgramClass());
        if (!AnnotationRemover.shouldKeepAnnotation(holder, annotation, isLive, this.appView)) {
            if (!annotationTypeIsLibraryClass) {
                this.deferredAnnotations.computeIfAbsent(type, ignore -> new HashSet()).add(annotation);
            }
            return;
        }
        KeepReason reason = KeepReason.annotatedOn(holder);
        this.liveAnnotations.add(annotation, reason);
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation.annotation.type, this.appView.dexItemFactory(), reason);
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    private ResolutionResult resolveMethod(DexMethod method, KeepReason reason) {
        ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult.isFailedResolution()) {
            this.reportMissingMethod(method);
            this.markFailedResolutionTargets(method, resolutionResult.asFailedResolution(), reason);
        }
        return resolutionResult;
    }

    private void handleInvokeOfStaticTarget(DexMethod method, KeepReason reason) {
        ResolutionResult.SingleResolutionResult resolution = this.resolveMethod(method, reason).asSingleResolution();
        if (resolution == null || resolution.getResolvedHolder().isNotProgramClass()) {
            return;
        }
        DexProgramClass clazz = resolution.getResolvedHolder().asProgramClass();
        DexEncodedMethod encodedMethod = resolution.getResolvedMethod();
        this.markMethodAsTargeted(clazz, encodedMethod, reason);
        if (encodedMethod.isStatic()) {
            this.markDirectAndIndirectClassInitializersAsLive(clazz);
            this.markDirectStaticOrConstructorMethodAsLive(clazz, encodedMethod, reason);
        }
    }

    private void markDirectAndIndirectClassInitializersAsLive(DexProgramClass clazz) {
        Deque<DexProgramClass> worklist = DequeUtils.newArrayDeque(clazz);
        Set<DexProgramClass> visited = SetUtils.newIdentityHashSet(clazz);
        while (!worklist.isEmpty()) {
            DexProgramClass current = worklist.removeFirst();
            assert (visited.contains(current));
            if (!this.markDirectClassInitializerAsLive(current)) continue;
            for (DexType superType : clazz.allImmediateSupertypes()) {
                DexProgramClass superClass = this.getProgramClassOrNull(superType);
                if (superClass == null || !visited.add(superClass)) continue;
                worklist.add(superClass);
            }
        }
    }

    private boolean markDirectClassInitializerAsLive(DexProgramClass clazz) {
        DexEncodedMethod clinit = clazz.getClassInitializer();
        GraphReporter.KeepReasonWitness witness = this.graphReporter.reportReachableClassInitializer(clazz, clinit);
        if (!this.initializedTypes.add(clazz, witness)) {
            return false;
        }
        if (clinit != null && clinit.getOptimizationInfo().mayHaveSideEffects()) {
            this.markDirectStaticOrConstructorMethodAsLive(clazz, clinit, witness);
        }
        return true;
    }

    void markNonStaticDirectMethodAsReachable(DexMethod method, KeepReason reason) {
        this.handleInvokeOfDirectTarget(method, reason);
    }

    private void handleInvokeOfDirectTarget(DexMethod method, KeepReason reason) {
        DexType holder = method.holder;
        DexProgramClass clazz = this.getProgramClassOrNull(holder);
        if (clazz == null) {
            return;
        }
        DexEncodedMethod encodedMethod = clazz.lookupMethod(method);
        if (encodedMethod == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(clazz, encodedMethod, reason);
        if (encodedMethod.isStatic()) {
            return;
        }
        this.markDirectStaticOrConstructorMethodAsLive(clazz, encodedMethod, reason);
        if (encodedMethod.isNonPrivateVirtualMethod() && this.virtualMethodsTargetedByInvokeDirect.add(encodedMethod.method)) {
            this.enqueueMarkMethodLiveAction(clazz, encodedMethod, reason);
        }
    }

    private void ensureFromLibraryOrThrow(DexType type, DexClass context) {
        if (!this.mode.isInitialTreeShaking()) {
            return;
        }
        if (this.dontWarnPatterns.matches(context.type)) {
            return;
        }
        DexClass holder = this.appView.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            StringDiagnostic message = new StringDiagnostic("Library class " + context.type.toSourceString() + (holder.isInterface() ? " implements " : " extends ") + "program class " + type.toSourceString());
            if (this.forceProguardCompatibility) {
                this.options.reporter.warning(message);
            } else {
                this.options.reporter.error(message);
            }
        }
    }

    private void reportMissingClass(DexType clazz) {
        if (Log.ENABLED && this.reportedMissing.add(clazz)) {
            Log.verbose(Enqueuer.class, "Class `%s` is missing.", clazz);
        }
    }

    private void reportMissingMethod(DexMethod method) {
        if (Log.ENABLED && this.reportedMissing.add(method)) {
            Log.verbose(Enqueuer.class, "Method `%s` is missing.", method);
        }
    }

    private void reportMissingField(DexField field) {
        if (Log.ENABLED && this.reportedMissing.add(field)) {
            Log.verbose(Enqueuer.class, "Field `%s` is missing.", field);
        }
    }

    private void markMethodAsTargeted(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
        assert (method.method.holder == clazz.type);
        if (!this.targetedMethods.add(method, reason)) {
            return;
        }
        this.markReferencedTypesAsLive(method);
        this.processAnnotations(method, method.annotations.annotations);
        method.parameterAnnotationsList.forEachAnnotation(annotation -> this.processAnnotation(method, (DexAnnotation)annotation));
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Method `%s` is targeted.", method.method);
        }
        if (this.forceProguardCompatibility && !method.accessFlags.isAbstract() && clazz.isInterface()) {
            this.markMethodAsLiveWithCompatRule(clazz, method);
        }
    }

    void processNewlyInstantiatedClass(DexProgramClass clazz, DexEncodedMethod context, KeepReason reason) {
        assert (!clazz.isInterface() || clazz.accessFlags.isAnnotation());
        this.analyses.forEach(analysis -> analysis.processNewlyInstantiatedClass(clazz.asProgramClass(), context));
        if (!this.instantiatedTypes.add(clazz, reason)) {
            return;
        }
        this.populateInstantiatedTypesCache(clazz);
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Class `%s` is instantiated, processing...", clazz);
        }
        this.markTypeAsLive(clazz, this.graphReporter.registerClass(clazz, reason));
        this.markDirectAndIndirectClassInitializersAsLive(clazz);
        this.transitionMethodsForInstantiatedClass(clazz);
        this.transitionFieldsForInstantiatedClass(clazz);
        this.transitionDependentItemsForInstantiatedClass(clazz);
    }

    private void populateInstantiatedTypesCache(DexProgramClass clazz) {
        DexProgramClass superClass;
        if (!this.directAndIndirectlyInstantiatedTypes.add(clazz)) {
            return;
        }
        if (clazz.superType != null && (superClass = this.getProgramClassOrNull(clazz.superType)) != null) {
            this.populateInstantiatedTypesCache(superClass);
        }
        for (DexType iface : clazz.interfaces.values) {
            DexProgramClass ifaceClass = this.getProgramClassOrNull(iface);
            if (ifaceClass == null) continue;
            this.populateInstantiatedTypesCache(ifaceClass);
        }
    }

    private void transitionMethodsForInstantiatedClass(DexProgramClass instantiatedClass) {
        ScopedDexMethodSet seen = new ScopedDexMethodSet();
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        DexProgramClass current = instantiatedClass;
        do {
            this.transitionReachableVirtualMethods(current, seen);
            Collections.addAll(interfaces, current.interfaces.values);
        } while ((current = this.getProgramClassOrNull(current.superType)) != null && !this.instantiatedTypes.contains(current));
        for (DexType iface : interfaces) {
            DexClass clazz = this.appView.definitionFor(iface);
            if (clazz == null) {
                this.reportMissingClass(iface);
                break;
            }
            this.transitionDefaultMethodsForInstantiatedClass(iface, seen);
        }
        if (this.getMode().isTracingMainDex()) {
            return;
        }
        ArrayDeque<DexClass> librarySearchItems = new ArrayDeque<DexClass>();
        librarySearchItems.add(instantiatedClass);
        while (!librarySearchItems.isEmpty()) {
            DexClass superClass;
            DexClass clazz = (DexClass)librarySearchItems.pop();
            if (clazz.isNotProgramClass()) {
                this.markLibraryAndClasspathMethodOverridesAsLive(clazz, instantiatedClass);
            }
            if (clazz.superType != null && (superClass = this.appView.definitionFor(clazz.superType)) != null) {
                librarySearchItems.add(superClass);
            }
            for (DexType iface : clazz.interfaces.values) {
                DexClass ifaceClass = this.appView.definitionFor(iface);
                if (ifaceClass == null) continue;
                librarySearchItems.add(ifaceClass);
            }
        }
    }

    private void markLibraryAndClasspathMethodOverridesAsLive(DexClass libraryClass, DexProgramClass instantiatedClass) {
        assert (libraryClass.isNotProgramClass());
        assert (!instantiatedClass.isInterface() || instantiatedClass.accessFlags.isAnnotation());
        for (DexEncodedMethod method : libraryClass.virtualMethods()) {
            ResolutionResult firstResolution = this.appView.appInfo().resolveMethod(instantiatedClass, method.method);
            this.markResolutionAsLive(libraryClass, firstResolution);
            if (this.appView.rewritePrefix.hasRewrittenTypeInSignature(method.method.proto)) {
                DexMethod methodToResolve = DesugaredLibraryAPIConverter.methodWithVivifiedTypeInSignature(method.method, method.method.holder, this.appView);
                assert (methodToResolve != method.method);
                ResolutionResult secondResolution = this.appView.appInfo().resolveMethod(instantiatedClass, methodToResolve);
                this.markResolutionAsLive(libraryClass, secondResolution);
            }
            this.markOverridesAsLibraryMethodOverrides(method, instantiatedClass);
        }
    }

    private void markResolutionAsLive(DexClass libraryClass, ResolutionResult resolution) {
        if (resolution.isVirtualTarget()) {
            DexEncodedMethod target = resolution.getSingleTarget();
            DexProgramClass targetHolder = this.getProgramClassOrNull(target.method.holder);
            if (targetHolder != null && this.shouldMarkLibraryMethodOverrideAsReachable(targetHolder, target)) {
                this.markVirtualMethodAsLive(targetHolder, target, KeepReason.isLibraryMethod(targetHolder, libraryClass.type));
            }
        }
    }

    private void markOverridesAsLibraryMethodOverrides(DexEncodedMethod libraryMethod, DexProgramClass instantiatedClass) {
        Set<DexProgramClass> visited = SetUtils.newIdentityHashSet(instantiatedClass);
        Deque<DexProgramClass> worklist = DequeUtils.newArrayDeque(instantiatedClass);
        while (!worklist.isEmpty()) {
            DexProgramClass clazz = worklist.removeFirst();
            assert (visited.contains(clazz));
            DexEncodedMethod libraryMethodOverride = clazz.lookupVirtualMethod(libraryMethod.method);
            if (libraryMethodOverride != null) {
                if (libraryMethodOverride.isLibraryMethodOverride().isTrue()) continue;
                libraryMethodOverride.setLibraryMethodOverride(OptionalBool.TRUE);
            }
            for (DexType superType : clazz.allImmediateSupertypes()) {
                DexProgramClass superClass = this.getProgramClassOrNull(superType);
                if (superClass == null || !visited.add(superClass)) continue;
                worklist.add(superClass);
            }
        }
    }

    private void transitionDefaultMethodsForInstantiatedClass(DexType iface, ScopedDexMethodSet seen) {
        DexProgramClass clazz = this.getProgramClassOrNull(iface);
        if (clazz == null) {
            return;
        }
        assert (clazz.accessFlags.isInterface());
        this.transitionReachableVirtualMethods(clazz, seen.newNestedScope());
        for (DexType subInterface : clazz.interfaces.values) {
            this.transitionDefaultMethodsForInstantiatedClass(subInterface, seen);
        }
    }

    private void transitionNonAbstractMethodsToLiveAndShadow(DexProgramClass clazz, ReachableVirtualMethodsSet reachable, ScopedDexMethodSet seen) {
        for (DexEncodedMethod encodedMethod : reachable.getMethods()) {
            if (!seen.addMethod(encodedMethod) || encodedMethod.accessFlags.isAbstract()) continue;
            this.markVirtualMethodAsLive(clazz, encodedMethod, this.graphReporter.reportReachableMethodAsLive(encodedMethod, reachable.getReasons(encodedMethod)));
        }
    }

    private void transitionFieldsForInstantiatedClass(DexProgramClass clazz) {
        do {
            SetWithReason<DexEncodedField> reachableFields;
            if ((reachableFields = this.reachableInstanceFields.get(clazz)) == null) continue;
            for (DexEncodedField field : reachableFields.getItems()) {
                this.markInstanceFieldAsLive(field, KeepReason.reachableFromLiveType(clazz.type));
            }
        } while ((clazz = this.getProgramClassOrNull(clazz.superType)) != null && !this.instantiatedTypes.contains(clazz));
    }

    private void transitionDependentItemsForInstantiatedClass(DexClass clazz) {
        DexClass current = clazz;
        do {
            this.rootSet.forEachDependentNonStaticMember(current, this.appView, this::enqueueDependentItem);
            DexClass dexClass = current = current.superType != null ? this.appView.definitionFor(current.superType) : null;
        } while (current != null && current.isProgramClass() && !this.instantiatedTypes.contains(current.asProgramClass()));
    }

    private void transitionUnusedInterfaceToLive(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            Set<DexProgramClass> implementedBy = this.unusedInterfaceTypes.remove(clazz);
            if (implementedBy != null) {
                for (DexProgramClass implementer : implementedBy) {
                    this.markTypeAsLive(clazz, this.graphReporter.reportClassReferencedFrom(clazz, implementer));
                }
            }
        } else assert (!this.unusedInterfaceTypes.containsKey(clazz));
    }

    private void markFieldAsTargeted(DexField field, DexEncodedMethod context) {
        this.markTypeAsLive(field.type, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, context));
        this.markTypeAsLive(field.holder, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, context));
    }

    private void markStaticFieldAsLive(DexEncodedField encodedField, KeepReason reason) {
        DexField field = encodedField.field;
        this.markTypeAsLive(field.holder, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, encodedField));
        this.markTypeAsLive(field.type, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, encodedField));
        DexProgramClass clazz2 = this.getProgramClassOrNull(field.holder);
        if (clazz2 == null) {
            return;
        }
        this.markDirectAndIndirectClassInitializersAsLive(clazz2);
        if (encodedField.accessFlags.isStatic()) {
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Adding static field `%s` to live set.", encodedField.field);
            }
        } else if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Adding instance field `%s` to live set (static context).", encodedField.field);
        }
        this.processAnnotations(encodedField, encodedField.annotations.annotations);
        this.liveFields.add(encodedField, reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(encodedField));
        this.analyses.forEach(analysis -> analysis.processNewlyLiveField(encodedField));
    }

    private void markInstanceFieldAsLive(DexEncodedField field, KeepReason reason) {
        assert (field != null);
        assert (field.isProgramField(this.appView));
        this.markTypeAsLive(field.field.holder, reason);
        this.markTypeAsLive(field.field.type, reason);
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Adding instance field `%s` to live set.", field.field);
        }
        this.processAnnotations(field, field.annotations.annotations);
        this.liveFields.add(field, reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(field));
        this.analyses.forEach(analysis -> analysis.processNewlyLiveField(field));
    }

    private void markInstantiated(DexProgramClass clazz, DexEncodedMethod context, KeepReason reason) {
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Register new instantiation of `%s`.", clazz);
        }
        this.workList.enqueueMarkInstantiatedAction(clazz, context, reason);
    }

    private void markLambdaInstantiated(DexType itf, DexEncodedMethod method) {
        DexClass clazz = this.appView.definitionFor(itf);
        if (clazz == null) {
            StringDiagnostic message = new StringDiagnostic("Lambda expression implements missing interface `" + itf.toSourceString() + "`", this.appInfo.originFor(method.method.holder));
            this.options.reporter.warning(message);
            return;
        }
        if (!clazz.isInterface()) {
            StringDiagnostic message = new StringDiagnostic("Lambda expression expected to implement an interface, but found `" + itf.toSourceString() + "`", this.appInfo.originFor(method.method.holder));
            this.options.reporter.warning(message);
            return;
        }
        if (clazz.isProgramClass()) {
            KeepReason reason = KeepReason.instantiatedIn(method);
            if (this.instantiatedInterfaceTypes.add(clazz.asProgramClass(), reason)) {
                this.populateInstantiatedTypesCache(clazz.asProgramClass());
            }
        }
    }

    private void markDirectStaticOrConstructorMethodAsLive(DexProgramClass clazz, DexEncodedMethod encodedMethod, KeepReason reason) {
        assert (encodedMethod.method.holder == clazz.type);
        if (!this.enqueueMarkMethodLiveAction(clazz, encodedMethod, reason)) {
            return;
        }
        DexMethod method = encodedMethod.method;
        assert (encodedMethod.isClassInitializer() || this.verifyMethodIsTargeted(encodedMethod));
        assert (this.verifyTypeIsLive(clazz));
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Method `%s` has become live due to direct invoke", encodedMethod.method);
        }
    }

    private void markVirtualMethodAsLive(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
        assert (method != null);
        assert (!method.accessFlags.isAbstract() || reason.isDueToKeepRule() || reason.isDueToReflectiveUse());
        if (this.enqueueMarkMethodLiveAction(clazz, method, reason) && Log.ENABLED) {
            Log.verbose(this.getClass(), "Adding virtual method `%s` to live set.", method.method);
        }
    }

    public boolean isFieldLive(DexEncodedField field) {
        return this.liveFields.contains(field);
    }

    public boolean isFieldRead(DexEncodedField field) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field.field);
        return info != null && info.isRead();
    }

    public boolean isFieldWrittenInMethodSatisfying(DexEncodedField field, Predicate<DexEncodedMethod> predicate) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field.field);
        return info != null && info.isWrittenInMethodSatisfying(predicate);
    }

    public boolean isFieldWrittenOutsideDefaultConstructor(DexEncodedField field) {
        FieldAccessInfoImpl info = this.fieldAccessInfoCollection.get(field.field);
        if (info == null) {
            return false;
        }
        DexClass clazz = this.appView.definitionFor(field.field.holder);
        DexEncodedMethod defaultInitializer = clazz.getDefaultInitializer();
        return defaultInitializer != null ? info.isWrittenOutside(defaultInitializer) : info.isWritten();
    }

    private boolean isInstantiatedOrHasInstantiatedSubtype(DexProgramClass clazz) {
        return this.directAndIndirectlyInstantiatedTypes.contains(clazz);
    }

    void markInstanceFieldAsReachable(DexEncodedField encodedField, KeepReason reason) {
        DexField field = encodedField.field;
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Marking instance field `%s` as reachable.", field);
        }
        this.markTypeAsLive(field.holder, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, encodedField));
        this.markTypeAsLive(field.type, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, encodedField));
        DexProgramClass clazz2 = this.getProgramClassOrNull(field.holder);
        if (clazz2 == null) {
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(encodedField, reason);
        } else if (this.isInstantiatedOrHasInstantiatedSubtype(clazz2)) {
            this.markInstanceFieldAsLive(encodedField, reason);
        } else {
            this.reachableInstanceFields.computeIfAbsent(clazz2, ignore -> Enqueuer.newSetWithoutReasonReporter()).add(encodedField, reason);
        }
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, ProgramMethod contextOrNull, KeepReason reason) {
        if (method.holder.isArrayType()) {
            this.markTypeAsLive(method.holder, reason);
            return;
        }
        DexProgramClass holder = this.getProgramClassOrNull(method.holder);
        if (holder == null) {
            return;
        }
        MarkedResolutionTarget resolution = this.virtualTargetsMarkedAsReachable.get(method);
        if (resolution != null) {
            if (!resolution.isUnresolved()) {
                this.graphReporter.registerMethod(resolution.method, reason);
            }
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Marking virtual method `%s` as reachable.", method);
        }
        resolution = this.findAndMarkResolutionTarget(method, interfaceInvoke, reason);
        if (contextOrNull != null && !resolution.isUnresolved() && !AccessControl.isMethodAccessible(resolution.method, holder, contextOrNull.holder, this.appInfo)) {
            return;
        }
        this.virtualTargetsMarkedAsReachable.put(method, resolution);
        if (resolution.isUnresolved() || !resolution.method.isVirtualMethod()) {
            return;
        }
        assert (resolution.holder.isProgramClass());
        assert (interfaceInvoke == holder.isInterface());
        Set<DexEncodedMethod> possibleTargets = new ResolutionResult.SingleResolutionResult(holder, resolution.holder, resolution.method).lookupVirtualDispatchTargets(interfaceInvoke, this.appInfo);
        if (possibleTargets == null || possibleTargets.isEmpty()) {
            return;
        }
        for (DexEncodedMethod encodedPossibleTarget : possibleTargets) {
            if (encodedPossibleTarget.isAbstract()) continue;
            this.markPossibleTargetsAsReachable(resolution, encodedPossibleTarget);
        }
    }

    private void markPossibleTargetsAsReachable(MarkedResolutionTarget reason, DexEncodedMethod encodedPossibleTarget) {
        assert (encodedPossibleTarget.isVirtualMethod());
        assert (!encodedPossibleTarget.isAbstract());
        DexMethod possibleTarget = encodedPossibleTarget.method;
        DexProgramClass clazz = this.getProgramClassOrNull(possibleTarget.holder);
        if (clazz == null) {
            return;
        }
        ReachableVirtualMethodsSet reachable = this.reachableVirtualMethods.computeIfAbsent(clazz, ignore -> new ReachableVirtualMethodsSet());
        if (!reachable.add(encodedPossibleTarget, reason)) {
            return;
        }
        if (!this.isInstantiatedOrHasInstantiatedSubtype(clazz)) {
            return;
        }
        if (this.instantiatedTypes.contains(clazz) || this.instantiatedInterfaceTypes.contains(clazz) || this.pinnedItems.contains(clazz.type)) {
            this.markVirtualMethodAsLive(clazz, encodedPossibleTarget, this.graphReporter.reportReachableMethodAsLive(encodedPossibleTarget, reason));
        } else {
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(this.appInfo.allImmediateSubtypes(possibleTarget.holder));
            while (!worklist.isEmpty()) {
                DexType current = (DexType)worklist.pollFirst();
                DexProgramClass currentClass = this.getProgramClassOrNull(current);
                if (currentClass == null || currentClass.lookupVirtualMethod(possibleTarget) != null) continue;
                if (this.instantiatedTypes.contains(currentClass)) {
                    this.markVirtualMethodAsLive(clazz, encodedPossibleTarget, this.graphReporter.reportReachableMethodAsLive(encodedPossibleTarget, reason));
                    break;
                }
                this.appInfo.allImmediateSubtypes(current).forEach(worklist::addLast);
            }
        }
    }

    private MarkedResolutionTarget findAndMarkResolutionTarget(DexMethod method, boolean interfaceInvoke, KeepReason reason) {
        ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method, interfaceInvoke);
        if (resolutionResult.isFailedResolution()) {
            this.markFailedResolutionTargets(method, resolutionResult.asFailedResolution(), reason);
            return MarkedResolutionTarget.unresolved();
        }
        DexEncodedMethod resolutionTarget = resolutionResult.getSingleTarget();
        if (resolutionTarget == null) {
            this.reportMissingMethod(method);
            return MarkedResolutionTarget.unresolved();
        }
        DexClass resolutionTargetClass = this.appInfo.definitionFor(resolutionTarget.method.holder);
        if (resolutionTargetClass == null) {
            this.reportMissingClass(resolutionTarget.method.holder);
            return MarkedResolutionTarget.unresolved();
        }
        if (!this.options.enableTreeShakingOfLibraryMethodOverrides && resolutionTargetClass.isNotProgramClass()) {
            return MarkedResolutionTarget.unresolved();
        }
        if (resolutionTargetClass.isProgramClass()) {
            this.markMethodAsTargeted(resolutionTargetClass.asProgramClass(), resolutionTarget, reason);
        }
        return new MarkedResolutionTarget(resolutionTargetClass, resolutionTarget);
    }

    private void markFailedResolutionTargets(DexMethod symbolicMethod, ResolutionResult.FailedResolutionResult failedResolution, KeepReason reason) {
        this.failedResolutionTargets.add(symbolicMethod);
        failedResolution.forEachFailureDependency(method -> {
            DexProgramClass clazz = this.getProgramClassOrNull(method.method.holder);
            if (clazz != null) {
                this.failedResolutionTargets.add(method.method);
                this.markMethodAsTargeted(clazz, (DexEncodedMethod)method, reason);
            }
        });
    }

    private DexMethod generatedEnumValuesMethod(DexClass enumClass) {
        DexType arrayOfEnumClass = this.appView.dexItemFactory().createType(this.appView.dexItemFactory().createString("[" + enumClass.type.toDescriptorString()));
        DexProto proto = this.appView.dexItemFactory().createProto(arrayOfEnumClass, new DexType[0]);
        return this.appView.dexItemFactory().createMethod(enumClass.type, proto, this.appView.dexItemFactory().createString("values"));
    }

    private void markEnumValuesAsReachable(DexProgramClass clazz, KeepReason reason) {
        DexEncodedMethod valuesMethod = clazz.lookupMethod(this.generatedEnumValuesMethod(clazz));
        if (valuesMethod != null) {
            this.workList.enqueueMarkMethodKeptAction(clazz, valuesMethod, reason);
            this.pinnedItems.add(valuesMethod.toReference());
            this.rootSet.shouldNotBeMinified(valuesMethod.toReference());
        }
    }

    void markSuperMethodAsReachable(DexMethod method, DexEncodedMethod from) {
        DexProgramClass fromHolder;
        DexEncodedMethod target;
        KeepReason reason = KeepReason.targetedBySuperFrom(from);
        ResolutionResult.SingleResolutionResult resolution = this.resolveMethod(method, reason).asSingleResolution();
        if (resolution == null) {
            return;
        }
        if (resolution.getResolvedHolder().isProgramClass()) {
            this.markMethodAsTargeted(resolution.getResolvedHolder().asProgramClass(), resolution.getResolvedMethod(), reason);
        }
        if ((target = resolution.lookupInvokeSuperTarget(fromHolder = this.appInfo.definitionFor(from.method.holder).asProgramClass(), this.appInfo)) == null) {
            this.failedResolutionTargets.add(resolution.getResolvedMethod().method);
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(target.method.holder);
        if (clazz == null) {
            return;
        }
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Adding super constraint from `%s` to `%s`", from.method, target.method);
        }
        if (this.superInvokeDependencies.computeIfAbsent(from, ignore -> Sets.newIdentityHashSet()).add(target) && this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(clazz, target, KeepReason.invokedViaSuperFrom(from));
            if (!target.accessFlags.isAbstract()) {
                this.markVirtualMethodAsLive(clazz, target, KeepReason.invokedViaSuperFrom(from));
            }
        }
    }

    public Set<DexProgramClass> traceMainDex(RootSetBuilder.RootSet rootSet, ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (this.analyses.isEmpty());
        assert (this.mode.isTracingMainDex());
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        return this.liveTypes.getItems();
    }

    public AppInfoWithLiveness traceApplication(RootSetBuilder.RootSet rootSet, ProguardClassFilter dontWarnPatterns, ExecutorService executorService, Timing timing) throws ExecutionException {
        this.rootSet = rootSet;
        this.dontWarnPatterns = dontWarnPatterns;
        this.enqueueRootItems(rootSet.noShrinking);
        this.trace(executorService, timing);
        this.options.reporter.failIfPendingErrors();
        this.finalizeLibraryMethodOverrideInformation();
        this.analyses.forEach(EnqueuerAnalysis::done);
        assert (this.verifyKeptGraph());
        return this.createAppInfo(this.appInfo);
    }

    private void finalizeLibraryMethodOverrideInformation() {
        for (DexProgramClass liveType : this.liveTypes.getItems()) {
            for (DexEncodedMethod method : liveType.virtualMethods()) {
                if (!method.isLibraryMethodOverride().isUnknown()) continue;
                method.setLibraryMethodOverride(OptionalBool.FALSE);
            }
        }
    }

    private boolean verifyKeptGraph() {
        if (this.appView.options().testing.verifyKeptGraphInfo) {
            for (DexProgramClass liveType : this.liveTypes.getItems()) {
                assert (this.graphReporter.verifyRootedPath(liveType));
            }
        }
        return true;
    }

    private AppInfoWithLiveness createAppInfo(AppInfoWithSubtyping appInfo) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(PresortedComparable::slowCompareTo);
        ((SetWithReason)this.liveAnnotations).items.forEach(annotation -> builder.add(annotation.annotation.type));
        this.fieldAccessInfoCollection.removeIf((field, info) -> field != info.getField() || info == FieldAccessInfoImpl.MISSING_FIELD_ACCESS_INFO);
        assert (this.fieldAccessInfoCollection.verifyMappingIsOneToOne());
        for (ProgramMethod bridge : this.syntheticInterfaceMethodBridges.values()) {
            this.appView.appInfo().invalidateTypeCacheFor(bridge.holder.type);
            bridge.holder.appendVirtualMethod(bridge.method);
            this.targetedMethods.add(bridge.method, this.graphReporter.fakeReportShouldNotBeUsed());
            this.liveMethods.add(bridge.holder, bridge.method, this.graphReporter.fakeReportShouldNotBeUsed());
        }
        AppInfoWithLiveness appInfoWithLiveness = new AppInfoWithLiveness(appInfo, SetUtils.mapIdentityHashSet(this.liveTypes.getItems(), DexClass::getType), SetUtils.mapIdentityHashSet(this.liveAnnotations.getItems(), DexAnnotation::getAnnotationType), Collections.unmodifiableSet(this.instantiatedAppServices), SetUtils.mapIdentityHashSet(this.instantiatedTypes.getItems(), DexClass::getType), Enqueuer.toSortedDescriptorSet(this.targetedMethods.getItems()), Collections.unmodifiableSet(this.failedResolutionTargets), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, this.bootstrapMethods), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, this.methodsTargetedByInvokeDynamic), ImmutableSortedSet.copyOf(DexMethod::slowCompareTo, this.virtualMethodsTargetedByInvokeDirect), Enqueuer.toSortedDescriptorSet(this.liveMethods.getItems()), this.fieldAccessInfoCollection, EnqueuerUtils.toImmutableSortedMap(this.virtualInvokes, PresortedComparable::slowCompare), EnqueuerUtils.toImmutableSortedMap(this.interfaceInvokes, PresortedComparable::slowCompare), EnqueuerUtils.toImmutableSortedMap(this.superInvokes, PresortedComparable::slowCompare), EnqueuerUtils.toImmutableSortedMap(this.directInvokes, PresortedComparable::slowCompare), EnqueuerUtils.toImmutableSortedMap(this.staticInvokes, PresortedComparable::slowCompare), this.callSites, this.pinnedItems, this.rootSet.mayHaveSideEffects, this.rootSet.noSideEffects, this.rootSet.assumedValues, this.rootSet.alwaysInline, this.rootSet.forceInline, this.rootSet.neverInline, this.rootSet.whyAreYouNotInlining, this.rootSet.keepConstantArguments, this.rootSet.keepUnusedArguments, this.rootSet.alwaysClassInline, this.rootSet.neverClassInline, this.rootSet.neverMerge, this.rootSet.neverPropagateValue, Enqueuer.joinIdentifierNameStrings(this.rootSet.identifierNameStrings, this.identifierNameStrings), Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), SetUtils.mapIdentityHashSet(this.instantiatedInterfaceTypes.getItems(), DexClass::getType), this.constClassReferences);
        appInfo.markObsolete();
        return appInfoWithLiveness;
    }

    private static <T extends PresortedComparable<T>> SortedSet<T> toSortedDescriptorSet(Set<? extends KeyedDexItem<T>> set) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompareTo);
        for (KeyedDexItem<T> item : set) {
            builder.add(item.getKey());
        }
        return builder.build();
    }

    private static Object2BooleanMap<DexReference> joinIdentifierNameStrings(Set<DexReference> explicit, Set<DexReference> implicit) {
        Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
        for (DexReference e : explicit) {
            result.putIfAbsent(e, true);
        }
        for (DexReference i : implicit) {
            result.putIfAbsent(i, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void trace(ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Grow the tree.");
        try {
            do lbl-1000:
            // 5 sources

            {
                block11: {
                    numOfLiveItems = SetWithReportedReason.access$300(this.liveTypes).size();
                    numOfLiveItems += (long)LiveMethodsSet.access$400(this.liveMethods).size();
                    numOfLiveItems += (long)SetWithReason.access$200(this.liveFields).size();
                    while (!this.workList.isEmpty()) {
                        action = this.workList.poll();
                        action.run(this);
                    }
                    numOfLiveItemsAfterProcessing = SetWithReportedReason.access$300(this.liveTypes).size();
                    numOfLiveItemsAfterProcessing += (long)LiveMethodsSet.access$400(this.liveMethods).size();
                    if ((numOfLiveItemsAfterProcessing += (long)SetWithReason.access$200(this.liveFields).size()) <= numOfLiveItems) break block11;
                    if (this.activeIfRules == null) {
                        this.activeIfRules = new HashMap<Equivalence.Wrapper<ProguardIfRule>, Set<ProguardIfRule>>();
                        equivalence = new IfRuleClassPartEquivalence();
                        for (ProguardIfRule ifRule : this.rootSet.ifRules) {
                            wrap = equivalence.wrap(ifRule);
                            this.activeIfRules.computeIfAbsent(wrap, (Function<Equivalence.Wrapper, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$trace$37(shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence$Wrapper ), (Lshadow/bundletool/com/android/tools/r8/com/google/common/base/Equivalence$Wrapper;)Ljava/util/Set;)()).add(ifRule);
                        }
                    }
                    consequentSetBuilder = new RootSetBuilder(this.appView);
                    ifRuleEvaluator = new IfRuleEvaluator(this.appView, executorService, this.activeIfRules, this.liveFields.getItems(), this.liveMethods.getItems(), this.liveTypes.getItems(), this.mode, consequentSetBuilder, this.targetedMethods.getItems());
                    this.addConsequentRootSet(ifRuleEvaluator.run(), false);
                    if (!this.workList.isEmpty()) ** GOTO lbl-1000
                }
                if (!this.pendingReflectiveUses.isEmpty()) {
                    this.pendingReflectiveUses.forEach((Consumer<DexEncodedMethod>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleReflectiveBehavior(shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod ), (Lshadow/bundletool/com/android/tools/r8/graph/DexEncodedMethod;)V)((Enqueuer)this));
                    this.pendingReflectiveUses.clear();
                }
                if (!this.workList.isEmpty()) ** GOTO lbl-1000
                this.analyses.forEach((Consumer<EnqueuerAnalysis>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$trace$38(shadow.bundletool.com.android.tools.r8.graph.analysis.EnqueuerAnalysis ), (Lshadow/bundletool/com/android/tools/r8/graph/analysis/EnqueuerAnalysis;)V)((Enqueuer)this));
                if (!this.workList.isEmpty()) ** GOTO lbl-1000
                this.addConsequentRootSet(this.computeDelayedInterfaceMethodSyntheticBridges(), true);
                this.rootSet.delayedRootSetActionItems.clear();
            } while (!this.workList.isEmpty());
            if (Log.ENABLED) {
                allLive = Sets.newIdentityHashSet();
                for (ReachableVirtualMethodsSet reachable : this.reachableVirtualMethods.values()) {
                    allLive.addAll(reachable.getMethods());
                }
                reachableNotLive = Sets.difference(allLive, this.liveMethods.getItems());
                Log.debug(this.getClass(), "%s methods are reachable but not live", new Object[]{reachableNotLive.size()});
                Log.info(this.getClass(), "Only reachable: %s", new Object[]{reachableNotLive});
                liveButNotInstantiated = Sets.difference(this.liveTypes.getItems(), this.instantiatedTypes.getItems());
                Log.debug(this.getClass(), "%s classes are live but not instantiated", new Object[]{liveButNotInstantiated.size()});
                Log.info(this.getClass(), "Live but not instantiated: %s", new Object[]{liveButNotInstantiated});
                targetedButNotLive = Sets.difference(this.targetedMethods.getItems(), this.liveMethods.getItems());
                Log.debug(this.getClass(), "%s methods are targeted but not live", new Object[]{targetedButNotLive.size()});
                Log.info(this.getClass(), "Targeted but not live: %s", new Object[]{targetedButNotLive});
            }
        }
        finally {
            timing.end();
        }
        this.unpinLambdaMethods();
    }

    private void addConsequentRootSet(RootSetBuilder.ConsequentRootSet consequentRootSet, boolean addNoShrinking) {
        this.rootSet.addConsequentRootSet(consequentRootSet, addNoShrinking);
        this.enqueueRootItems(consequentRootSet.noShrinking);
        consequentRootSet.dependentNoShrinking.forEach((precondition, dependentItems) -> this.enqueueRootItems((Map<DexReference, Set<ProguardKeepRuleBase>>)dependentItems));
        if (this.forceProguardCompatibility) {
            consequentRootSet.dependentKeepClassCompatRule.forEach((precondition, compatRules) -> {
                assert (precondition.isDexType());
                DexClass preconditionHolder = this.appView.definitionFor(precondition.asDexType());
                this.compatEnqueueHolderIfDependentNonStaticMember(preconditionHolder, (Set<ProguardKeepRuleBase>)compatRules);
            });
        }
    }

    private RootSetBuilder.ConsequentRootSet computeDelayedInterfaceMethodSyntheticBridges() {
        RootSetBuilder builder = new RootSetBuilder(this.appView);
        for (DelayedRootSetActionItem delayedRootSetActionItem : this.rootSet.delayedRootSetActionItems) {
            if (!delayedRootSetActionItem.isInterfaceMethodSyntheticBridgeAction()) continue;
            this.handleInterfaceMethodSyntheticBridgeAction(delayedRootSetActionItem.asInterfaceMethodSyntheticBridgeAction(), builder);
        }
        return builder.buildConsequentRootSet();
    }

    private void handleInterfaceMethodSyntheticBridgeAction(DelayedRootSetActionItem.InterfaceMethodSyntheticBridgeAction action, RootSetBuilder builder) {
        ProgramMethod methodToKeep = action.getMethodToKeep();
        ProgramMethod singleTarget = action.getSingleTarget();
        if (this.rootSet.noShrinking.containsKey(singleTarget.method.method)) {
            return;
        }
        if (methodToKeep != singleTarget) {
            assert (null == methodToKeep.holder.lookupMethod(methodToKeep.method.method));
            ProgramMethod old = this.syntheticInterfaceMethodBridges.put(methodToKeep.method.method, methodToKeep);
            if (old == null) {
                if (singleTarget.method.isLibraryMethodOverride().isTrue()) {
                    methodToKeep.method.setLibraryMethodOverride(OptionalBool.TRUE);
                }
                assert (singleTarget.holder.isInterface());
                this.markVirtualMethodAsReachable(singleTarget.method.method, singleTarget.holder.isInterface(), null, this.graphReporter.fakeReportShouldNotBeUsed());
                this.enqueueMarkMethodLiveAction(singleTarget.holder, singleTarget.method, this.graphReporter.fakeReportShouldNotBeUsed());
            }
        }
        action.getAction().accept(builder);
    }

    private void unpinLambdaMethods() {
        for (DexMethod method : this.lambdaMethodsTargetedByInvokeDynamic) {
            this.pinnedItems.remove(method);
            this.rootSet.prune(method);
        }
        this.lambdaMethodsTargetedByInvokeDynamic.clear();
    }

    void markMethodAsKept(DexProgramClass holder, DexEncodedMethod target, KeepReason reason) {
        DexMethod method = target.method;
        if (target.isVirtualMethod()) {
            this.markVirtualMethodAsReachable(method, holder.isInterface(), null, reason);
            if (holder.isInterface()) {
                if (target.isNonAbstractVirtualMethod()) {
                    this.markVirtualMethodAsLive(holder, target, reason);
                } else {
                    DexEncodedMethod implementation = target.getDefaultInterfaceMethodImplementation();
                    if (implementation != null) {
                        DexProgramClass companion = this.getProgramClassOrNull(implementation.method.holder);
                        this.markTypeAsLive(companion, this.graphReporter.reportCompanionClass(holder, companion));
                        this.markVirtualMethodAsLive(companion, implementation, this.graphReporter.reportCompanionMethod(target, implementation));
                    }
                }
            }
        } else {
            this.markMethodAsTargeted(holder, target, reason);
            this.markDirectStaticOrConstructorMethodAsLive(holder, target, reason);
        }
    }

    void markFieldAsKept(DexProgramClass holder, DexEncodedField target, KeepReason reason) {
        assert (holder.type == target.field.holder);
        if (target.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(target, reason);
        } else {
            this.markInstanceFieldAsReachable(target, reason);
        }
    }

    private boolean shouldMarkLibraryMethodOverrideAsReachable(DexProgramClass clazz, DexEncodedMethod method) {
        assert (method.isVirtualMethod());
        if (method.isAbstract() || method.isPrivateMethod()) {
            return false;
        }
        if (this.appView.isClassEscapingIntoLibrary(clazz.type)) {
            return true;
        }
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(this.appView.appInfo().allImmediateSubtypes(clazz.type));
        Set<DexType> visited = Sets.newIdentityHashSet();
        visited.addAll(worklist);
        while (!worklist.isEmpty()) {
            DexClass current = this.appView.definitionFor((DexType)worklist.removeFirst());
            if (current == null) continue;
            assert (visited.contains(current.type));
            if (current.lookupVirtualMethod(method.method) != null) continue;
            if (this.appView.isClassEscapingIntoLibrary(current.type)) {
                return true;
            }
            for (DexType subtype : this.appView.appInfo().allImmediateSubtypes(current.type)) {
                if (!visited.add(subtype)) continue;
                worklist.add(subtype);
            }
        }
        return false;
    }

    void markMethodAsLive(DexEncodedMethod method, KeepReason reason) {
        Set<DexEncodedMethod> superCallTargets;
        assert (this.liveMethods.contains(method));
        DexProgramClass clazz = this.getProgramClassOrNull(method.method.holder);
        if (clazz == null) {
            return;
        }
        if (method.isStatic()) {
            this.markDirectAndIndirectClassInitializersAsLive(clazz);
        }
        if ((superCallTargets = this.superInvokeDependencies.get(method)) != null) {
            for (DexEncodedMethod superCallTarget : superCallTargets) {
                if (Log.ENABLED) {
                    Log.verbose(this.getClass(), "Found super invoke constraint on `%s`.", superCallTarget.method);
                }
                DexProgramClass targetClass = this.getProgramClassOrNull(superCallTarget.method.holder);
                assert (targetClass != null);
                if (targetClass == null) continue;
                this.markMethodAsTargeted(targetClass, superCallTarget, KeepReason.invokedViaSuperFrom(method));
                this.markVirtualMethodAsLive(targetClass, superCallTarget, KeepReason.invokedViaSuperFrom(method));
            }
        }
        this.markParameterAndReturnTypesAsLive(method);
        this.processAnnotations(method, method.annotations.annotations);
        method.parameterAnnotationsList.forEachAnnotation(annotation -> this.processAnnotation(method, (DexAnnotation)annotation));
        method.registerCodeReferences(this.useRegistryFactory.create(this.appView, clazz, method, this));
        this.enqueueRootItems(this.rootSet.getDependentItems(method));
        this.analyses.forEach(analysis -> analysis.processNewlyLiveMethod(method));
    }

    private void markReferencedTypesAsLive(DexEncodedMethod method) {
        this.markTypeAsLive(method.method.holder, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, method));
        this.markParameterAndReturnTypesAsLive(method);
    }

    private void markParameterAndReturnTypesAsLive(DexEncodedMethod method) {
        for (DexType parameterType : method.method.proto.parameters.values) {
            this.markTypeAsLive(parameterType, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, method));
        }
        this.markTypeAsLive(method.method.proto.returnType, (DexProgramClass clazz) -> this.graphReporter.reportClassReferencedFrom((DexProgramClass)clazz, method));
    }

    private void markClassAsInstantiatedWithReason(DexProgramClass clazz, KeepReason reason) {
        this.workList.enqueueMarkInstantiatedAction(clazz, null, reason);
        if (clazz.hasDefaultInitializer()) {
            this.workList.enqueueMarkReachableDirectAction(clazz.getDefaultInitializer().method, reason);
        }
    }

    private void markClassAsInstantiatedWithCompatRule(DexProgramClass clazz, GraphReporter.KeepReasonWitness witness) {
        if (clazz.isInterface() && !clazz.accessFlags.isAnnotation()) {
            this.markInterfaceAsInstantiated(clazz, witness);
            return;
        }
        this.workList.enqueueMarkInstantiatedAction(clazz, null, witness);
        if (clazz.hasDefaultInitializer()) {
            DexEncodedMethod defaultInitializer = clazz.getDefaultInitializer();
            this.workList.enqueueMarkReachableDirectAction(defaultInitializer.method, this.graphReporter.reportCompatKeepDefaultInitializer(clazz, defaultInitializer));
        }
    }

    private void markMethodAsLiveWithCompatRule(DexProgramClass clazz, DexEncodedMethod method) {
        this.enqueueMarkMethodLiveAction(clazz, method, this.graphReporter.reportCompatKeepMethod(clazz, method));
    }

    private void handleReflectiveBehavior(DexEncodedMethod method) {
        DexType originHolder = method.method.holder;
        Origin origin = this.appInfo.originFor(originHolder);
        IRCode code = method.buildIR(this.appView, origin);
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            this.handleReflectiveBehavior(method, instruction);
        }
    }

    private void handleReflectiveBehavior(DexEncodedMethod method, Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return;
        }
        InvokeMethod invoke = instruction.asInvokeMethod();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (invokedMethod == dexItemFactory.classMethods.newInstance) {
            this.handleJavaLangClassNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.constructorMethods.newInstance) {
            this.handleJavaLangReflectConstructorNewInstance(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.enumMethods.valueOf) {
            this.handleJavaLangEnumValueOf(method, invoke);
            return;
        }
        if (invokedMethod == dexItemFactory.proxyMethods.newProxyInstance) {
            this.handleJavaLangReflectProxyNewProxyInstance(method, invoke);
            return;
        }
        if (dexItemFactory.serviceLoaderMethods.isLoadMethod(invokedMethod)) {
            this.handleServiceLoaderInvocation(method, invoke);
            return;
        }
        if (!IdentifierNameStringUtils.isReflectionMethod(dexItemFactory, invokedMethod)) {
            return;
        }
        DexReference identifierItem = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView);
        if (identifierItem == null) {
            return;
        }
        if (identifierItem.isDexType()) {
            DexProgramClass clazz = this.getProgramClassOrNull(identifierItem.asDexType());
            if (clazz == null) {
                return;
            }
            if (clazz.isInterface()) {
                this.markTypeAsLive(clazz.type, KeepReason.reflectiveUseIn(method));
            } else {
                this.markInstantiated(clazz, null, KeepReason.reflectiveUseIn(method));
                if (clazz.hasDefaultInitializer()) {
                    DexEncodedMethod initializer = clazz.getDefaultInitializer();
                    KeepReason reason = KeepReason.reflectiveUseIn(method);
                    this.markMethodAsTargeted(clazz, initializer, reason);
                    this.markDirectStaticOrConstructorMethodAsLive(clazz, initializer, reason);
                }
            }
        } else if (identifierItem.isDexField()) {
            boolean keepClass;
            DexField field = identifierItem.asDexField();
            DexProgramClass clazz = this.getProgramClassOrNull(field.holder);
            if (clazz == null) {
                return;
            }
            DexEncodedField encodedField = this.appView.definitionFor(field);
            if (encodedField == null) {
                return;
            }
            boolean bl = keepClass = !encodedField.accessFlags.isStatic() && dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(invokedMethod);
            if (keepClass) {
                this.markInstantiated(clazz, null, KeepReason.reflectiveUseIn(method));
            }
            if (this.pinnedItems.add(encodedField.field)) {
                this.markFieldAsKept(clazz, encodedField, KeepReason.reflectiveUseIn(method));
            }
        } else {
            assert (identifierItem.isDexMethod());
            DexMethod targetedMethod = identifierItem.asDexMethod();
            DexProgramClass clazz = this.getProgramClassOrNull(targetedMethod.holder);
            if (clazz == null) {
                return;
            }
            DexEncodedMethod encodedMethod = this.appView.definitionFor(targetedMethod);
            if (encodedMethod == null) {
                return;
            }
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            if (encodedMethod.accessFlags.isStatic() || encodedMethod.accessFlags.isConstructor()) {
                this.markMethodAsTargeted(clazz, encodedMethod, reason);
                this.markDirectStaticOrConstructorMethodAsLive(clazz, encodedMethod, reason);
            } else {
                this.markVirtualMethodAsLive(clazz, encodedMethod, reason);
            }
        }
    }

    private void handleJavaLangClassNewInstance(DexEncodedMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(invoke.asInvokeVirtual().getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(instantiatedType);
        if (clazz == null) {
            return;
        }
        DexEncodedMethod defaultInitializer = clazz.getDefaultInitializer();
        if (defaultInitializer != null) {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markClassAsInstantiatedWithReason(clazz, reason);
            this.markMethodAsTargeted(clazz, defaultInitializer, reason);
            this.markDirectStaticOrConstructorMethodAsLive(clazz, defaultInitializer, reason);
        }
    }

    private void handleJavaLangReflectConstructorNewInstance(DexEncodedMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeVirtual()) {
            assert (false);
            return;
        }
        Value constructorValue = invoke.asInvokeVirtual().getReceiver().getAliasedValue();
        if (constructorValue.isPhi() || !constructorValue.definition.isInvokeVirtual()) {
            return;
        }
        InvokeVirtual constructorDefinition = constructorValue.definition.asInvokeVirtual();
        if (constructorDefinition.getInvokedMethod() != this.appView.dexItemFactory().classMethods.getDeclaredConstructor) {
            return;
        }
        DexType instantiatedType = ConstantValueUtils.getDexTypeRepresentedByValue(constructorDefinition.getReceiver(), this.appView);
        if (instantiatedType == null || !instantiatedType.isClassType()) {
            return;
        }
        DexProgramClass clazz = this.getProgramClassOrNull(instantiatedType);
        if (clazz == null) {
            return;
        }
        Value parametersValue = constructorDefinition.inValues().get(1);
        if (parametersValue.isPhi() || !parametersValue.definition.isNewArrayEmpty()) {
            return;
        }
        Value parametersSizeValue = parametersValue.definition.asNewArrayEmpty().size();
        if (parametersSizeValue.isPhi() || !parametersSizeValue.definition.isConstNumber()) {
            return;
        }
        DexEncodedMethod initializer = null;
        int parametersSize = parametersSizeValue.definition.asConstNumber().getIntValue();
        if (parametersSize == 0) {
            initializer = clazz.getDefaultInitializer();
        } else {
            DexType[] parameterTypes = new DexType[parametersSize];
            int missingIndices = parametersSize;
            for (Instruction user : parametersValue.uniqueUsers()) {
                if (!user.isArrayPut()) continue;
                ArrayPut arrayPutInstruction = user.asArrayPut();
                if (arrayPutInstruction.array() != parametersValue) {
                    return;
                }
                Value indexValue = arrayPutInstruction.index();
                if (indexValue.isPhi() || !indexValue.definition.isConstNumber()) {
                    return;
                }
                int index = indexValue.definition.asConstNumber().getIntValue();
                if (index >= parametersSize) {
                    return;
                }
                DexType type = ConstantValueUtils.getDexTypeRepresentedByValue(arrayPutInstruction.value(), this.appView);
                if (type == null) {
                    return;
                }
                if (parameterTypes[index] == type) continue;
                if (parameterTypes[index] != null) {
                    return;
                }
                parameterTypes[index] = type;
                --missingIndices;
            }
            if (missingIndices == 0) {
                initializer = clazz.getInitializer(parameterTypes);
            }
        }
        if (initializer != null) {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            this.markClassAsInstantiatedWithReason(clazz, reason);
            this.markMethodAsTargeted(clazz, initializer, reason);
            this.markDirectStaticOrConstructorMethodAsLive(clazz, initializer, reason);
        }
    }

    private void handleJavaLangReflectProxyNewProxyInstance(DexEncodedMethod method, InvokeMethod invoke) {
        if (!invoke.isInvokeStatic()) {
            assert (false);
            return;
        }
        Value interfacesValue = invoke.arguments().get(1);
        if (interfacesValue.isPhi() || !interfacesValue.definition.isNewArrayEmpty()) {
            return;
        }
        for (Instruction user : interfacesValue.uniqueUsers()) {
            DexProgramClass clazz;
            ArrayPut arrayPut;
            DexType type;
            if (!user.isArrayPut() || (type = ConstantValueUtils.getDexTypeRepresentedByValue((arrayPut = user.asArrayPut()).value(), this.appView)) == null || !type.isClassType() || (clazz = this.getProgramClassOrNull(type)) == null || !clazz.isInterface()) continue;
            this.pinnedItems.add(clazz.type);
            for (DexEncodedMethod virtualMethod : clazz.virtualMethods()) {
                this.pinnedItems.add(virtualMethod.method);
            }
        }
    }

    private void handleJavaLangEnumValueOf(DexEncodedMethod method, InvokeMethod invoke) {
        DexType type;
        DexProgramClass clazz;
        if (invoke.inValues().get(0).isConstClass() && (clazz = this.getProgramClassOrNull(type = invoke.inValues().get((int)0).definition.asConstClass().getValue())) != null && clazz.accessFlags.isEnum()) {
            DexProgramClass holder = this.getProgramClassOrNull(method.method.holder);
            this.markEnumValuesAsReachable(clazz, KeepReason.invokedFrom(holder, method));
        }
    }

    private void handleServiceLoaderInvocation(DexEncodedMethod method, InvokeMethod invoke) {
        if (invoke.inValues().size() == 0) {
            return;
        }
        Value argument = invoke.inValues().get(0).getAliasedValue();
        if (!argument.isPhi() && argument.definition.isConstClass()) {
            DexType serviceType = argument.definition.asConstClass().getValue();
            if (!this.appView.appServices().allServiceTypes().contains(serviceType)) {
                if (Log.ENABLED) {
                    this.options.reporter.warning(new StringDiagnostic("The type `" + serviceType.toSourceString() + "` is being passed to the method `" + invoke.getInvokedMethod().toSourceString() + "`, but was not found in `META-INF/services/`.", this.appInfo.originFor(method.method.holder)));
                }
                return;
            }
            this.handleServiceInstantiation(serviceType, KeepReason.reflectiveUseIn(method));
        } else {
            KeepReason reason = KeepReason.reflectiveUseIn(method);
            for (DexType serviceType : this.appView.appServices().allServiceTypes()) {
                this.handleServiceInstantiation(serviceType, reason);
            }
        }
    }

    private void handleServiceInstantiation(DexType serviceType, KeepReason reason) {
        this.instantiatedAppServices.add(serviceType);
        List<DexType> serviceImplementationTypes = this.appView.appServices().serviceImplementationsFor(serviceType);
        for (DexType serviceImplementationType : serviceImplementationTypes) {
            DexProgramClass serviceImplementationClass;
            if (!serviceImplementationType.isClassType() || (serviceImplementationClass = this.getProgramClassOrNull(serviceImplementationType)) == null || !serviceImplementationClass.isProgramClass()) continue;
            this.markClassAsInstantiatedWithReason(serviceImplementationClass, reason);
        }
    }

    private /* synthetic */ void lambda$trace$38(EnqueuerAnalysis analysis) {
        analysis.notifyFixpoint(this, this.workList);
    }

    private static /* synthetic */ Set lambda$trace$37(Equivalence.Wrapper ignore) {
        return new LinkedHashSet();
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final DexItem annotationHolder;
        private final DexItemFactory dexItemFactory;
        private final KeepReason reason;

        private AnnotationReferenceMarker(DexItem annotationHolder, DexItemFactory dexItemFactory, KeepReason reason) {
            this.annotationHolder = annotationHolder;
            this.dexItemFactory = dexItemFactory;
            this.reason = reason;
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            DexClass holder = Enqueuer.this.appView.definitionFor(field.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedField target = holder.lookupStaticField(field);
            if (target != null) {
                if (target.field == field) {
                    DexProgramClass clazz;
                    if (!Enqueuer.this.registerFieldRead(field, DexEncodedMethod.ANNOTATION_REFERENCE)) {
                        return false;
                    }
                    Enqueuer.this.markStaticFieldAsLive(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                    if (Enqueuer.this.options.isGeneratingClassFiles() && this.annotationHolder == this.dexItemFactory.annotationDefault && (clazz = Enqueuer.this.getProgramClassOrNull(field.type)) != null && clazz.accessFlags.isEnum()) {
                        Enqueuer.this.markEnumValuesAsReachable(clazz, KeepReason.referencedInAnnotation(this.annotationHolder));
                    }
                }
            } else {
                target = holder.lookupInstanceField(field);
                if (target != null && target.field != field) {
                    Enqueuer.this.markInstanceFieldAsReachable(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            DexProgramClass holder = Enqueuer.this.getProgramClassOrNull(method.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.lookupDirectMethod(method);
            if (target != null) {
                if (target.method == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(holder, target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupVirtualMethod(method);
                if (target != null && target.method == method) {
                    Enqueuer.this.markMethodAsTargeted(holder, target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            if (type != this.dexItemFactory.voidType) {
                Enqueuer.this.markTypeAsLive(type, this.reason);
            }
            return false;
        }
    }

    private static final class TargetWithContext<T extends Descriptor<?, T>> {
        private final T target;
        private final DexEncodedMethod context;

        private TargetWithContext(T target, DexEncodedMethod context) {
            this.target = target;
            this.context = context;
        }

        public T getTarget() {
            return this.target;
        }

        public DexEncodedMethod getContext() {
            return this.context;
        }

        public int hashCode() {
            return ((CachedHashValueDexItem)this.target).hashCode() * 31 + this.context.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TargetWithContext)) {
                return false;
            }
            TargetWithContext other = (TargetWithContext)obj;
            return this.target == other.target && this.context == other.context;
        }
    }

    private static class ReachableVirtualMethodsSet {
        private final Map<DexEncodedMethod, Set<MarkedResolutionTarget>> methods = Maps.newIdentityHashMap();

        private ReachableVirtualMethodsSet() {
        }

        public Set<DexEncodedMethod> getMethods() {
            return this.methods.keySet();
        }

        public Set<MarkedResolutionTarget> getReasons(DexEncodedMethod method) {
            return this.methods.get(method);
        }

        public boolean add(DexEncodedMethod method, MarkedResolutionTarget reason) {
            Set<MarkedResolutionTarget> reasons = this.getReasons(method);
            if (reasons == null) {
                reasons = new HashSet<MarkedResolutionTarget>();
                reasons.add(reason);
                this.methods.put(method, reasons);
                return true;
            }
            reasons.add(reason);
            return false;
        }
    }

    public static class MarkedResolutionTarget {
        private static final MarkedResolutionTarget UNRESOLVED = new MarkedResolutionTarget(null, null);
        final DexClass holder;
        final DexEncodedMethod method;

        public static MarkedResolutionTarget unresolved() {
            return UNRESOLVED;
        }

        public MarkedResolutionTarget(DexClass holder, DexEncodedMethod method) {
            assert (holder == null && method == null || holder.type == method.method.holder);
            this.holder = holder;
            this.method = method;
        }

        public boolean isUnresolved() {
            return this == MarkedResolutionTarget.unresolved();
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MarkedResolutionTarget && ((MarkedResolutionTarget)obj).method.equals(this.method);
        }
    }

    private static class SetWithReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final BiConsumer<T, KeepReason> register;

        public SetWithReason(BiConsumer<T, KeepReason> register) {
            this.register = register;
        }

        boolean add(T item, KeepReason reason) {
            this.register.accept(item, reason);
            return this.items.add(item);
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        Set<T> getItems() {
            return Collections.unmodifiableSet(this.items);
        }
    }

    private class LiveMethodsSet {
        private final Set<DexEncodedMethod> items = Sets.newIdentityHashSet();
        private final BiConsumer<DexEncodedMethod, KeepReason> register;

        LiveMethodsSet(BiConsumer<DexEncodedMethod, KeepReason> register) {
            this.register = register;
        }

        boolean add(DexProgramClass clazz, DexEncodedMethod method, KeepReason reason) {
            this.register.accept(method, reason);
            Enqueuer.this.transitionUnusedInterfaceToLive(clazz);
            return this.items.add(method);
        }

        boolean contains(DexEncodedMethod method) {
            return this.items.contains(method);
        }

        Set<DexEncodedMethod> getItems() {
            return Collections.unmodifiableSet(this.items);
        }

        static /* synthetic */ Set access$400(LiveMethodsSet x0) {
            return x0.items;
        }
    }

    private static class SetWithReportedReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final Map<T, List<Action>> deferredActions = new IdentityHashMap<T, List<Action>>();

        private SetWithReportedReason() {
        }

        boolean add(T item, GraphReporter.KeepReasonWitness witness) {
            assert (witness != null);
            if (this.items.add(item)) {
                this.deferredActions.getOrDefault(item, Collections.emptyList()).forEach(Action::execute);
                return true;
            }
            return false;
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        boolean registerDeferredAction(T item, Action action) {
            if (!this.items.contains(item)) {
                this.deferredActions.computeIfAbsent(item, ignore -> new ArrayList()).add(action);
                return true;
            }
            return false;
        }

        Set<T> getItems() {
            return Collections.unmodifiableSet(this.items);
        }

        static /* synthetic */ Set access$300(SetWithReportedReason x0) {
            return x0.items;
        }
    }

    public static enum Mode {
        INITIAL_TREE_SHAKING,
        FINAL_TREE_SHAKING,
        MAIN_DEX_TRACING,
        WHY_ARE_YOU_KEEPING;


        public boolean isInitialTreeShaking() {
            return this == INITIAL_TREE_SHAKING;
        }

        public boolean isFinalTreeShaking() {
            return this == FINAL_TREE_SHAKING;
        }

        public boolean isInitialOrFinalTreeShaking() {
            return this.isInitialTreeShaking() || this.isFinalTreeShaking();
        }

        public boolean isTracingMainDex() {
            return this == MAIN_DEX_TRACING;
        }
    }
}

