/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

public class LongInterval {
    private final long min;
    private final long max;

    public LongInterval(int min, int max) {
        assert (min <= max);
        this.min = min;
        this.max = max;
    }

    public LongInterval(long min, long max) {
        assert (min <= max);
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean isSingleValue() {
        return this.min == this.max;
    }

    public long getSingleValue() {
        assert (this.isSingleValue());
        return this.min;
    }

    public boolean containsValue(long value) {
        return this.min <= value && value <= this.max;
    }

    public boolean doesntOverlapWith(LongInterval other) {
        return other.max < this.min || this.max < other.min;
    }

    public boolean overlapsWith(LongInterval other) {
        return other.max >= this.min && this.max >= other.min;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LongInterval) {
            return ((LongInterval)other).min == this.min && ((LongInterval)other).max == this.max;
        }
        return false;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

