/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.DuplicateTypesDiagnostic;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryWrapperSynthesizer;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.utils.ClassMap;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    private final ApplicationReader.ProgramClassConflictResolver conflictResolver;

    public static ProgramClassCollection create(List<DexProgramClass> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        ConcurrentHashMap<DexType, Supplier<DexProgramClass>> map2 = new ConcurrentHashMap<DexType, Supplier<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            map2.merge(clazz.type, clazz, (a, b) -> conflictResolver.resolveClassConflict((DexProgramClass)a.get(), (DexProgramClass)b.get()));
        }
        return new ProgramClassCollection(map2, conflictResolver);
    }

    private ProgramClassCollection(ConcurrentHashMap<DexType, Supplier<DexProgramClass>> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        super(classes, null);
        this.conflictResolver = conflictResolver;
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return this.conflictResolver.resolveClassConflict(a, b);
    }

    @Override
    Supplier<DexProgramClass> getTransparentSupplier(DexProgramClass clazz) {
        return clazz;
    }

    @Override
    ClassKind getClassKind() {
        return ClassKind.PROGRAM;
    }

    public static ApplicationReader.ProgramClassConflictResolver defaultConflictResolver(Reporter reporter) {
        return (a, b) -> {
            assert (a.type == b.type);
            if (a.originatesFromDexResource() && b.originatesFromDexResource() && a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic()) {
                return ProgramClassCollection.mergeClasses(reporter, a, b);
            }
            throw ProgramClassCollection.reportDuplicateTypes(reporter, a, b);
        };
    }

    private static RuntimeException reportDuplicateTypes(Reporter reporter, DexProgramClass a, DexProgramClass b) {
        throw reporter.fatalError(new DuplicateTypesDiagnostic(Reference.classFromDescriptor(a.type.toDescriptorString()), ImmutableList.of(a.getOrigin(), b.getOrigin())));
    }

    private static DexProgramClass mergeClasses(Reporter reporter, DexProgramClass a, DexProgramClass b) {
        if (DesugaredLibraryWrapperSynthesizer.isSynthesizedWrapper(a.type)) {
            return ProgramClassCollection.mergeWrappers(a, b);
        }
        if (a.type.isD8R8SynthesizedClassType()) {
            assert (ProgramClassCollection.assertEqualClasses(a, b));
            return a;
        }
        throw ProgramClassCollection.reportDuplicateTypes(reporter, a, b);
    }

    private static boolean assertEqualClasses(DexProgramClass a, DexProgramClass b) {
        assert (a.virtualMethods().size() == b.virtualMethods().size());
        assert (a.directMethods().size() == b.directMethods().size());
        return true;
    }

    private static DexProgramClass mergeWrappers(DexProgramClass a, DexProgramClass b) {
        DexEncodedMethod aMethod = ProgramClassCollection.findConversionMethod(a);
        DexEncodedMethod bMethod = ProgramClassCollection.findConversionMethod(b);
        return aMethod.getCode().estimatedSizeForInlining() > bMethod.getCode().estimatedSizeForInlining() ? a : b;
    }

    private static DexEncodedMethod findConversionMethod(DexProgramClass clazz) {
        for (DexEncodedMethod dexEncodedMethod : clazz.directMethods()) {
            if (dexEncodedMethod.isInstanceInitializer()) continue;
            return dexEncodedMethod;
        }
        throw new CompilationError("A wrapper should have a conversion method.");
    }
}

