/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.ArrayList;
import java.util.Collection;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.utils.AbortException;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class Reporter
implements DiagnosticsHandler {
    private final DiagnosticsHandler clientHandler;
    private int errorCount = 0;
    private Diagnostic lastError;
    private final Collection<Throwable> suppressedExceptions = new ArrayList<Throwable>();

    public Reporter() {
        this(new DiagnosticsHandler(){});
    }

    public Reporter(DiagnosticsHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    @Override
    public synchronized void info(Diagnostic info) {
        this.clientHandler.info(info);
    }

    @Override
    public synchronized void warning(Diagnostic warning) {
        this.clientHandler.warning(warning);
    }

    @Override
    public synchronized void error(Diagnostic error) {
        this.clientHandler.error(error);
        this.lastError = error;
        ++this.errorCount;
    }

    public void error(String message) {
        this.error(new StringDiagnostic(message));
    }

    public synchronized void error(Diagnostic error, Throwable suppressedException) {
        this.clientHandler.error(error);
        this.lastError = error;
        ++this.errorCount;
        this.suppressedExceptions.add(suppressedException);
    }

    public RuntimeException fatalError(String message) {
        this.fatalError(new StringDiagnostic(message));
        throw new Unreachable();
    }

    public RuntimeException fatalError(Diagnostic error) {
        this.error(error);
        this.failIfPendingErrors();
        throw new Unreachable();
    }

    public RuntimeException fatalError(Diagnostic error, Throwable suppressedException) {
        this.error(error, suppressedException);
        this.failIfPendingErrors();
        throw new Unreachable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failIfPendingErrors() {
        Reporter reporter = this;
        synchronized (reporter) {
            if (this.errorCount != 0) {
                AbortException abort;
                if (this.lastError != null && this.lastError.getDiagnosticMessage() != null) {
                    StringBuilder builder = new StringBuilder("Error: ");
                    if (this.lastError.getOrigin() != Origin.unknown()) {
                        builder.append(this.lastError.getOrigin()).append(", ");
                    }
                    if (this.lastError.getPosition() != Position.UNKNOWN) {
                        builder.append(this.lastError.getPosition()).append(", ");
                    }
                    builder.append(this.lastError.getDiagnosticMessage());
                    abort = new AbortException(builder.toString());
                } else {
                    abort = new AbortException();
                }
                throw this.addSuppressedExceptions(abort);
            }
        }
    }

    private <T extends Throwable> T addSuppressedExceptions(T t) {
        this.suppressedExceptions.forEach(t::addSuppressed);
        return t;
    }

    public void guard(Runnable action) throws CompilationFailedException {
        try {
            action.run();
        }
        catch (CompilationError e) {
            this.error(e.toStringDiagnostic());
            throw this.addSuppressedExceptions(new CompilationFailedException());
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }
}

