/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class Timing {
    private final Stack<Node> stack;
    private final boolean trackMemory;

    public Timing() {
        this("<no title>");
    }

    public Timing(String title) {
        this(title, false);
    }

    public Timing(String title, boolean trackMemory) {
        this.trackMemory = trackMemory;
        this.stack = new Stack();
        this.stack.push(new Node("Recorded timings for " + title));
    }

    private static String prettyPercentage(long part, long total) {
        return part * 100L / total + "%";
    }

    private static String prettyTime(long value) {
        return value / 1000000L + "ms";
    }

    private static String prettySize(long value) {
        return Timing.prettyNumber(value / 1024L) + "k";
    }

    private static String prettyNumber(long value) {
        String printed = "" + Math.abs(value);
        if (printed.length() < 4) {
            return "" + value;
        }
        StringBuilder builder = new StringBuilder();
        if (value < 0L) {
            builder.append('-');
        }
        int prefix = printed.length() % 3;
        builder.append(printed, 0, prefix);
        for (int i = prefix; i < printed.length(); i += 3) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(printed, i, i + 3);
        }
        return builder.toString();
    }

    public void begin(String title) {
        Node child;
        Node parent = this.stack.peek();
        if (parent.children.containsKey(title)) {
            child = parent.children.get(title);
            child.restart();
        } else {
            child = new Node(title);
            parent.children.put(title, child);
        }
        this.stack.push(child);
    }

    public void end() {
        this.stack.peek().end();
        this.stack.pop();
    }

    public void report() {
        Node top = this.stack.peek();
        top.end();
        System.out.println();
        top.report(0, top);
    }

    public void scope(String title, TimingScope fn) {
        this.begin(title);
        try {
            fn.apply();
        }
        finally {
            this.end();
        }
    }

    private Map<String, MemInfo> computeMemoryInformation() {
        System.gc();
        LinkedHashMap<String, MemInfo> info = new LinkedHashMap<String, MemInfo>();
        info.put("Memory", MemInfo.fromTotalAndFree(Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory()));
        return info;
    }

    public static interface TimingScope {
        public void apply();
    }

    class Node {
        final String title;
        final Map<String, Node> children = new LinkedHashMap<String, Node>();
        long duration = 0L;
        long start_time;
        Map<String, MemInfo> startMemory;
        Map<String, MemInfo> endMemory;

        Node(String title) {
            this.title = title;
            if (Timing.this.trackMemory) {
                this.startMemory = Timing.this.computeMemoryInformation();
            }
            this.start_time = System.nanoTime();
        }

        void restart() {
            assert (this.start_time == -1L);
            if (Timing.this.trackMemory) {
                this.startMemory = Timing.this.computeMemoryInformation();
            }
            this.start_time = System.nanoTime();
        }

        void end() {
            this.duration += System.nanoTime() - this.start_time;
            this.start_time = -1L;
            assert (this.duration() >= 0L);
            if (Timing.this.trackMemory) {
                this.endMemory = Timing.this.computeMemoryInformation();
            }
        }

        long duration() {
            return this.duration;
        }

        public String toString() {
            return this.title + ": " + Timing.prettyTime(this.duration());
        }

        public String toString(Node top) {
            if (this == top) {
                return this.toString();
            }
            return this.toString() + " (" + Timing.prettyPercentage(this.duration(), top.duration()) + ")";
        }

        public void report(int depth, Node top) {
            assert (this.duration() >= 0L);
            if (depth > 0) {
                for (int i = 0; i < depth; ++i) {
                    System.out.print("  ");
                }
                System.out.print("- ");
            }
            System.out.println(this.toString(top));
            if (Timing.this.trackMemory) {
                this.printMemory(depth);
            }
            this.children.values().forEach(p -> p.report(depth + 1, top));
        }

        private void printMemory(int depth) {
            for (Map.Entry<String, MemInfo> start : this.startMemory.entrySet()) {
                if (!start.getKey().equals("Memory")) continue;
                for (int i = 0; i <= depth; ++i) {
                    System.out.print("  ");
                }
                MemInfo endValue = this.endMemory.get(start.getKey());
                MemInfo startValue = start.getValue();
                System.out.println(start.getKey() + " start: " + Timing.prettySize(startValue.used) + ", end: " + Timing.prettySize(endValue.used) + ", delta: " + Timing.prettySize(endValue.usedDelta(startValue)));
            }
        }
    }

    private static class MemInfo {
        final long used;

        MemInfo(long used) {
            this.used = used;
        }

        public static MemInfo fromTotalAndFree(long total, long free) {
            return new MemInfo(total - free);
        }

        long usedDelta(MemInfo previous) {
            return this.used - previous.used;
        }
    }
}

