/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

abstract class FieldInstruction
extends Instruction {
    protected final MemberType type;
    protected final DexField field;

    protected FieldInstruction(MemberType type, DexField field, Value dest, Value value) {
        super(dest, value);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    protected FieldInstruction(MemberType type, DexField field, Value dest, List<Value> inValues) {
        super(dest, inValues);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    public MemberType getType() {
        return this.type;
    }

    public DexField getField() {
        return this.field;
    }

    abstract DexEncodedField lookupTarget(DexType var1, AppInfo var2);

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        DexType fieldHolder = this.field.getHolder();
        DexEncodedField target = this.lookupTarget(fieldHolder, info);
        DexClass fieldClass = info.definitionFor(fieldHolder);
        if (target != null && fieldClass != null) {
            Inliner.Constraint fieldConstraint = Inliner.Constraint.deriveConstraint(invocationContext, fieldHolder, target.accessFlags, info);
            Inliner.Constraint classConstraint = Inliner.Constraint.deriveConstraint(invocationContext, fieldHolder, fieldClass.accessFlags, info);
            return Inliner.Constraint.min(fieldConstraint, classConstraint);
        }
        return Inliner.Constraint.NEVER;
    }
}

