/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class SwitchMapCollector {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions options;
    private final DexString switchMapPrefix;
    private final DexType intArrayType;
    private final Map<DexField, Int2ReferenceMap<DexField>> switchMaps = new IdentityHashMap<DexField, Int2ReferenceMap<DexField>>();

    public SwitchMapCollector(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
        this.switchMapPrefix = appInfo.dexItemFactory.createString("$SwitchMap$");
        this.intArrayType = appInfo.dexItemFactory.createType("[I");
    }

    public Enqueuer.AppInfoWithLiveness run() throws ApiLevelException {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            this.processClasses(clazz);
        }
        if (!this.switchMaps.isEmpty()) {
            return this.appInfo.addSwitchMaps(this.switchMaps);
        }
        return this.appInfo;
    }

    private void processClasses(DexProgramClass clazz) throws ApiLevelException {
        if (!clazz.accessFlags.isSynthetic() && !clazz.hasClassInitializer()) {
            return;
        }
        List<DexEncodedField> switchMapFields = Arrays.stream(clazz.staticFields()).filter(this::maybeIsSwitchMap).collect(Collectors.toList());
        if (!switchMapFields.isEmpty()) {
            IRCode initializer = clazz.getClassInitializer().buildIR(this.options);
            switchMapFields.forEach(field -> this.extractSwitchMap((DexEncodedField)field, initializer));
        }
    }

    private void extractSwitchMap(DexEncodedField encodedField, IRCode initializer) {
        Instruction insn;
        DexField field = encodedField.field;
        Int2ReferenceArrayMap switchMap = new Int2ReferenceArrayMap();
        InstructionIterator it = initializer.instructionIterator();
        Predicate<Instruction> predicate = i -> i.isStaticGet() && i.asStaticGet().getField() == field;
        while ((insn = it.nextUntil(predicate)) != null) {
            for (Instruction use : insn.outValue().uniqueUsers()) {
                if (use.isArrayPut()) {
                    Instruction index = use.asArrayPut().value().definition;
                    if (index == null || !index.isConstNumber()) {
                        return;
                    }
                    int integerIndex = index.asConstNumber().getIntValue();
                    Instruction value = use.asArrayPut().index().definition;
                    if (value == null || !value.isInvokeVirtual()) {
                        return;
                    }
                    InvokeVirtual invoke = value.asInvokeVirtual();
                    DexClass holder = this.appInfo.definitionFor(invoke.getInvokedMethod().holder);
                    if (holder == null || !holder.accessFlags.isEnum() && holder.type != this.appInfo.dexItemFactory.enumType) {
                        return;
                    }
                    Instruction enumGet = invoke.arguments().get((int)0).definition;
                    if (enumGet == null || !enumGet.isStaticGet()) {
                        return;
                    }
                    DexField enumField = enumGet.asStaticGet().getField();
                    if (!this.appInfo.definitionFor((DexType)enumField.getHolder()).accessFlags.isEnum()) {
                        return;
                    }
                    if (switchMap.put(integerIndex, (Object)enumField) == null) continue;
                    return;
                }
                return;
            }
        }
        this.switchMaps.put(field, (Int2ReferenceMap<DexField>)switchMap);
    }

    private boolean maybeIsSwitchMap(DexEncodedField dexEncodedField) {
        DexField field = dexEncodedField.field;
        return dexEncodedField.accessFlags.isSynthetic() && field.name.beginsWith(this.switchMapPrefix) && field.type == this.intArrayType;
    }
}

