/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

abstract class SimpleHashMap {
    private int size = 0;
    private int limit;
    private int mask;
    static final int MIN_CAPACITY = 2;
    static final int DEFAULT_CAPACITY = 50;
    static final double MIN_LOAD_FACTOR = 0.2;
    static final double MAX_LOAD_FACTOR = 0.8;
    static final double DEFAULT_LOAD_FACTOR = 0.6;

    SimpleHashMap() {
        this(50);
    }

    SimpleHashMap(int initialCapacity) {
        this(initialCapacity, 0.6);
    }

    SimpleHashMap(int initialCapacity, double loadFactor) {
        initialCapacity = Math.max(2, initialCapacity);
        loadFactor = Math.min(0.8, Math.max(0.2, loadFactor));
        int initialLength = this.roundToPow2((int)((double)initialCapacity / loadFactor));
        this.initialize(initialLength, (int)((double)initialLength * loadFactor));
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return this.getClass().getName() + ", " + this.size + "(length " + this.length() + ")";
    }

    int length() {
        return this.mask + 1;
    }

    void initialize(int length, int limit) {
        this.size = 0;
        this.mask = length - 1;
        this.limit = limit;
    }

    void resize() {
        this.initialize(this.length() << 1, this.limit << 1);
    }

    void ensureCapacity() {
        if (this.size >= this.limit) {
            this.resize();
        }
    }

    void incrementSize() {
        ++this.size;
    }

    private int roundToPow2(int number) {
        --number;
        number |= number >> 1;
        number |= number >> 2;
        number |= number >> 4;
        number |= number >> 8;
        number |= number >> 16;
        return number + 1;
    }

    int firstProbe(int hash) {
        return hash & this.mask;
    }

    int nextProbe(int last, int index) {
        return last + index & this.mask;
    }
}

