/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_BundleModuleName;
import com.google.auto.value.AutoValue;
import java.util.Comparator;
import java.util.regex.Pattern;

@AutoValue
public abstract class BundleModuleName
implements Comparable<BundleModuleName> {
    public static final String BASE_MODULE_NAME = "base";
    private static final Pattern MODULE_NAME_FORMAT = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    static boolean isValid(String name) {
        return MODULE_NAME_FORMAT.matcher(name).matches();
    }

    public static BundleModuleName create(String name) throws InvalidBundleModuleNameException {
        if (!BundleModuleName.isValid(name)) {
            throw new InvalidBundleModuleNameException(name);
        }
        return new AutoValue_BundleModuleName(name);
    }

    public abstract String getName();

    public String getNameForSplitId() {
        if (this.getName().equals(BASE_MODULE_NAME)) {
            return "";
        }
        return this.getName();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final int compareTo(BundleModuleName o) {
        return Comparator.comparing(BundleModuleName::getName).compare(this, o);
    }

    static class InvalidBundleModuleNameException
    extends IllegalArgumentException {
        InvalidBundleModuleNameException(String name) {
            super("Module names with special characters not supported: " + name);
        }
    }
}

