/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceSelector;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.bundle.SystemFeature;
import com.android.tools.build.bundletool.commands.AutoValue_PrintDeviceTargetingConfigCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.DeviceTargetingConfigEvaluator;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.android.tools.build.bundletool.validation.DeviceTierConfigValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

@AutoValue
public abstract class PrintDeviceTargetingConfigCommand {
    public static final String COMMAND_NAME = "print-device-targeting-config";
    private static final String INDENT = "  ";
    private static final Flag<Path> DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG = Flag.path("config");

    abstract Path getDeviceTargetingConfigurationPath();

    abstract PrintStream getOutputStream();

    static Builder builder() {
        return new AutoValue_PrintDeviceTargetingConfigCommand.Builder();
    }

    public static PrintDeviceTargetingConfigCommand fromFlags(ParsedFlags flags) {
        return PrintDeviceTargetingConfigCommand.fromFlags(flags, System.out);
    }

    public static PrintDeviceTargetingConfigCommand fromFlags(ParsedFlags flags, PrintStream out) {
        return PrintDeviceTargetingConfigCommand.builder().setDeviceTargetingConfigurationPath(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getRequiredValue(flags)).setOutputStream(out).build();
    }

    public void execute() throws IOException {
        try (BufferedReader configReader = BufferedIo.reader(this.getDeviceTargetingConfigurationPath());){
            DeviceTierConfig.Builder configBuilder = DeviceTierConfig.newBuilder();
            JsonFormat.parser().merge((Reader)configReader, (Message.Builder)configBuilder);
            DeviceTierConfig config = configBuilder.build();
            DeviceTierConfigValidator.validateDeviceTierConfig(config);
            for (DeviceGroup deviceGroup : config.getDeviceGroupsList()) {
                this.printDeviceGroup(deviceGroup, INDENT);
            }
            this.printDeviceTierSet(config);
        }
    }

    private void printDeviceGroup(DeviceGroup deviceGroup, String indent) {
        this.getOutputStream().println("Group '" + deviceGroup.getName() + "':");
        this.printSetOfDeviceSelectors((ImmutableSet<DeviceSelector>)ImmutableSet.copyOf(deviceGroup.getDeviceSelectorsList()), indent);
        this.getOutputStream().println();
    }

    private void printDeviceTierSet(DeviceTierConfig config) {
        ImmutableMap<String, DeviceGroup> deviceGroupNameToDeviceGroup = DeviceTargetingConfigEvaluator.getDeviceGroupNameToDeviceGroupMap(config);
        ImmutableList<DeviceTier> deviceTiers = DeviceTargetingConfigEvaluator.getSortedDeviceTiers(config);
        ImmutableSet excludedSelectorsFromHigherTiers = ImmutableSet.of();
        for (DeviceTier deviceTier : deviceTiers) {
            this.getOutputStream().println("Tier " + deviceTier.getLevel() + ":");
            ImmutableSet<DeviceSelector> selectorsFromGroupsInTier = DeviceTargetingConfigEvaluator.getDeviceSelectorsInTier(deviceTier, deviceGroupNameToDeviceGroup);
            this.printDeviceTier(selectorsFromGroupsInTier, (ImmutableSet<DeviceSelector>)excludedSelectorsFromHigherTiers, INDENT);
            excludedSelectorsFromHigherTiers = ImmutableSet.builder().addAll(selectorsFromGroupsInTier).addAll((Iterable)excludedSelectorsFromHigherTiers).build();
        }
        if (!excludedSelectorsFromHigherTiers.isEmpty()) {
            this.getOutputStream().println("Tier 0 (default):");
            this.printDeviceTier((ImmutableSet<DeviceSelector>)ImmutableSet.of(), (ImmutableSet<DeviceSelector>)excludedSelectorsFromHigherTiers, INDENT);
        }
    }

    private void printDeviceTier(ImmutableSet<DeviceSelector> selectorsFromGroupsInTier, ImmutableSet<DeviceSelector> excludedSelectorsFromHigherTiers, String indent) {
        if (selectorsFromGroupsInTier.isEmpty()) {
            this.getOutputStream().println(indent + "NOT (");
            this.printSetOfDeviceSelectors(excludedSelectorsFromHigherTiers, indent + INDENT);
        } else {
            this.getOutputStream().println(indent + "(");
            this.printSetOfDeviceSelectors(selectorsFromGroupsInTier, indent + INDENT);
            if (!excludedSelectorsFromHigherTiers.isEmpty()) {
                this.getOutputStream().println(indent + ") AND NOT (");
                this.printSetOfDeviceSelectors(excludedSelectorsFromHigherTiers, indent + INDENT);
            }
        }
        this.getOutputStream().println(indent + ")");
        this.getOutputStream().println();
    }

    private void printSetOfDeviceSelectors(ImmutableSet<DeviceSelector> deviceSelectors, String indent) {
        this.getOutputStream().println(indent + "(");
        boolean isFirstSelector = true;
        for (DeviceSelector deviceSelector : deviceSelectors) {
            if (!isFirstSelector) {
                this.getOutputStream().println(indent + ") OR (");
            }
            isFirstSelector = false;
            this.printDeviceSelector(deviceSelector, indent + INDENT);
        }
        this.getOutputStream().println(indent + ")");
    }

    private void printDeviceSelector(DeviceSelector deviceSelector, String indent) {
        boolean isFirstSelectorRule = true;
        isFirstSelectorRule = this.printRamRule(deviceSelector, isFirstSelectorRule, indent);
        isFirstSelectorRule = this.printListRule("device IN", deviceSelector.getIncludedDeviceIdsList(), deviceId -> deviceId.getBuildBrand() + " " + deviceId.getBuildDevice(), isFirstSelectorRule, indent);
        isFirstSelectorRule = this.printListRule("device NOT IN", deviceSelector.getExcludedDeviceIdsList(), deviceId -> deviceId.getBuildBrand() + " " + deviceId.getBuildDevice(), isFirstSelectorRule, indent);
        isFirstSelectorRule = this.printListRule("device HAS ALL FEATURES IN", deviceSelector.getRequiredSystemFeaturesList(), SystemFeature::getName, isFirstSelectorRule, indent);
        this.printListRule("device HAS NO FEATURES IN", deviceSelector.getForbiddenSystemFeaturesList(), SystemFeature::getName, isFirstSelectorRule, indent);
    }

    private boolean printRamRule(DeviceSelector deviceSelector, boolean isFirstSelectorRule, String indent) {
        boolean isRuleEmpty;
        long minBytes = deviceSelector.getDeviceRam().getMinBytes();
        long maxBytes = deviceSelector.getDeviceRam().getMaxBytes();
        boolean bl2 = isRuleEmpty = minBytes == 0L && maxBytes == 0L;
        if (isRuleEmpty) {
            return isFirstSelectorRule;
        }
        this.printAnd(indent + INDENT, isFirstSelectorRule);
        if (minBytes != 0L && maxBytes != 0L) {
            this.getOutputStream().println(indent + this.bytesToReadableString(minBytes) + " <= RAM < " + this.bytesToReadableString(maxBytes));
        } else if (minBytes != 0L) {
            this.getOutputStream().println(indent + "RAM >= " + this.bytesToReadableString(minBytes));
        } else {
            this.getOutputStream().println(indent + "RAM < " + this.bytesToReadableString(maxBytes));
        }
        return false;
    }

    private String bytesToReadableString(long bytes) {
        double bytesDouble = bytes;
        double gigaByte = Math.pow(1024.0, 3.0);
        double megaByte = Math.pow(1024.0, 2.0);
        double kiloByte = 1024.0;
        if (bytesDouble >= gigaByte) {
            return String.format("%.2f GB", bytesDouble / gigaByte);
        }
        if (bytesDouble >= megaByte) {
            return String.format("%.2f MB", bytesDouble / megaByte);
        }
        if (bytesDouble >= kiloByte) {
            return String.format("%.2f KB", bytesDouble / kiloByte);
        }
        return bytes + " B";
    }

    private <T> boolean printListRule(String operator, List<T> operandList, Function<T, String> operandToString, boolean isFirstSelectorRule, String indent) {
        if (operandList.isEmpty()) {
            return isFirstSelectorRule;
        }
        this.printAnd(indent + INDENT, isFirstSelectorRule);
        this.getOutputStream().println(indent + operator + " (" + this.formatOperandList(operandList, operandToString) + ")");
        return false;
    }

    private void printAnd(String indent, boolean isFirstSelectorRule) {
        if (!isFirstSelectorRule) {
            this.getOutputStream().println(indent + "AND");
        }
    }

    private <T> String formatOperandList(List<T> operandList, Function<T, String> operandToString) {
        if (operandList.size() > 3) {
            return this.formatOperandListWithEllipsis(operandList, operandToString);
        }
        StringBuilder formattedOperandList = new StringBuilder();
        for (T operand : operandList) {
            if (formattedOperandList.length() > 0) {
                formattedOperandList.append(", ");
            }
            formattedOperandList.append("'").append(operandToString.apply(operand)).append("'");
        }
        return formattedOperandList.toString();
    }

    private <T> String formatOperandListWithEllipsis(List<T> operandList, Function<T, String> operandToString) {
        return operandToString.apply(operandList.get(0)) + ", " + operandToString.apply(operandList.get(1)) + ", ..., " + operandToString.apply(Iterables.getLast(operandList));
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Prints a device targeting configuration JSON file in a human-readable format.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_TARGETING_CONFIGURATION_LOCATION_FLAG.getName()).setExampleValue("path/to/targeting/config.json").setDescription("Path to device targeting configuration JSON file.").build()).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setDeviceTargetingConfigurationPath(Path var1);

        abstract Builder setOutputStream(PrintStream var1);

        abstract PrintDeviceTargetingConfigCommand build();
    }
}

