/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import shadow.bundletool.com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i11 = 0;
        block0: while (i11 < escapedLength) {
            for (int j11 = 0; j11 < ENCODED.length; ++j11) {
                String toReplace = ENCODED[j11];
                if (i11 + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i11, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k11 = 0; k11 < i11; ++k11) {
                        offsetMap[k11] = k11;
                        decodedValue.append(encodedValue.charAt(k11));
                    }
                }
                decodedValue.append(DECODED[j11]);
                offsetMap[decodedValue.length() - 1] = i11 += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i11));
                offsetMap[decodedValue.length() - 1] = i11;
            }
            ++i11;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

