/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.ApksigSigningConfiguration;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.SigningConfigurationProvider;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import shadow.bundletool.com.android.apksig.SigningCertificateLineage;

public class DefaultSigningConfigurationProvider
implements SigningConfigurationProvider {
    private final SigningConfiguration signingConfiguration;
    private final Version bundletoolVersion;

    public DefaultSigningConfigurationProvider(SigningConfiguration signingConfiguration, Version bundletoolVersion) {
        this.signingConfiguration = signingConfiguration;
        this.bundletoolVersion = bundletoolVersion;
    }

    @Override
    public ApksigSigningConfiguration getSigningConfiguration(SigningConfigurationProvider.ApkDescription apkDescription) {
        ApksigSigningConfiguration.Builder apksigSigningConfig = ApksigSigningConfiguration.builder().setSignerConfigs(this.getSignerConfigs(apkDescription)).setV1SigningEnabled(this.shouldSignWithV1(apkDescription)).setV2SigningEnabled(true).setV3SigningEnabled(true);
        this.getSigningCertificateLineage(apkDescription).ifPresent(apksigSigningConfig::setSigningCertificateLineage);
        this.signingConfiguration.getRotationMinSdkVersion().ifPresent(apksigSigningConfig::setRotationMinSdkVersion);
        return apksigSigningConfig.build();
    }

    @Override
    public boolean hasRestrictedV3SigningConfig() {
        return this.signingConfiguration.getSigningCertificateLineage().isPresent() && this.signingConfiguration.getEffectiveMinimumV3RotationApiVersion() > 1;
    }

    private ImmutableList<SignerConfig> getSignerConfigs(SigningConfigurationProvider.ApkDescription apkDescription) {
        ImmutableList.Builder signerConfigs = ImmutableList.builder();
        Optional<SignerConfig> oldestSigner = this.signingConfiguration.getOldestSigner();
        SignerConfig newestSigner = this.signingConfiguration.getSignerConfig();
        if (this.shouldSignWithV3Rotation(apkDescription)) {
            oldestSigner.ifPresent(arg_0 -> ((ImmutableList.Builder)signerConfigs).add(arg_0));
            signerConfigs.add((Object)newestSigner);
        } else {
            signerConfigs.add((Object)oldestSigner.orElse(newestSigner));
        }
        return signerConfigs.build();
    }

    private boolean shouldSignWithV1(SigningConfigurationProvider.ApkDescription apkDescription) {
        return apkDescription.getMinSdkVersionFromManifest() < 24 || !VersionGuardedFeature.NO_V1_SIGNING_WHEN_POSSIBLE.enabledForVersion(this.bundletoolVersion);
    }

    private boolean shouldSignWithV3Rotation(SigningConfigurationProvider.ApkDescription apkDescription) {
        return apkDescription.getMinSdkVersionTargeting() >= this.signingConfiguration.getEffectiveMinimumV3RotationApiVersion();
    }

    private Optional<SigningCertificateLineage> getSigningCertificateLineage(SigningConfigurationProvider.ApkDescription apkDescription) {
        return this.signingConfiguration.getSigningCertificateLineage().filter(lineage -> this.shouldSignWithV3Rotation(apkDescription));
    }
}

