/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp.interceptor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleHeap;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleHello;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleProfiling;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.interceptor.Interceptor;

public class ClientInitializationInterceptor
implements Interceptor {
    private static int PACKET_ID_OFFSET = 4;
    private final Set<Integer> mCachePacketFilter = new HashSet<Integer>();
    private final Set<Integer> mReplyPacketFilter = new HashSet<Integer>();
    private final Map<Integer, byte[]> mCachedPackets = new HashMap<Integer, byte[]>();
    private final HashMap<Integer, Set<ClientRequestId>> mPendingPackets = new HashMap();

    public ClientInitializationInterceptor() {
        this.mCachePacketFilter.add(HandleHello.CHUNK_HELO);
        this.mCachePacketFilter.add(HandleHello.CHUNK_FEAT);
        this.mReplyPacketFilter.add(HandleProfiling.CHUNK_MPRQ);
        this.mReplyPacketFilter.add(HandleHeap.CHUNK_HPIF);
        this.mReplyPacketFilter.add(HandleHeap.CHUNK_REAQ);
    }

    @Override
    public boolean filterToDevice(JdwpProxyClient from, JdwpPacket packet) throws IOException, TimeoutException {
        if (packet.isEmpty() || packet.isError() || packet.getLength() < 15) {
            return false;
        }
        ByteBuffer payload = packet.getPayload();
        int type = payload.getInt();
        if (!this.mCachePacketFilter.contains(type) && !this.mReplyPacketFilter.contains(type)) {
            return false;
        }
        if (this.mCachedPackets.containsKey(type)) {
            this.sendCachedPacket(from, type, packet.getId());
            return true;
        }
        boolean alreadyPending = this.mPendingPackets.containsKey(type);
        this.mPendingPackets.computeIfAbsent(type, key -> new HashSet()).add(new ClientRequestId(from, packet.getId()));
        return alreadyPending;
    }

    @Override
    public boolean filterToClient(JdwpProxyClient to, JdwpPacket packet) throws IOException, TimeoutException {
        if (!packet.isReply() || packet.isEmpty() || packet.isError() || packet.getLength() < 15) {
            return false;
        }
        ByteBuffer payload = packet.getPayload();
        int type = payload.getInt();
        if (!this.mPendingPackets.containsKey(type)) {
            return false;
        }
        if (this.mCachePacketFilter.contains(type)) {
            ByteBuffer buffer = ByteBuffer.allocate(packet.getLength());
            buffer.order(ChunkHandler.CHUNK_ORDER);
            packet.copy(buffer);
            this.mCachedPackets.put(type, buffer.array());
            for (ClientRequestId pending : this.mPendingPackets.get(type)) {
                this.sendCachedPacket(pending.client, type, pending.requestId);
            }
        } else if (this.mReplyPacketFilter.contains(type)) {
            for (ClientRequestId pending : this.mPendingPackets.get(type)) {
                ClientInitializationInterceptor.sendPacketWithUpdatedPacketId(pending.client, pending.requestId, packet);
            }
        }
        this.mPendingPackets.remove(type);
        return true;
    }

    private void sendCachedPacket(JdwpProxyClient to, int type, int id) throws IOException, TimeoutException {
        ByteBuffer buffer = ByteBuffer.wrap(this.mCachedPackets.get(type));
        buffer.order(ChunkHandler.CHUNK_ORDER);
        buffer.putInt(PACKET_ID_OFFSET, id);
        to.write(buffer.array(), buffer.limit());
    }

    private static void sendPacketWithUpdatedPacketId(JdwpProxyClient to, int id, JdwpPacket packet) throws IOException, TimeoutException {
        ByteBuffer buffer = ByteBuffer.allocate(packet.getLength());
        buffer.order(ChunkHandler.CHUNK_ORDER);
        packet.copy(buffer);
        buffer.putInt(PACKET_ID_OFFSET, id);
        to.write(buffer.array(), buffer.limit());
    }

    private static class ClientRequestId {
        public JdwpProxyClient client;
        public int requestId;

        ClientRequestId(JdwpProxyClient client, int requestId) {
            this.client = client;
            this.requestId = requestId;
        }
    }
}

