/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.SourceProvider;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

final class SourceProviderImpl
implements SourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final File manifestFile;
    private final Collection<File> javaDirs;
    private final Collection<File> resourcesDirs;
    private final Collection<File> aidlDirs;
    private final Collection<File> rsDirs;
    private final Collection<File> cDirs;
    private final Collection<File> cppDirs;
    private final Collection<File> resDirs;
    private final Collection<File> assetsDirs;
    private final Collection<File> libsDirs;
    private final Collection<File> shaderDirs;

    public SourceProviderImpl(SourceProvider sourceProvider) {
        this.name = sourceProvider.getName();
        this.manifestFile = sourceProvider.getManifestFile();
        this.javaDirs = sourceProvider.getJavaDirectories();
        this.resourcesDirs = sourceProvider.getResourcesDirectories();
        this.aidlDirs = sourceProvider.getAidlDirectories();
        this.rsDirs = sourceProvider.getRenderscriptDirectories();
        this.cDirs = sourceProvider.getCDirectories();
        this.cppDirs = sourceProvider.getCDirectories();
        this.resDirs = sourceProvider.getResDirectories();
        this.assetsDirs = sourceProvider.getAssetsDirectories();
        this.libsDirs = sourceProvider.getJniLibsDirectories();
        this.shaderDirs = sourceProvider.getShadersDirectories();
    }

    public String getName() {
        return this.name;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public Collection<File> getJavaDirectories() {
        return this.javaDirs;
    }

    public Collection<File> getResourcesDirectories() {
        return this.resourcesDirs;
    }

    public Collection<File> getAidlDirectories() {
        return this.aidlDirs;
    }

    public Collection<File> getRenderscriptDirectories() {
        return this.rsDirs;
    }

    public Collection<File> getCDirectories() {
        return this.cDirs;
    }

    public Collection<File> getCppDirectories() {
        return this.cppDirs;
    }

    public Collection<File> getResDirectories() {
        return this.resDirs;
    }

    public Collection<File> getAssetsDirectories() {
        return this.assetsDirs;
    }

    public Collection<File> getJniLibsDirectories() {
        return this.libsDirs;
    }

    public Collection<File> getShadersDirectories() {
        return this.shaderDirs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceProviderImpl that = (SourceProviderImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.manifestFile, that.manifestFile) && Objects.equals(this.javaDirs, that.javaDirs) && Objects.equals(this.resourcesDirs, that.resourcesDirs) && Objects.equals(this.aidlDirs, that.aidlDirs) && Objects.equals(this.rsDirs, that.rsDirs) && Objects.equals(this.cDirs, that.cDirs) && Objects.equals(this.cppDirs, that.cppDirs) && Objects.equals(this.resDirs, that.resDirs) && Objects.equals(this.assetsDirs, that.assetsDirs) && Objects.equals(this.libsDirs, that.libsDirs) && Objects.equals(this.shaderDirs, that.shaderDirs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.manifestFile, this.javaDirs, this.resourcesDirs, this.aidlDirs, this.rsDirs, this.cDirs, this.cppDirs, this.resDirs, this.assetsDirs, this.libsDirs, this.shaderDirs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("manifestFile", (Object)this.manifestFile).add("javaDirs", this.javaDirs).add("resourcesDirs", this.resourcesDirs).add("aidlDirs", this.aidlDirs).add("rsDirs", this.rsDirs).add("cDirs", this.cDirs).add("cppDirs", this.cppDirs).add("resDirs", this.resDirs).add("assetsDirs", this.assetsDirs).add("libsDirs", this.libsDirs).add("shaderDirs", this.shaderDirs).toString();
    }
}

