/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.tasks.AnalyzeDependenciesTask;
import com.android.build.gradle.tasks.ClassFinder;
import com.android.build.gradle.tasks.DependencyGraphAnalyzer;
import com.android.build.gradle.tasks.DependencyUsageFinder;
import com.android.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/tasks/DependencyUsageReporter;", "", "variantClasses", "Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantClassesHolder;", "variantDependencies", "Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantDependenciesHolder;", "classFinder", "Lcom/android/build/gradle/tasks/ClassFinder;", "depsUsageFinder", "Lcom/android/build/gradle/tasks/DependencyUsageFinder;", "graphAnalyzer", "Lcom/android/build/gradle/tasks/DependencyGraphAnalyzer;", "(Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantClassesHolder;Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantDependenciesHolder;Lcom/android/build/gradle/tasks/ClassFinder;Lcom/android/build/gradle/tasks/DependencyUsageFinder;Lcom/android/build/gradle/tasks/DependencyGraphAnalyzer;)V", "dontReportPrefixSet", "", "", "writeMisconfiguredDependencies", "", "destinationFile", "Ljava/io/File;", "writeToFile", "output", "writeUnusedDependencies", "gradle"})
public final class DependencyUsageReporter {
    private final Set<String> dontReportPrefixSet;
    private final AnalyzeDependenciesTask.VariantClassesHolder variantClasses;
    private final AnalyzeDependenciesTask.VariantDependenciesHolder variantDependencies;
    private final ClassFinder classFinder;
    private final DependencyUsageFinder depsUsageFinder;
    private final DependencyGraphAnalyzer graphAnalyzer;

    /*
     * WARNING - void declaration
     */
    public final void writeUnusedDependencies(@NotNull File destinationFile) {
        void $this$filterTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Iterable $this$filter$iv = this.depsUsageFinder.getUnusedDirectDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.graphAnalyzer.getRenderableDependencies().containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        Set<String> toAdd = this.graphAnalyzer.findIndirectRequiredDependencies();
        boolean $this$filterTo$iv$iv2 = false;
        List dontReportTemp = new ArrayList();
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dependency = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.dontReportPrefixSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)dependency, (String)it, (boolean)false, (int)2, null)) continue;
                dontReportTemp.add(dependency);
            }
        }
        Map report2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"remove", (Object)CollectionsKt.minus((Iterable)toRemove, (Iterable)dontReportTemp)), TuplesKt.to((Object)"add", toAdd)});
        this.writeToFile(report2, destinationFile);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMisconfiguredDependencies(@NotNull File destinationFile) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Iterable $this$mapNotNull$iv = this.variantClasses.getPublicClasses();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.classFinder.find(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.variantDependencies.getApi().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List apiDependencies = (List)destination$iv$iv;
        Set misconfiguredDependencies = SetsKt.minus(this.variantDependencies.getApi(), (Iterable)apiDependencies);
        this.writeToFile(misconfiguredDependencies, destinationFile);
    }

    private final void writeToFile(Object output2, File destinationFile) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileUtils.writeToFile((File)destinationFile, (String)gson.toJson(output2));
    }

    public DependencyUsageReporter(@NotNull AnalyzeDependenciesTask.VariantClassesHolder variantClasses, @NotNull AnalyzeDependenciesTask.VariantDependenciesHolder variantDependencies, @NotNull ClassFinder classFinder, @NotNull DependencyUsageFinder depsUsageFinder, @NotNull DependencyGraphAnalyzer graphAnalyzer) {
        Intrinsics.checkParameterIsNotNull((Object)variantClasses, (String)"variantClasses");
        Intrinsics.checkParameterIsNotNull((Object)variantDependencies, (String)"variantDependencies");
        Intrinsics.checkParameterIsNotNull((Object)classFinder, (String)"classFinder");
        Intrinsics.checkParameterIsNotNull((Object)depsUsageFinder, (String)"depsUsageFinder");
        Intrinsics.checkParameterIsNotNull((Object)graphAnalyzer, (String)"graphAnalyzer");
        this.variantClasses = variantClasses;
        this.variantDependencies = variantDependencies;
        this.classFinder = classFinder;
        this.depsUsageFinder = depsUsageFinder;
        this.graphAnalyzer = graphAnalyzer;
        this.dontReportPrefixSet = SetsKt.setOf((Object[])new String[]{"org.jetbrains.kotlin:", "androidx.gridlayout:gridlayout:", "androidx.appcompat:appcompat:", "de.hdodenhof:circleimageview:"});
    }
}

