/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;

public class AlternateDisambiguationRule<T extends Named>
implements AttributeDisambiguationRule<T> {
    private final Map<String, List<String>> alternates;

    protected AlternateDisambiguationRule(Map<String, List<String>> alternates) {
        this.alternates = alternates;
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        Named consumerValue = (Named)details.getConsumerValue();
        if (consumerValue == null) {
            return;
        }
        List<String> alternatesForValue = this.alternates.get(consumerValue.getName());
        if (alternatesForValue == null) {
            return;
        }
        Set candidates = details.getCandidateValues();
        if (candidates.contains(consumerValue)) {
            details.closestMatch((Object)consumerValue);
        } else if (alternatesForValue.size() == 1) {
            String fallback = alternatesForValue.get(0);
            for (Named candidate : candidates) {
                if (!candidate.getName().equals(fallback)) continue;
                details.closestMatch((Object)candidate);
                return;
            }
        } else {
            HashMap map2 = Maps.newHashMapWithExpectedSize((int)candidates.size());
            for (Named candidate : candidates) {
                map2.put(candidate.getName(), candidate);
            }
            for (String fallback : alternatesForValue) {
                Named candidate = (Named)map2.get(fallback);
                if (candidate == null) continue;
                details.closestMatch((Object)candidate);
                return;
            }
        }
    }

    public static class ProductFlavorRule
    extends AlternateDisambiguationRule<ProductFlavorAttr> {
        @Inject
        public ProductFlavorRule(Map<String, List<String>> alternates) {
            super(alternates);
        }
    }

    public static class BuildTypeRule
    extends AlternateDisambiguationRule<BuildTypeAttr> {
        @Inject
        public BuildTypeRule(Map<String, List<String>> alternates) {
            super(alternates);
        }
    }
}

