/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.gradle.internal.ide.MajorMinorVersion;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0001H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ANDROID_GRADLE_PLUGIN_VERSION", "Lcom/android/build/gradle/internal/ide/MajorMinorVersion;", "SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "parseVersion", "version", "", "verifyIDEIsNotOld", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "injectedVersion", "androidGradlePluginVersion", "gradle-core"})
@JvmName(name="StudioVersions")
public final class StudioVersions {
    private static final Splitter SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)". "));
    private static final MajorMinorVersion ANDROID_GRADLE_PLUGIN_VERSION;

    public static final void verifyIDEIsNotOld(@NotNull ProjectOptions projectOptions) {
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        if (!projectOptions.get(BooleanOption.ENABLE_STUDIO_VERSION_CHECK)) {
            return;
        }
        StudioVersions.verifyIDEIsNotOld(projectOptions.get(StringOption.IDE_ANDROID_STUDIO_VERSION), ANDROID_GRADLE_PLUGIN_VERSION);
    }

    @VisibleForTesting
    public static final void verifyIDEIsNotOld(@Nullable String injectedVersion, @NotNull MajorMinorVersion androidGradlePluginVersion) {
        MajorMinorVersion minRequiredVersion;
        Intrinsics.checkParameterIsNotNull((Object)androidGradlePluginVersion, (String)"androidGradlePluginVersion");
        if (injectedVersion == null) {
            return;
        }
        MajorMinorVersion majorMinorVersion = StudioVersions.parseVersion(injectedVersion);
        if (majorMinorVersion == null) {
            throw (Throwable)new InvalidUserDataException("Invalid injected android support version '" + injectedVersion + "', expected to be of the form 'w.x.y.z'");
        }
        MajorMinorVersion parsedInjected = majorMinorVersion;
        MajorMinorVersion majorMinorVersion2 = androidGradlePluginVersion;
        MajorMinorVersion majorMinorVersion3 = minRequiredVersion = Intrinsics.areEqual((Object)majorMinorVersion2, (Object)new MajorMinorVersion(0, 7, 0, 1, null)) ? new MajorMinorVersion(2020, 3, 1) : androidGradlePluginVersion;
        if (parsedInjected.compareTo(minRequiredVersion) < 0 && !StringsKt.endsWith$default((String)injectedVersion, (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            throw (Throwable)new RuntimeException("This version of the Android Support plugin for IntelliJ IDEA (or Android Studio) cannot open this project, please retry with version " + androidGradlePluginVersion + " or newer.");
        }
    }

    @VisibleForTesting
    @Nullable
    public static final MajorMinorVersion parseVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Iterator segments = SPLITTER.split((CharSequence)version).iterator();
        if (!segments.hasNext()) {
            return null;
        }
        int yearVersion = 0;
        Object t = segments.next();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"segments.next()");
        Integer n = StringsKt.toIntOrNull((String)((String)t));
        if (n == null) {
            return null;
        }
        int majorVersion = n;
        if (majorVersion == 10 || majorVersion > 2000) {
            if (!segments.hasNext()) {
                return null;
            }
            yearVersion = majorVersion;
            Object t2 = segments.next();
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"segments.next()");
            Integer n2 = StringsKt.toIntOrNull((String)((String)t2));
            if (n2 == null) {
                return null;
            }
            majorVersion = n2;
        }
        if (!segments.hasNext()) {
            return null;
        }
        Object t3 = segments.next();
        Intrinsics.checkExpressionValueIsNotNull(t3, (String)"segments.next()");
        Integer n3 = StringsKt.toIntOrNull((String)((String)t3));
        if (n3 == null) {
            return null;
        }
        int minorVersion = n3;
        if (majorVersion < 0 || minorVersion < 0) {
            return null;
        }
        if (yearVersion > 2000) {
            return new MajorMinorVersion(yearVersion, majorVersion, minorVersion);
        }
        return new MajorMinorVersion(0, majorVersion, minorVersion, 1, null);
    }

    static {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Version.ANDROID_GRADLE_PLUGIN_VERSION");
        MajorMinorVersion majorMinorVersion = StudioVersions.parseVersion(string);
        if (majorMinorVersion == null) {
            Intrinsics.throwNpe();
        }
        ANDROID_GRADLE_PLUGIN_VERSION = majorMinorVersion;
    }
}

