/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.gradle.internal.instrumentation.AsmInstrumentationManager$WhenMappings;
import com.android.build.gradle.internal.instrumentation.ClassContextImpl;
import com.android.build.gradle.internal.instrumentation.ClassDataImpl;
import com.android.build.gradle.internal.instrumentation.ClassesHierarchyResolver;
import com.android.build.gradle.internal.instrumentation.FixFramesClassWriter;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002+,B/\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019J\u0016\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019J\u001e\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011J \u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/internal/instrumentation/AsmInstrumentationManager;", "", "visitors", "", "Lcom/android/build/api/instrumentation/AsmClassVisitorFactory;", "apiVersion", "", "classesHierarchyResolver", "Lcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;", "framesComputationMode", "Lcom/android/build/api/instrumentation/FramesComputationMode;", "(Ljava/util/List;ILcom/android/build/gradle/internal/instrumentation/ClassesHierarchyResolver;Lcom/android/build/api/instrumentation/FramesComputationMode;)V", "classReaderFlags", "classWriterFlags", "doInstrumentClass", "", "packageName", "", "className", "classInputStream", "Lkotlin/Function0;", "Ljava/io/InputStream;", "instrumentClassToDir", "", "classFile", "Ljava/io/File;", "outputFile", "instrumentClassToJar", "entry", "Ljava/util/zip/ZipEntry;", "jarOutputStream", "Ljava/util/zip/ZipOutputStream;", "instrumentClassesFromDirectoryToDirectory", "inputDir", "outputDir", "instrumentClassesFromJarToJar", "inputJarFile", "outputJarFile", "instrumentModifiedFile", "inputFile", "saveEntryToJar", "entryName", "byteArray", "MaxsInvalidatingClassVisitor", "MethodVisitorDelegator", "gradle-core"})
public final class AsmInstrumentationManager {
    private final int classWriterFlags;
    private final int classReaderFlags;
    private final List<AsmClassVisitorFactory<?>> visitors;
    private final int apiVersion;
    private final ClassesHierarchyResolver classesHierarchyResolver;
    private final FramesComputationMode framesComputationMode;

    public final void instrumentClassesFromDirectoryToDirectory(@NotNull File inputDir, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Path inputPath = inputDir.toPath();
        Files.walkFileTree(inputPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, inputPath, outputDir){
            final /* synthetic */ AsmInstrumentationManager this$0;
            final /* synthetic */ Path $inputPath;
            final /* synthetic */ File $outputDir;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Path relativePath;
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                Path path = relativePath = this.$inputPath.relativize(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"relativePath");
                String fileName = ((Object)path.getFileName()).toString();
                File outputFile = FilesKt.resolve((File)this.$outputDir, (String)((Object)relativePath).toString());
                outputFile.getParentFile().mkdirs();
                if (StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
                    char c = File.separatorChar;
                    boolean bl = false;
                    String string = StringsKt.replace$default((String)StringsKt.removeSuffix((String)((Object)relativePath).toString(), (CharSequence)(String.valueOf(c) + fileName)), (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                    String string2 = StringsKt.removeSuffix((String)fileName, (CharSequence)".class");
                    File file2 = file.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.toFile()");
                    AsmInstrumentationManager.access$instrumentClassToDir(this.this$0, string, string2, file2, outputFile);
                } else {
                    FileUtils.copyFile((File)file.toFile(), (File)outputFile);
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.this$0 = this$0;
                this.$inputPath = $captured_local_variable$1;
                this.$outputDir = $captured_local_variable$2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void instrumentClassesFromJarToJar(@NotNull File inputJarFile, @NotNull File outputJarFile) {
        Intrinsics.checkParameterIsNotNull((Object)inputJarFile, (String)"inputJarFile");
        Intrinsics.checkParameterIsNotNull((Object)outputJarFile, (String)"outputJarFile");
        Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJarFile)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipOutputStream outputJar = (ZipOutputStream)closeable;
            boolean bl2 = false;
            outputJar.setLevel(0);
            Closeable closeable2 = new ZipFile(inputJarFile);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                ZipFile inputJar = (ZipFile)closeable2;
                boolean bl4 = false;
                Enumeration<? extends ZipEntry> entries = inputJar.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry;
                    ZipEntry zipEntry = entry = entries.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                    this.instrumentClassToJar(zipEntry, outputJar, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(inputJar, entry){
                        final /* synthetic */ ZipFile $inputJar;
                        final /* synthetic */ ZipEntry $entry;

                        @NotNull
                        public final InputStream invoke() {
                            InputStream inputStream = this.$inputJar.getInputStream(this.$entry);
                            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputJar.getInputStream(entry)");
                            return inputStream;
                        }
                        {
                            this.$inputJar = zipFile;
                            this.$entry = zipEntry;
                            super(0);
                        }
                    }));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void instrumentModifiedFile(@NotNull File inputFile, @NotNull File outputFile, @NotNull String packageName2) {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)packageName2, (String)"packageName");
        outputFile.getParentFile().mkdirs();
        String string = inputFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputFile.name");
        if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
            String string2 = inputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputFile.name");
            this.instrumentClassToDir(packageName2, StringsKt.removeSuffix((String)string2, (CharSequence)".class"), inputFile, outputFile);
        } else {
            FileUtils.copyFile((File)inputFile, (File)outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final byte[] doInstrumentClass(String packageName2, String className, Function0<? extends InputStream> classInputStream) {
        byte[] byArray;
        void $this$filterTo$iv$iv;
        String classFullName = packageName2 + '.' + className;
        String classInternalName = StringsKt.replace$default((String)classFullName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        ClassDataImpl classData = new ClassDataImpl(classFullName, this.classesHierarchyResolver.getAnnotations(classInternalName), this.classesHierarchyResolver.getAllInterfaces(classInternalName), this.classesHierarchyResolver.getAllSuperClasses(classInternalName));
        Iterable $this$filter$iv = this.visitors;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AsmClassVisitorFactory entry = (AsmClassVisitorFactory)element$iv$iv;
            boolean bl = false;
            if (!entry.isInstrumentable((ClassData)classData)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredVisitors = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        Object object2 = filteredVisitors;
        boolean bl = false;
        if (!object2.isEmpty()) {
            object2 = (Closeable)classInputStream.invoke();
            bl = false;
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl2 = false;
                ClassContextImpl classContext = new ClassContextImpl(classData, this.classesHierarchyResolver);
                byte[] bytes2 = ByteStreams.toByteArray((InputStream)it);
                ClassReader classReader = new ClassReader(bytes2);
                FixFramesClassWriter classWriter = new FixFramesClassWriter(classReader, this.classWriterFlags, this.classesHierarchyResolver);
                ClassVisitor nextVisitor = (ClassVisitor)classWriter;
                if (this.framesComputationMode == FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_CLASSES) {
                    nextVisitor = new MaxsInvalidatingClassVisitor(this.apiVersion, (ClassVisitor)classWriter);
                }
                Iterable $this$forEach$iv = filteredVisitors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AsmClassVisitorFactory entry = (AsmClassVisitorFactory)element$iv;
                    boolean bl3 = false;
                    nextVisitor = entry.createClassVisitor((ClassContext)classContext, nextVisitor);
                }
                classReader.accept(nextVisitor, this.classReaderFlags);
                byte[] byArray2 = classWriter.toByteArray();
                byArray = byArray2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    private final void saveEntryToJar(String entryName, byte[] byteArray, ZipOutputStream jarOutputStream) {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(0L);
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.write(byteArray);
        jarOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentClassToJar(ZipEntry entry, ZipOutputStream jarOutputStream, Function0<? extends InputStream> classInputStream) {
        String className;
        String entryName;
        String string = entryName = entry.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entryName");
        if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
            Closeable closeable = (Closeable)classInputStream.invoke();
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                byte[] byArray = ByteStreams.toByteArray((InputStream)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteStreams.toByteArray(it)");
                this.saveEntryToJar(entryName, byArray, jarOutputStream);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return;
        }
        List splitName = StringsKt.split$default((CharSequence)entryName, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        String packageName2 = CollectionsKt.joinToString$default((Iterable)splitName.subList(0, splitName.size() - 1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        byte[] instrumentedByteArray2 = this.doInstrumentClass(packageName2, className = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)splitName)), (CharSequence)".class"), classInputStream);
        if (instrumentedByteArray2 == null) {
            Closeable closeable = (Closeable)classInputStream.invoke();
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                instrumentedByteArray2 = ByteStreams.toByteArray((InputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (instrumentedByteArray2 == null) {
            Intrinsics.throwNpe();
        }
        this.saveEntryToJar(entryName, instrumentedByteArray2, jarOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentClassToDir(String packageName2, String className, File classFile, File outputFile) {
        byte[] instrumentedByteArray2 = this.doInstrumentClass(packageName2, className, (Function0<? extends InputStream>)((Function0)new Function0<InputStream>(classFile){
            final /* synthetic */ File $classFile;

            @NotNull
            public final InputStream invoke() {
                Object object = this.$classFile;
                int n = 0;
                object = new FileInputStream((File)object);
                n = 8192;
                boolean bl = false;
                return object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            }
            {
                this.$classFile = file;
                super(0);
            }
        }));
        if (instrumentedByteArray2 != null) {
            Closeable closeable = new FileOutputStream(outputFile);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable;
                boolean bl2 = false;
                outputStream.write(instrumentedByteArray2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            FileUtils.copyFile((File)classFile, (File)outputFile);
        }
    }

    public AsmInstrumentationManager(@NotNull List<? extends AsmClassVisitorFactory<?>> visitors, int apiVersion, @NotNull ClassesHierarchyResolver classesHierarchyResolver2, @NotNull FramesComputationMode framesComputationMode) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
        Intrinsics.checkParameterIsNotNull((Object)classesHierarchyResolver2, (String)"classesHierarchyResolver");
        Intrinsics.checkParameterIsNotNull((Object)framesComputationMode, (String)"framesComputationMode");
        this.visitors = visitors;
        this.apiVersion = apiVersion;
        this.classesHierarchyResolver = classesHierarchyResolver2;
        this.framesComputationMode = framesComputationMode;
        switch (AsmInstrumentationManager$WhenMappings.$EnumSwitchMapping$0[this.framesComputationMode.ordinal()]) {
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        this.classWriterFlags = n2;
        switch (AsmInstrumentationManager$WhenMappings.$EnumSwitchMapping$1[this.framesComputationMode.ordinal()]) {
            case 1: 
            case 2: {
                n = 4;
                break;
            }
            default: {
                n = 8;
            }
        }
        this.classReaderFlags = n;
    }

    public static final /* synthetic */ void access$instrumentClassToDir(AsmInstrumentationManager $this, String packageName2, String className, File classFile, File outputFile) {
        $this.instrumentClassToDir(packageName2, className, classFile, outputFile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005JE\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/instrumentation/AsmInstrumentationManager$MaxsInvalidatingClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "apiVersion", "", "classVisitor", "(ILorg/objectweb/asm/ClassVisitor;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "access", "name", "", "descriptor", "signature", "exceptions", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "gradle-core"})
    private static final class MaxsInvalidatingClassVisitor
    extends ClassVisitor {
        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name2, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            MethodVisitor delegate2;
            MethodVisitor methodVisitor = delegate2 = super.visitMethod(access, name2, descriptor, signature, exceptions);
            Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"delegate");
            return new MethodVisitorDelegator(this.api, methodVisitor);
        }

        public MaxsInvalidatingClassVisitor(int apiVersion, @NotNull ClassVisitor classVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)classVisitor, (String)"classVisitor");
            super(apiVersion, classVisitor);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/instrumentation/AsmInstrumentationManager$MethodVisitorDelegator;", "Lorg/objectweb/asm/MethodVisitor;", "apiVersion", "", "methodVisitor", "(ILorg/objectweb/asm/MethodVisitor;)V", "gradle-core"})
    private static final class MethodVisitorDelegator
    extends MethodVisitor {
        public MethodVisitorDelegator(int apiVersion, @NotNull MethodVisitor methodVisitor) {
            Intrinsics.checkParameterIsNotNull((Object)methodVisitor, (String)"methodVisitor");
            super(apiVersion, methodVisitor);
        }
    }
}

