/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AarMetadataArtifact;
import com.android.build.gradle.internal.tasks.AarMetadataReader;
import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkParameters;
import com.android.repository.Revision;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;", "checkAarMetadataWorkParameters", "(Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkParameters;)V", "checkAarMetadataArtifact", "", "aarMetadataArtifact", "Lcom/android/build/gradle/internal/tasks/AarMetadataArtifact;", "execute", "getApiIntFromString", "", "sdkVersion", "", "gradle-core"})
public abstract class CheckAarMetadataWorkAction
implements WorkAction<CheckAarMetadataWorkParameters> {
    private final CheckAarMetadataWorkParameters checkAarMetadataWorkParameters;

    public void execute() {
        Object object = this.checkAarMetadataWorkParameters.getAarMetadataArtifacts().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"checkAarMetadataWorkPara\u2026arMetadataArtifacts.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AarMetadataArtifact it = (AarMetadataArtifact)element$iv;
            boolean bl = false;
            AarMetadataArtifact aarMetadataArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)aarMetadataArtifact, (String)"it");
            this.checkAarMetadataArtifact(aarMetadataArtifact);
        }
    }

    private final void checkAarMetadataArtifact(AarMetadataArtifact aarMetadataArtifact) {
        File aarMetadataFile = aarMetadataArtifact.getFile();
        String displayName = aarMetadataArtifact.getDisplayName();
        AarMetadataReader aarMetadataReader = new AarMetadataReader(aarMetadataFile);
        String aarFormatVersion = aarMetadataReader.getAarFormatVersion();
        if (aarFormatVersion == null) {
            throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                    A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties) does\n                    not specify an aarFormatVersion value, which is a required value.\n                    Dependency: " + displayName + ".\n                    AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                    ")));
        }
        try {
            Revision revision = Revision.parseRevision((String)aarFormatVersion);
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(aarFormatVersion)");
            int majorAarVersion = revision.getMajor();
            Revision revision2 = Revision.parseRevision((String)((String)this.checkAarMetadataWorkParameters.getAarFormatVersion().get()));
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"Revision.parseRevision(c\u2026s.aarFormatVersion.get())");
            int maxMajorAarVersion = revision2.getMajor();
            if (majorAarVersion > maxMajorAarVersion) {
                throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                            The aarFormatVersion (" + aarFormatVersion + ") specified in a\n                            dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                            is not compatible with this version of the Android Gradle Plugin.\n                            Please upgrade to a newer version of the Android Gradle Plugin.\n                            Dependency: " + displayName + ".\n                            AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                            ")));
            }
        }
        catch (NumberFormatException e) {
            throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid aarFormatVersion value.\n                        " + e.getMessage() + "\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
        }
        String aarMetadataVersion = aarMetadataReader.getAarMetadataVersion();
        if (aarMetadataVersion == null) {
            throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                    A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties) does\n                    not specify an aarMetadataVersion value, which is a required value.\n                    Dependency: " + displayName + ".\n                    AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                    ")));
        }
        try {
            Revision revision = Revision.parseRevision((String)aarMetadataVersion);
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(aarMetadataVersion)");
            int majorAarMetadataVersion = revision.getMajor();
            Revision revision3 = Revision.parseRevision((String)((String)this.checkAarMetadataWorkParameters.getAarMetadataVersion().get()));
            Intrinsics.checkExpressionValueIsNotNull((Object)revision3, (String)"Revision.parseRevision(c\u2026aarMetadataVersion.get())");
            int maxMajorAarMetadataVersion = revision3.getMajor();
            if (majorAarMetadataVersion > maxMajorAarMetadataVersion) {
                throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                            The aarMetadataVersion (" + aarMetadataVersion + ") specified in a\n                            dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                            is not compatible with this version of the Android Gradle Plugin.\n                            Please upgrade to a newer version of the Android Gradle Plugin.\n                            Dependency: " + displayName + ".\n                            AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                            ")));
            }
        }
        catch (NumberFormatException e) {
            throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid aarMetadataVersion value.\n                        " + e.getMessage() + "\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
        }
        String minCompileSdk = aarMetadataReader.getMinCompileSdk();
        if (minCompileSdk != null) {
            String compileSdkVersion;
            Integer minCompileSdkInt = StringsKt.toIntOrNull((String)minCompileSdk);
            if (minCompileSdkInt == null) {
                throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                        A dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                        has an invalid minCompileSdk value. minCompileSdk\n                        must be an integer.\n                        Dependency: " + displayName + ".\n                        AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                        ")));
            }
            String string = compileSdkVersion = (String)this.checkAarMetadataWorkParameters.getCompileSdkVersion().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compileSdkVersion");
            int compileSdkVersionInt = this.getApiIntFromString(string);
            if (minCompileSdkInt > compileSdkVersionInt) {
                throw (Throwable)new RuntimeException(StringsKt.trimIndent((String)("\n                            The minCompileSdk (" + minCompileSdk + ") specified in a\n                            dependency's AAR metadata (META-INF/com/android/build/gradle/aar-metadata.properties)\n                            is greater than this module's compileSdkVersion (" + compileSdkVersion + ").\n                            Dependency: " + displayName + ".\n                            AAR metadata file: " + aarMetadataFile.getAbsolutePath() + ".\n                            ")));
            }
        }
    }

    private final int getApiIntFromString(String sdkVersion) {
        Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)sdkVersion, (CharSequence)"android-"));
        return n != null ? n : SdkVersionInfo.getApiByPreviewName((String)sdkVersion, (boolean)true);
    }

    @Inject
    public CheckAarMetadataWorkAction(@NotNull CheckAarMetadataWorkParameters checkAarMetadataWorkParameters) {
        Intrinsics.checkParameterIsNotNull((Object)checkAarMetadataWorkParameters, (String)"checkAarMetadataWorkParameters");
        this.checkAarMetadataWorkParameters = checkAarMetadataWorkParameters;
    }
}

