/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class ClassTestResults
extends CompositeTestResults {
    private final String name;
    private final PackageTestResults packageResults;
    private final Set<TestResult> results = new TreeSet<TestResult>();
    private final StringBuilder standardOutput = new StringBuilder();
    private final StringBuilder standardError = new StringBuilder();

    public ClassTestResults(String name2, PackageTestResults packageResults) {
        super(packageResults);
        this.name = name2;
        this.packageResults = packageResults;
    }

    @Override
    public String getTitle() {
        return String.format("Class %s", this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int pos = this.name.lastIndexOf(".");
        if (pos != -1) {
            return this.name.substring(pos + 1);
        }
        return this.name;
    }

    public PackageTestResults getPackageResults() {
        return this.packageResults;
    }

    public Map<String, Map<String, TestResult>> getTestResultsMap() {
        HashMap map2 = Maps.newHashMap();
        for (TestResult result2 : this.results) {
            String device = result2.getDevice();
            Map deviceMap = (Map)map2.get(device);
            if (deviceMap == null) {
                deviceMap = Maps.newHashMap();
                map2.put(device, deviceMap);
            }
            deviceMap.put(result2.getName(), result2);
        }
        return map2;
    }

    public CharSequence getStandardError() {
        return this.standardError;
    }

    public CharSequence getStandardOutput() {
        return this.standardOutput;
    }

    public TestResult addTest(String testName, long duration, String device, String project, String flavor) {
        TestResult test = new TestResult(testName, duration, device, project, flavor, this);
        this.results.add(test);
        this.addDevice(device, test);
        this.addVariant(project, flavor, test);
        return this.addTest(test);
    }

    public void addStandardOutput(String textContent) {
        this.standardOutput.append(textContent);
    }

    public void addStandardError(String textContent) {
        this.standardError.append(textContent);
    }
}

