/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.Version;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.internal.build.IncludedBuildState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"ANDROID_GRADLE_PLUGIN_ID", "", "CHECK_PERFORMED", "compareVersions", "", "firstProjectPath", "firstVersion", "projectToCheck", "Lorg/gradle/api/Project;", "enforceTheSamePluginVersions", "project", "gradle-core"})
@JvmName(name="AgpVersionChecker")
public final class AgpVersionChecker {
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_ID = "com.android.base";
    private static final String CHECK_PERFORMED = "android.agp.version.check.performed";

    public static final void enforceTheSamePluginVersions(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        if (gradle.getParent() != null) {
            return;
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        ExtraPropertiesExtension extraProperties = extensionContainer.getExtraProperties();
        if (extraProperties.has(CHECK_PERFORMED)) {
            return;
        }
        String currentVersion = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        String currentProjectPath = file.getCanonicalPath();
        project.getGradle().afterProject((Action)new Action<Project>(currentProjectPath, currentVersion){
            final /* synthetic */ String $currentProjectPath;
            final /* synthetic */ String $currentVersion;

            public final void execute(Project it) {
                String string = this.$currentProjectPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentProjectPath");
                String string2 = this.$currentVersion;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"currentVersion");
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                AgpVersionChecker.access$compareVersions(string, string2, project);
            }
            {
                this.$currentProjectPath = string;
                this.$currentVersion = string2;
            }
        });
        Gradle gradle2 = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle2, (String)"project.gradle");
        Collection collection = gradle2.getIncludedBuilds();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"project.gradle.includedBuilds");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IncludedBuild includedBuild = (IncludedBuild)element$iv;
            boolean bl = false;
            IncludedBuild includedBuild2 = includedBuild;
            if (includedBuild2 instanceof IncludedBuildState) {
                ((IncludedBuildState)includedBuild).getConfiguredBuild().allprojects((Action)new Action<Project>(currentProjectPath, currentVersion, project){
                    final /* synthetic */ String $currentProjectPath$inlined;
                    final /* synthetic */ String $currentVersion$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$currentProjectPath$inlined = string;
                        this.$currentVersion$inlined = string2;
                        this.$project$inlined = project;
                    }

                    public final void execute(Project it) {
                        String string = this.$currentProjectPath$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentProjectPath");
                        String string2 = this.$currentVersion$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"currentVersion");
                        Project project = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                        AgpVersionChecker.access$compareVersions(string, string2, project);
                    }
                });
                continue;
            }
            project.getLogger().warn("Unable to detect AGP versions for included builds. All projects in the build should use the same AGP version. " + "Class name for the included build object: " + includedBuild.getClass().getName() + '.');
        }
        extraProperties.set(CHECK_PERFORMED, (Object)true);
    }

    private static final void compareVersions(String firstProjectPath, String firstVersion, Project projectToCheck) {
        File file = projectToCheck.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"projectToCheck.projectDir");
        String currentProjectPath = file.getCanonicalPath();
        projectToCheck.getPlugins().withId(ANDROID_GRADLE_PLUGIN_ID, (Action)new Action<Plugin<Object>>(projectToCheck, currentProjectPath, firstVersion, firstProjectPath){
            final /* synthetic */ Project $projectToCheck;
            final /* synthetic */ String $currentProjectPath;
            final /* synthetic */ String $firstVersion;
            final /* synthetic */ String $firstProjectPath;

            public final void execute(Plugin<Object> it) {
                String string;
                try {
                    Field field;
                    block8: {
                        Class<?> versionClass;
                        Class<?> clazz;
                        try {
                            clazz = it.getClass().getClassLoader().loadClass(Version.class.getName());
                        }
                        catch (ClassNotFoundException exception) {
                            clazz = it.getClass().getClassLoader().loadClass(com.android.builder.model.Version.class.getName());
                        }
                        Class<?> clazz2 = versionClass = clazz;
                        Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"versionClass");
                        Field[] fieldArray = clazz2.getFields();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"versionClass.fields");
                        Field[] fieldArray2 = fieldArray;
                        boolean bl = false;
                        Field[] fieldArray3 = fieldArray2;
                        boolean bl2 = false;
                        Field[] fieldArray4 = fieldArray3;
                        int n = fieldArray4.length;
                        for (int j = 0; j < n; ++j) {
                            Field field2;
                            Field it2 = field2 = fieldArray4[j];
                            boolean bl3 = false;
                            Field field3 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"it");
                            if (!Intrinsics.areEqual((Object)field3.getName(), (Object)"ANDROID_GRADLE_PLUGIN_VERSION")) continue;
                            field = field2;
                            break block8;
                        }
                        field = null;
                    }
                    if (field == null) {
                        Intrinsics.throwNpe();
                    }
                    Field field4 = field;
                    Object object = field4.get(null);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)object;
                }
                catch (Throwable ex) {
                    this.$projectToCheck.getLogger().error("Unable to get AGP version for project `" + this.$currentProjectPath + "`. All projects in the build should use the same AGP version.", ex);
                    throw ex;
                }
                String versionValue = string;
                if (Intrinsics.areEqual((Object)versionValue, (Object)this.$firstVersion) ^ true) {
                    throw (Throwable)new IllegalStateException(StringsKt.trimIndent((String)("\nUsing multiple versions of the Android Gradle plugin in the same build is not allowed.\n- Project `" + this.$firstProjectPath + "` is using version `" + this.$firstVersion + "`\n- Project `" + this.$currentProjectPath + "` is using version `" + versionValue + "`\n            ")));
                }
            }
            {
                this.$projectToCheck = project;
                this.$currentProjectPath = string;
                this.$firstVersion = string2;
                this.$firstProjectPath = string3;
            }
        });
    }

    public static final /* synthetic */ void access$compareVersions(String firstProjectPath, String firstVersion, Project projectToCheck) {
        AgpVersionChecker.compareVersions(firstProjectPath, firstVersion, projectToCheck);
    }
}

