/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"addComposeArgsToKotlinCompile", "", "task", "Lorg/gradle/api/Task;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "getKotlinCompile", "Lorg/gradle/api/tasks/TaskProvider;", "project", "Lorg/gradle/api/Project;", "recordIrBackendForAnalytics", "allPropertiesList", "", "extension", "Lcom/android/build/gradle/BaseExtension;", "composeIsEnabled", "", "setIrUsedInAnalytics", "gradle-core"})
@JvmName(name="KgpUtils")
public final class KgpUtils {
    @NotNull
    public static final TaskProvider<Task> getKotlinCompile(@NotNull Project project, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        TaskProvider taskProvider = project.getTasks().named(creationConfig.computeTaskName("compile", "Kotlin"));
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.named(crea\u2026ame(\"compile\", \"Kotlin\"))");
        return taskProvider;
    }

    public static final void recordIrBackendForAnalytics(@NotNull List<? extends ComponentCreationConfig> allPropertiesList, @NotNull BaseExtension extension, @NotNull Project project, boolean composeIsEnabled) {
        Intrinsics.checkParameterIsNotNull(allPropertiesList, (String)"allPropertiesList");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        for (ComponentCreationConfig componentCreationConfig : allPropertiesList) {
            try {
                TaskProvider<Task> compileKotlin = KgpUtils.getKotlinCompile(project, componentCreationConfig);
                compileKotlin.configure((Action)new Action<Task>(composeIsEnabled, componentCreationConfig, project, extension){
                    final /* synthetic */ boolean $composeIsEnabled;
                    final /* synthetic */ ComponentCreationConfig $creationConfig;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ BaseExtension $extension;

                    public final void execute(@NotNull Task task) {
                        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                        try {
                            if (this.$composeIsEnabled) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                            Method getKotlinOptions = task.getClass().getMethod("getKotlinOptions", new Class[0]);
                            Object taskOptions = getKotlinOptions.invoke((Object)task, new Object[0]);
                            Method getUseIR = taskOptions.getClass().getMethod("getUseIR", new Class[0]);
                            Object object = getUseIR.invoke(taskOptions, new Object[0]);
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                            }
                            if (((Boolean)object).booleanValue()) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                            BaseExtension baseExtension = this.$extension;
                            if (baseExtension == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
                            }
                            Object kotlinDslOptions = ((ExtensionAware)baseExtension).getExtensions().getByName("kotlinOptions");
                            Object object2 = getUseIR.invoke(kotlinDslOptions, new Object[0]);
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                            }
                            if (((Boolean)object2).booleanValue()) {
                                KgpUtils.access$setIrUsedInAnalytics(this.$creationConfig, this.$project);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    {
                        this.$composeIsEnabled = bl;
                        this.$creationConfig = componentCreationConfig;
                        this.$project = project;
                        this.$extension = baseExtension;
                    }
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private static final void setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project) {
        Object object = BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBuildService(\n       \u2026                   .get()");
        AnalyticsConfiguratorService buildService = (AnalyticsConfiguratorService)object;
        String string = project.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.path");
        String string2 = creationConfig.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"creationConfig.name");
        buildService.getVariantBuilder(string, string2).setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setUseIr(true));
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull Task task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkParameterIsNotNull((Object)compilerExtension, (String)"compilerExtension");
        KotlinCompile cfr_ignored_0 = (KotlinCompile)task;
        ((KotlinCompile)task).getInputs().files(new Object[]{compilerExtension}).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
        boolean debuggable = creationConfig instanceof ApkCreationConfig ? creationConfig.getDebuggable() : false;
        task.doFirst((Action)new Action<Task>(compilerExtension, debuggable){
            final /* synthetic */ FileCollection $compilerExtension;
            final /* synthetic */ boolean $debuggable;

            public final void execute(Task it) {
                List list;
                Task task = it;
                if (task == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                }
                KotlinCompile cfr_ignored_0 = (KotlinCompile)task;
                ((KotlinCompile)it).getKotlinOptions().setUseIR(true);
                KotlinJvmOptions kotlinJvmOptions = ((KotlinCompile)it).getKotlinOptions();
                Collection collection = kotlinJvmOptions.getFreeCompilerArgs();
                Object[] objectArray = new String[5];
                StringBuilder stringBuilder = new StringBuilder().append("-Xplugin=");
                Set set = this.$compilerExtension.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"compilerExtension.files");
                Object object = CollectionsKt.first((Iterable)set);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilerExtension.files.first()");
                objectArray[0] = stringBuilder.append(((File)object).getAbsolutePath()).toString();
                objectArray[1] = "-XXLanguage:+NonParenthesizedAnnotationsOnFunctionalTypes";
                objectArray[2] = "-P";
                objectArray[3] = "plugin:androidx.compose.plugins.idea:enabled=true";
                objectArray[4] = "-Xallow-jvm-ir-dependencies";
                Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
                if (this.$debuggable) {
                    list = CollectionsKt.listOf((Object[])new String[]{"-P", "plugin:androidx.compose.compiler.plugins.kotlin:liveLiterals=true", "-P", "plugin:androidx.compose.compiler.plugins.kotlin:sourceInformation=true"});
                } else {
                    boolean bl = false;
                    list = CollectionsKt.emptyList();
                }
                kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)list)));
            }
            {
                this.$compilerExtension = fileCollection2;
                this.$debuggable = bl;
            }
        });
    }

    public static final /* synthetic */ void access$setIrUsedInAnalytics(ComponentCreationConfig creationConfig, Project project) {
        KgpUtils.setIrUsedInAnalytics(creationConfig, project);
    }
}

