/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.signing.DefaultSigningConfig;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0003*\u00020\u0007\u00a8\u0006\b"}, d2={"createDefaultDebugStore", "", "defaultDebugKeystoreLocation", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "getDefaultDebugKeystoreLocation", "Lcom/android/prefs/AndroidLocationsProvider;", "gradle-core"})
@JvmName(name="GradleKeystoreHelper")
public final class GradleKeystoreHelper {
    @NotNull
    public static final File getDefaultDebugKeystoreLocation(@NotNull AndroidLocationsProvider $this$getDefaultDebugKeystoreLocation) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultDebugKeystoreLocation, (String)"<this>");
        try {
            file = KeystoreHelper.defaultDebugKeystoreLocation((AndroidLocationsProvider)$this$getDefaultDebugKeystoreLocation);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"{\n    KeystoreHelper.def\u2026gKeystoreLocation(this)\n}");
        }
        catch (AndroidLocationsException e) {
            throw new InvalidUserDataException("Failed to get default debug keystore location.", (Throwable)e);
        }
        return file;
    }

    public static final void createDefaultDebugStore(@NotNull File defaultDebugKeystoreLocation, @NotNull Logger logger) throws IOException {
        Intrinsics.checkNotNullParameter((Object)defaultDebugKeystoreLocation, (String)"defaultDebugKeystoreLocation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        DefaultSigningConfig.DebugSigningConfig signingConfig2 = new DefaultSigningConfig.DebugSigningConfig(defaultDebugKeystoreLocation);
        logger.info("Creating default debug keystore at {}", (Object)defaultDebugKeystoreLocation.getAbsolutePath());
        try {
            if (!KeystoreHelper.createDebugStore((String)signingConfig2.getStoreType(), (File)signingConfig2.getStoreFile(), (String)signingConfig2.getStorePassword(), (String)signingConfig2.getKeyPassword(), (String)signingConfig2.getKeyAlias(), (ILogger)new LoggerWrapper(logger))) {
                throw new IOException("Unable to create missing debug keystore.");
            }
        }
        catch (KeytoolException e) {
            throw new IOException(e);
        }
    }
}

