/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantBuilderImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureNameWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.tasks.sync.DynamicFeatureVariantModelTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B[\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/DynamicFeatureTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantBuilderImpl;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantImpl;", "project", "Lorg/gradle/api/Project;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/api/component/impl/TestComponentImpl;", "testFixturesComponents", "Lcom/android/build/api/component/impl/TestFixturesImpl;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "localConfig", "Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;", "extension", "Lcom/android/build/gradle/BaseExtension;", "(Lorg/gradle/api/Project;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;Lcom/android/build/gradle/BaseExtension;)V", "createDynamicBundleTask", "", "variantProperties", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "doCreateTasksForVariant", "variantInfo", "gradle-core"})
public final class DynamicFeatureTaskManager
extends AbstractAppTaskManager<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> {
    public DynamicFeatureTaskManager(@NotNull Project project2, @NotNull List<? extends ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl>> variants, @NotNull List<? extends TestComponentImpl> testComponents, @NotNull List<? extends TestFixturesImpl> testFixturesComponents, @NotNull GlobalTaskCreationConfig globalConfig, @NotNull TaskManagerConfig localConfig, @NotNull BaseExtension extension) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)globalConfig, (String)"globalConfig");
        Intrinsics.checkNotNullParameter((Object)localConfig, (String)"localConfig");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        super(project2, variants, testComponents, testFixturesComponents, globalConfig, localConfig, extension);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> variantInfo) {
        Intrinsics.checkNotNullParameter(variantInfo, (String)"variantInfo");
        this.createCommonTasks(variantInfo);
        DynamicFeatureVariantImpl variant2 = variantInfo.getVariant();
        this.createDynamicBundleTask(variant2);
        this.taskFactory.register(new DynamicFeatureVariantModelTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureSplitDeclarationWriterTask.CreationAction(variant2));
        if (variant2.getBuildFeatures().getDataBinding()) {
            this.taskFactory.register(new DataBindingExportFeatureInfoTask.CreationAction(variant2));
        }
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureNameWriterTask.CreationAction(variant2));
    }

    private final void createDynamicBundleTask(DynamicFeatureVariantImpl variantProperties) {
        if (this.globalConfig.getNamespacedAndroidResources()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variantProperties));
        if (!variantProperties.getDebuggable()) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variantProperties));
        }
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
    }
}

