/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.SingleInitialProviderRequestImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestResultAggregationTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.utp.UtpTestSuiteResultMerger;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestResultAggregationTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "inputTestResultProtos", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputTestResultProtos", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputTestResultProto", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputTestResultProto", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestResultAggregationTask
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getInputTestResultProtos();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputTestResultProto();

    @Override
    protected void doTaskAction() {
        FileCollection resultProtos2 = this.getInputTestResultProtos().filter((Spec)doTaskAction.resultProtos.1.INSTANCE);
        if (!resultProtos2.isEmpty()) {
            UtpTestSuiteResultMerger resultMerger = new UtpTestSuiteResultMerger();
            Intrinsics.checkNotNullExpressionValue((Object)resultProtos2, (String)"resultProtos");
            Iterable $this$forEach$iv = (Iterable)resultProtos2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File resultProtoFile = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)resultProtoFile, (String)"resultProtoFile");
                File file = resultProtoFile;
                boolean bl2 = false;
                TestSuiteResultProto.TestSuiteResult proto = TestSuiteResultProto.TestSuiteResult.parseFrom((InputStream)new FileInputStream(file));
                Intrinsics.checkNotNullExpressionValue((Object)proto, (String)"proto");
                resultMerger.merge(proto);
            }
            File mergedTestResultPbFile = ((RegularFile)this.getOutputTestResultProto().get()).getAsFile();
            TestSuiteResultProto.TestSuiteResult testSuiteResult = resultMerger.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)mergedTestResultPbFile, (String)"mergedTestResultPbFile");
            File file = mergedTestResultPbFile;
            boolean bl = false;
            testSuiteResult.writeTo((OutputStream)new FileOutputStream(file));
            this.getLogger().lifecycle("\nTest results saved as " + mergedTestResultPbFile.toURI() + ".\nInspect these results in Android Studio by selecting Run > Import Tests From File from the menu bar and importing test-result.pb.");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B#\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestResultAggregationTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestResultAggregationTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "deviceTestResultFiles", "", "Ljava/io/File;", "testResultOutputFile", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Ljava/util/List;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ManagedDeviceInstrumentationTestResultAggregationTask, VariantCreationConfig> {
        @NotNull
        private final List<File> deviceTestResultFiles;
        @NotNull
        private final File testResultOutputFile;

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull List<? extends File> deviceTestResultFiles, @NotNull File testResultOutputFile) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(deviceTestResultFiles, (String)"deviceTestResultFiles");
            Intrinsics.checkNotNullParameter((Object)testResultOutputFile, (String)"testResultOutputFile");
            super((ComponentCreationConfig)creationConfig);
            this.deviceTestResultFiles = deviceTestResultFiles;
            this.testResultOutputFile = testResultOutputFile;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("merge", "TestResultProtos");
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestResultAggregationTask> getType() {
            return ManagedDeviceInstrumentationTestResultAggregationTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceInstrumentationTestResultAggregationTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            SingleInitialProviderRequestImpl singleInitialProviderRequestImpl = ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE);
            String string = this.testResultOutputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testResultOutputFile.name");
            singleInitialProviderRequestImpl.withName(string).atLocation(this.testResultOutputFile.getParentFile().getAbsolutePath()).on(InternalArtifactType.MANAGED_DEVICE_ANDROID_TEST_MERGED_RESULTS_PROTO.INSTANCE);
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestResultAggregationTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{this.deviceTestResultFiles};
            task.getInputTestResultProtos().from(objectArray);
        }
    }
}

