/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MergingLogRewriter
implements MessageReceiver {
    private final MessageReceiver mMessageReceiver;
    private final Function<SourceFilePosition, SourceFilePosition> mGetOriginalPosition;

    public MergingLogRewriter(Function<SourceFilePosition, SourceFilePosition> mergingLogLookup, MessageReceiver messageReceiver) {
        this.mMessageReceiver = messageReceiver;
        this.mGetOriginalPosition = mergingLogLookup;
    }

    @Override
    public void receiveMessage(Message message2) {
        List<SourceFilePosition> originalPositions = message2.getSourceFilePositions();
        Iterable positions = originalPositions.stream().map(this.mGetOriginalPosition).collect(Collectors.toList());
        this.mMessageReceiver.receiveMessage(new Message(message2.getKind(), message2.getText(), message2.getRawMessage(), message2.getToolName(), ImmutableList.copyOf(positions)));
    }

    public static Function<SourceFilePosition, SourceFilePosition> rewriteDir(File from2, File to) {
        return input2 -> {
            File file2 = input2.getFile().getSourceFile();
            if (file2 != null && file2.toPath().startsWith(from2.toPath())) {
                return new SourceFilePosition(new SourceFile(to.toPath().resolve(from2.toPath().relativize(file2.toPath())).toFile()), input2.getPosition());
            }
            return input2;
        };
    }
}

