/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.google.common.base.Strings;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;

public class SourceFileJsonTypeAdapter
extends TypeAdapter<SourceFile> {
    private static final String PATH = "path";
    private static final String DESCRIPTION = "description";

    @Override
    public void write(JsonWriter out, SourceFile src) throws IOException {
        String path = src.getSourcePath();
        String description = src.getDescription();
        if (description == null && path != null) {
            out.value(path);
            return;
        }
        out.beginObject();
        if (description != null) {
            out.name(DESCRIPTION).value(description);
        }
        if (path != null) {
            out.name(PATH).value(path);
        }
        out.endObject();
    }

    @Override
    public SourceFile read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case BEGIN_OBJECT: {
                in.beginObject();
                String filePath = null;
                String description = null;
                while (in.hasNext()) {
                    String name2 = in.nextName();
                    if (name2.equals(PATH)) {
                        filePath = in.nextString();
                        continue;
                    }
                    if (DESCRIPTION.equals(name2)) {
                        description = in.nextString();
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
                if (!Strings.isNullOrEmpty(filePath)) {
                    File file2 = new File(filePath);
                    SourceFile sf = !Strings.isNullOrEmpty(description) ? new SourceFile(file2, description) : new SourceFile(file2);
                    return sf;
                }
                if (!Strings.isNullOrEmpty(description)) {
                    return new SourceFile(description);
                }
                return SourceFile.UNKNOWN;
            }
            case STRING: {
                String fileName = in.nextString();
                if (Strings.isNullOrEmpty(fileName)) {
                    return SourceFile.UNKNOWN;
                }
                return new SourceFile(new File(fileName));
            }
        }
        return SourceFile.UNKNOWN;
    }
}

