/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001c\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/ide/common/build/ListingFileRedirect;", "", "()V", "REDIRECT_FILE_NAME", "", "REDIRECT_MARKER", "REDIRECT_PROPERTY_NAME", "getListingFile", "Ljava/io/File;", "inputFile", "maybeExtractRedirectedFile", "redirectFile", "redirectFileContent", "writeRedirect", "", "listingFile", "into", "sdk-common"})
public final class ListingFileRedirect {
    @NotNull
    public static final ListingFileRedirect INSTANCE = new ListingFileRedirect();
    @NotNull
    public static final String REDIRECT_MARKER = "#- File Locator -";
    @NotNull
    public static final String REDIRECT_PROPERTY_NAME = "listingFile";
    @NotNull
    public static final String REDIRECT_FILE_NAME = "redirect.txt";

    private ListingFileRedirect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRedirect(@NotNull File listingFile, @NotNull File into) {
        Object object;
        Intrinsics.checkNotNullParameter(listingFile, REDIRECT_PROPERTY_NAME);
        Intrinsics.checkNotNullParameter(into, "into");
        try {
            object = ((Object)into.getParentFile().toPath().relativize(listingFile.toPath())).toString();
        }
        catch (IllegalArgumentException ex) {
            object = listingFile.getCanonicalPath();
        }
        String path = object;
        object = new PrintWriter(into);
        Throwable throwable = null;
        try {
            PrintWriter it = (PrintWriter)object;
            boolean bl2 = false;
            it.println(REDIRECT_MARKER);
            Intrinsics.checkNotNullExpressionValue(path, "path");
            it.println("listingFile=" + StringsKt.replace$default(path, "\\", "/", false, 4, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    @Nullable
    public final File maybeExtractRedirectedFile(@NotNull File redirectFile, @Nullable String redirectFileContent) {
        File file2;
        String fileContent;
        Intrinsics.checkNotNullParameter(redirectFile, "redirectFile");
        String string2 = redirectFileContent;
        if (string2 == null) {
            string2 = FilesKt.readText$default(redirectFile, null, 1, null);
        }
        if (StringsKt.startsWith$default(fileContent = string2, REDIRECT_MARKER, false, 2, null)) {
            Properties properties;
            Properties it = properties = new Properties();
            boolean bl2 = false;
            it.load(new StringReader(fileContent));
            Properties fileLocator = properties;
            File file3 = new File(fileLocator.getProperty(REDIRECT_PROPERTY_NAME));
            if (!file3.isAbsolute()) {
                File file4 = redirectFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue(file4, "redirectFile.parentFile");
                file2 = FilesKt.resolve(file4, file3);
            } else {
                file2 = file3;
            }
        } else {
            file2 = null;
        }
        return file2;
    }

    public static /* synthetic */ File maybeExtractRedirectedFile$default(ListingFileRedirect listingFileRedirect, File file2, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        return listingFileRedirect.maybeExtractRedirectedFile(file2, string2);
    }

    @NotNull
    public final File getListingFile(@NotNull File inputFile) {
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        File file2 = ListingFileRedirect.maybeExtractRedirectedFile$default(this, inputFile, null, 2, null);
        if (file2 == null) {
            file2 = inputFile;
        }
        return file2;
    }
}

