/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.LineCollector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SplitSelectTool {
    public static List<String> splitSelect(ProcessExecutor processExecutor, File splitSelectExec, String deviceConfig, String mainApkPath, Collection<String> splitApksPath) throws ProcessException {
        ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
        processBuilder.setExecutable(splitSelectExec);
        processBuilder.addArgs("--target", deviceConfig);
        processBuilder.addArgs("--base", mainApkPath);
        for (String apkPath : splitApksPath) {
            processBuilder.addArgs("--split", apkPath);
        }
        SplitSelectOutputHandler outputHandler = new SplitSelectOutputHandler();
        processExecutor.execute(processBuilder.createProcess(), outputHandler).rethrowFailure().assertNormalExitValue();
        return outputHandler.getResultApks();
    }

    private static class SplitSelectOutputHandler
    extends BaseProcessOutputHandler {
        private final List<String> resultApks = new ArrayList<String>();

        private SplitSelectOutputHandler() {
        }

        public List<String> getResultApks() {
            return this.resultApks;
        }

        @Override
        public void handleOutput(ProcessOutput processOutput) throws ProcessException {
            if (processOutput instanceof BaseProcessOutputHandler.BaseProcessOutput) {
                BaseProcessOutputHandler.BaseProcessOutput impl = (BaseProcessOutputHandler.BaseProcessOutput)processOutput;
                LineCollector lineCollector = new LineCollector();
                impl.processStandardOutputLines(lineCollector);
                this.resultApks.addAll((Collection<String>)lineCollector.getResult());
                String stderr = impl.getErrorOutputAsString();
                if (!stderr.isEmpty()) {
                    throw new RuntimeException("split-select:" + stderr);
                }
            } else {
                throw new IllegalArgumentException("processOutput was not created by this handler.");
            }
        }
    }
}

