/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.process;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.google.common.base.Charsets;
import com.google.common.io.FileBackedOutputStream;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseProcessOutputHandler
implements ProcessOutputHandler {
    @Override
    public ProcessOutput createOutput() {
        return new BaseProcessOutput();
    }

    public static final class BaseProcessOutput
    implements ProcessOutput {
        private final FileBackedOutputStream mStandardOutput = new FileBackedOutputStream(10240, true);
        private final FileBackedOutputStream mErrorOutput = new FileBackedOutputStream(10240, true);
        private final AtomicBoolean mClosed = new AtomicBoolean(false);

        @Override
        public FileBackedOutputStream getStandardOutput() {
            return this.mStandardOutput;
        }

        @Override
        public FileBackedOutputStream getErrorOutput() {
            return this.mErrorOutput;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.mClosed.get()) {
                this.mStandardOutput.close();
                this.mErrorOutput.close();
                this.mClosed.set(true);
            }
        }

        public <T> T processErrorOutputLines(LineProcessor<T> lineProcessor) throws ProcessException {
            return this.processOutputStreamLines(this.mErrorOutput, lineProcessor);
        }

        public <T> T processStandardOutputLines(LineProcessor<T> lineProcessor) throws ProcessException {
            return this.processOutputStreamLines(this.mStandardOutput, lineProcessor);
        }

        private <T> T processOutputStreamLines(FileBackedOutputStream outputStream, LineProcessor<T> lineProcessor) throws ProcessException {
            if (!this.mClosed.get()) {
                throw new ProcessException("Output and Error streams not closed");
            }
            try {
                return outputStream.asByteSource().asCharSource(Charsets.UTF_8).readLines(lineProcessor);
            }
            catch (IOException e2) {
                throw new ProcessException(e2);
            }
        }

        public Reader getStandardOutputAsReader() throws IOException {
            return this.mStandardOutput.asByteSource().asCharSource(Charsets.UTF_8).openBufferedStream();
        }

        public String getStandardOutputAsString() throws ProcessException {
            return this.getString(this.mStandardOutput);
        }

        public String getErrorOutputAsString() throws ProcessException {
            return this.getString(this.mErrorOutput);
        }

        private String getString(FileBackedOutputStream stream) throws ProcessException {
            if (!this.mClosed.get()) {
                throw new ProcessException("Output and Error streams not closed");
            }
            try {
                return stream.asByteSource().asCharSource(Charsets.UTF_8).read();
            }
            catch (IOException e2) {
                throw new ProcessException(e2);
            }
        }
    }
}

