/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayResourceValueImpl
extends ResourceValueImpl
implements ArrayResourceValue {
    private final List<String> elements = new ArrayList<String>();

    public ArrayResourceValueImpl(ResourceNamespace namespace, String name2, String libraryName) {
        super(namespace, ResourceType.ARRAY, name2, null, libraryName);
    }

    public ArrayResourceValueImpl(ResourceReference reference, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.ARRAY);
    }

    @Override
    public int getElementCount() {
        return this.elements.size();
    }

    @Override
    public String getElement(int index2) {
        return this.elements.get(index2);
    }

    public void addElement(String value) {
        this.elements.add(value);
    }

    @Override
    public Iterator<String> iterator() {
        return this.elements.iterator();
    }

    protected int getDefaultIndex() {
        return 0;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && !this.elements.isEmpty()) {
            return this.elements.get(this.getDefaultIndex());
        }
        return super.getValue();
    }
}

