/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ResourceValueImpl
implements ResourceValue {
    private final ResourceType resourceType;
    private final ResourceNamespace namespace;
    private final String name;
    private final String libraryName;
    private String value;
    protected transient ResourceNamespace.Resolver mNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    public ResourceValueImpl(ResourceNamespace namespace, ResourceType type, String name2, String value, String libraryName) {
        this.namespace = namespace;
        this.resourceType = type;
        this.name = name2;
        this.value = value;
        this.libraryName = libraryName;
    }

    public ResourceValueImpl(ResourceNamespace namespace, ResourceType type, String name2, String value) {
        this(namespace, type, name2, value, null);
    }

    public ResourceValueImpl(ResourceReference reference, String value, String libraryName) {
        this(reference.getNamespace(), reference.getResourceType(), reference.getName(), value, libraryName);
    }

    public ResourceValueImpl(ResourceReference reference, String value) {
        this(reference, value, null);
    }

    @Override
    public final ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public final ResourceNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public boolean isUserDefined() {
        return !this.isFramework() && this.libraryName == null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public ResourceReference asReference() {
        return new ResourceReference(this.namespace, this.resourceType, this.name);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void replaceWith(ResourceValue value) {
        this.value = value.getValue();
    }

    @Override
    public ResourceNamespace.Resolver getNamespaceResolver() {
        return this.mNamespaceResolver;
    }

    public void setNamespaceResolver(ResourceNamespace.Resolver resolver2) {
        this.mNamespaceResolver = resolver2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ResourceValueImpl that = (ResourceValueImpl)o2;
        return this.resourceType == that.getResourceType() && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.libraryName, that.libraryName) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceType, this.namespace, this.name, this.libraryName, this.value});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespace", this.getNamespace()).add("type", (Object)this.getResourceType()).add("name", this.getName()).add("value", this.getValue()).toString();
    }
}

