/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.KnownVersionStability;
import com.android.utils.HashCodes;
import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleVersionRange {
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\[([^,)]+),([^,)]+)\\)");
    private final Version myMin;
    private final Version myMax;

    public static GradleVersionRange parse(String value) {
        return GradleVersionRange.parse(value, KnownVersionStability.INCOMPATIBLE);
    }

    public static GradleVersionRange parse(String value, KnownVersionStability stability) {
        if (!value.startsWith("[")) {
            Version minimum = Version.parse(value);
            return new GradleVersionRange(minimum, stability.expiration(minimum));
        }
        Matcher matcher = RANGE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw GradleVersionRange.parsingFailure(value);
        }
        return new GradleVersionRange(Version.parse(matcher.group(1)), Version.prefixInfimum(matcher.group(2)));
    }

    public static GradleVersionRange tryParse(String value, KnownVersionStability stability) {
        try {
            return GradleVersionRange.parse(value, stability);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static GradleVersionRange tryParse(String value) {
        return GradleVersionRange.tryParse(value, KnownVersionStability.INCOMPATIBLE);
    }

    private static IllegalArgumentException parsingFailure(String value) {
        return new IllegalArgumentException(String.format("'%1$s' is not a valid version range", value));
    }

    private GradleVersionRange(Version min2, Version max) {
        this.myMin = min2;
        if (max != null && !max.isPrefixInfimum()) {
            throw new IllegalArgumentException("max is not an exclusive upper bound");
        }
        this.myMax = max;
    }

    public Version getMin() {
        return this.myMin;
    }

    public Version getMax() {
        return this.myMax;
    }

    public GradleVersionRange intersection(GradleVersionRange other) {
        if (this.myMax == null && other.myMax == null) {
            return other.myMin.equals(this.myMin) ? this : null;
        }
        if (this.myMax == null) {
            return this.myMin.compareTo(other.myMin) >= 0 && this.myMin.compareTo(other.myMax) < 0 ? this : null;
        }
        if (other.myMax == null) {
            return other.myMin.compareTo(this.myMin) >= 0 && other.myMin.compareTo(this.myMax) < 0 ? other : null;
        }
        Version min2 = this.myMin.compareTo(other.myMin) >= 0 ? this.myMin : other.myMin;
        Version max = this.myMax.compareTo(other.myMax) <= 0 ? this.myMax : other.myMax;
        return min2.compareTo(max) < 0 ? new GradleVersionRange(min2, max) : null;
    }

    public GradleVersionRange intersection(Version version) {
        return this.intersection(new GradleVersionRange(version, null));
    }

    public int hashCode() {
        return HashCodes.mix(this.myMin.hashCode(), this.myMax != null ? this.myMax.hashCode() : 0);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GradleVersionRange)) {
            return false;
        }
        GradleVersionRange range = (GradleVersionRange)other;
        return Objects.equal(this.myMin, range.myMin) && Objects.equal(this.myMax, range.myMax);
    }

    public String toString() {
        if (this.myMax == null) {
            return this.myMin.toString();
        }
        return String.format("[%1$s,%2$s)", this.myMin, this.myMax.prefixVersion());
    }
}

