/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.DataItem;
import com.google.common.io.Files;
import java.io.File;
import java.util.Locale;

class AssetItem
extends DataItem<AssetFile> {
    AssetItem(String name2) {
        super(name2);
    }

    static AssetItem create(File sourceFolder, File file2) {
        StringBuilder sb = new StringBuilder();
        AssetItem.computePath(sb, file2.getParentFile(), sourceFolder);
        String fileName = file2.getName();
        sb.append(AssetItem.shouldBeUnGzipped(fileName) ? Files.getNameWithoutExtension(fileName) : fileName);
        return new AssetItem(sb.toString());
    }

    private static void computePath(StringBuilder sb, File current2, File stop) {
        if (current2.equals(stop)) {
            return;
        }
        AssetItem.computePath(sb, current2.getParentFile(), stop);
        sb.append(current2.getName()).append('/');
    }

    boolean shouldBeUnGzipped() {
        return AssetItem.shouldBeUnGzipped(this.getFile().getName());
    }

    private static boolean shouldBeUnGzipped(String fileName) {
        return Files.getFileExtension(fileName).toLowerCase(Locale.US).equals("gz");
    }
}

