/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.AssetItem;
import com.android.ide.common.resources.DataSet;
import com.android.ide.common.resources.MergingException;
import com.android.utils.ILogger;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AssetSet
extends DataSet<AssetItem, AssetFile> {
    public AssetSet(String configName, String aaptEnv) {
        super(configName, true, aaptEnv);
    }

    @Override
    protected DataSet<AssetItem, AssetFile> createSet(String name2, String aaptEnv) {
        return new AssetSet(name2, aaptEnv);
    }

    @Override
    protected AssetFile createFileAndItems(File sourceFolder, File file2, ILogger logger, DocumentBuilderFactory factory) {
        return new AssetFile(file2, AssetItem.create(sourceFolder, file2));
    }

    @Override
    protected AssetFile createFileAndItemsFromXml(File file2, Node fileNode) {
        Attr nameAttr = (Attr)fileNode.getAttributes().getNamedItem("name");
        if (nameAttr == null) {
            return null;
        }
        AssetItem item = new AssetItem(nameAttr.getValue());
        return new AssetFile(file2, item);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file2) {
        File parent;
        if (!super.isValidSourceFile(sourceFolder, file2)) {
            return false;
        }
        for (parent = file2.getParentFile(); parent != null && !parent.equals(sourceFolder); parent = parent.getParentFile()) {
            if (!this.isIgnored(parent)) continue;
            return false;
        }
        return parent != null;
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        this.readFiles(sourceFolder, sourceFolder, logger, factory);
    }

    private void readFiles(File sourceFolder, File folder, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        File[] files2 = folder.listFiles();
        if (files2 != null && files2.length > 0) {
            for (File file2 : files2) {
                if (this.isIgnored(file2)) continue;
                if (file2.isFile()) {
                    this.handleNewFile(sourceFolder, file2, logger, factory);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.readFiles(sourceFolder, file2, logger, factory);
            }
        }
    }
}

