/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.DataItem;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DataFile<I extends DataItem>
implements Serializable {
    private final FileType mType;
    protected File mFile;
    protected final Map<String, I> mItems;

    DataFile(File file2, FileType fileType) {
        this.mType = fileType;
        this.mFile = file2;
        this.mItems = fileType == FileType.SINGLE_FILE ? Maps.newHashMapWithExpectedSize(1) : new LinkedHashMap<String, I>();
    }

    protected final void init(I item) {
        this.addItem(item);
    }

    protected final void init(Iterable<I> items) {
        this.addItems(items);
    }

    FileType getType() {
        return this.mType;
    }

    public File getFile() {
        return this.mFile;
    }

    I getItem() {
        assert (this.mItems.size() == 1);
        return (I)((DataItem)this.mItems.values().iterator().next());
    }

    boolean hasNotRemovedItems() {
        for (DataItem item : this.mItems.values()) {
            if (item.isRemoved()) continue;
            return true;
        }
        return false;
    }

    public Collection<I> getItems() {
        return this.mItems.values();
    }

    public Map<String, I> getItemMap() {
        return this.mItems;
    }

    public void addItem(I item) {
        ((DataItem)item).setSourceFile((DataFile)this);
        this.mItems.put(((DataItem)item).getKey(), item);
    }

    public void addItems(Iterable<I> items) {
        for (DataItem item : items) {
            item.setSourceFile(this);
            this.mItems.put(item.getKey(), item);
        }
    }

    public void removeItem(I item) {
        this.mItems.remove(((DataItem)item).getKey());
        ((DataItem)item).setSourceFile(null);
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    public void replace(I oldItem, I newItem) {
        this.mItems.remove(((DataItem)oldItem).getKey());
        ((DataItem)oldItem).setSourceFile(null);
        ((DataItem)newItem).setSourceFile((DataFile)this);
        this.mItems.put(((DataItem)newItem).getKey(), newItem);
    }

    public String toString() {
        return "DataFile{mFile=" + this.mFile + "}";
    }

    public static enum FileType {
        SINGLE_FILE,
        GENERATED_FILES,
        XML_VALUES;

    }
}

