/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.DataFile;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataItem<F extends DataFile>
implements Serializable {
    private static final int MASK_TOUCHED = 1;
    private static final int MASK_REMOVED = 2;
    private static final int MASK_WRITTEN = 16;
    private final String mName;
    private F mSourceFile;
    private int mStatus = 0;

    DataItem(String name2) {
        this.mName = Preconditions.checkNotNull(name2);
    }

    public String getName() {
        return this.mName;
    }

    public F getSourceFile() {
        return this.mSourceFile;
    }

    public void setSourceFile(F sourceFile) {
        this.mSourceFile = sourceFile;
    }

    DataItem<F> resetStatus() {
        this.mStatus = 0;
        return this;
    }

    DataItem<F> resetStatusToWritten() {
        this.mStatus = 16;
        return this;
    }

    DataItem<F> resetStatusToTouched() {
        boolean wasTouched = this.isTouched();
        this.mStatus = 1;
        if (!wasTouched) {
            this.wasTouched();
        }
        return this;
    }

    DataItem<F> setWritten() {
        this.mStatus |= 0x10;
        return this;
    }

    DataItem<F> setRemoved() {
        this.mStatus |= 2;
        return this;
    }

    DataItem<F> setTouched() {
        if (!this.isTouched()) {
            this.mStatus |= 1;
            this.wasTouched();
        }
        return this;
    }

    boolean isRemoved() {
        return (this.mStatus & 2) != 0;
    }

    boolean isTouched() {
        return (this.mStatus & 1) != 0;
    }

    boolean isWritten() {
        return (this.mStatus & 0x10) != 0;
    }

    protected int getStatus() {
        return this.mStatus;
    }

    public String getKey() {
        return this.mName;
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    Node getDetailsXml(Document document) {
        return null;
    }

    public boolean equals(Object o2) {
        F otherSource;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DataItem other = (DataItem)o2;
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        F source = this.getSourceFile();
        if (source == (otherSource = other.getSourceFile())) {
            return true;
        }
        if (source == null != (otherSource == null)) {
            return false;
        }
        return ((DataFile)source).getFile().equals(((DataFile)otherSource).getFile());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    protected void wasTouched() {
    }

    public File getFile() {
        F source = this.getSourceFile();
        return source == null ? null : ((DataFile)source).getFile();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", this.mName).add("sourceFile", this.mSourceFile).add("isRemoved", this.isRemoved()).add("isTouched", this.isTouched()).add("isWritten", this.isWritten()).toString();
    }
}

