/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.resources.AndroidAaptIgnore;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.DataMap;
import com.android.ide.common.resources.DuplicateDataException;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.PatternBasedFileFilter;
import com.android.ide.common.resources.SourceSet;
import com.android.utils.HashCodes;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DataSet<I extends DataItem<F>, F extends DataFile<I>>
implements SourceSet,
DataMap<I> {
    static final String NODE_SOURCE = "source";
    static final String NODE_FILE = "file";
    static final String ATTR_CONFIG = "config";
    static final String ATTR_PATH = "path";
    static final String ATTR_NAME = "name";
    static final String ATTR_TIMESTAMP = "timestamp";
    static final String ATTR_IGNORE_PATTERN = "ignore_pattern";
    private final String mConfigName;
    private final boolean mValidateEnabled;
    private final List<File> mSourceFiles = new ArrayList<File>();
    private final ListMultimap<String, I> mItems = LinkedListMultimap.create();
    private String allowedFolderPrefix = "";
    private final ListMultimap<File, F> mSourceFileToDataFilesMap = ArrayListMultimap.create();
    private final Map<File, F> mDataFileMap = new HashMap<File, F>();
    private PatternBasedFileFilter mFileFilter;

    protected DataSet(String configName, boolean validateEnabled, String aaptEnv) {
        this.mConfigName = configName;
        this.mValidateEnabled = validateEnabled;
        this.mFileFilter = new PatternBasedFileFilter(new AndroidAaptIgnore(aaptEnv));
    }

    protected abstract DataSet<I, F> createSet(String var1, String var2);

    protected abstract F createFileAndItemsFromXml(File var1, Node var2) throws MergingException;

    protected abstract void readSourceFolder(File var1, ILogger var2, DocumentBuilderFactory var3) throws MergingException;

    protected abstract F createFileAndItems(File var1, File var2, ILogger var3, DocumentBuilderFactory var4) throws MergingException;

    public void addSources(Collection<File> files2) {
        this.mSourceFiles.addAll(files2);
    }

    public void addSource(File file2) {
        this.mSourceFiles.add(file2);
    }

    @Override
    public List<File> getSourceFiles() {
        return this.mSourceFiles;
    }

    public String getConfigName() {
        return this.mConfigName;
    }

    @Override
    public File findMatchingSourceFile(File file2) {
        File matchingSourceFile = null;
        for (File sourceFile : this.mSourceFiles) {
            if (sourceFile.equals(file2)) {
                return sourceFile;
            }
            if (!sourceFile.isDirectory()) continue;
            String sourcePath2 = sourceFile.getAbsolutePath() + File.separator;
            if (!file2.getAbsolutePath().startsWith(sourcePath2) || matchingSourceFile != null && matchingSourceFile.getAbsolutePath().length() >= sourceFile.getAbsolutePath().length()) continue;
            matchingSourceFile = sourceFile;
        }
        return matchingSourceFile;
    }

    @Override
    public int size() {
        return this.mItems.keySet().size();
    }

    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    public ListMultimap<String, I> getDataMap() {
        return this.mItems;
    }

    public void loadFromFiles(ILogger logger) throws MergingException {
        this.loadFromFiles(logger, DocumentBuilderFactory.newInstance());
    }

    public void loadFromFiles(ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        ArrayList<Message> errors = new ArrayList<Message>();
        for (File file2 : this.mSourceFiles) {
            if (file2.isDirectory()) {
                try {
                    this.readSourceFolder(file2, logger, factory);
                }
                catch (MergingException e2) {
                    errors.addAll(e2.getMessages());
                }
                continue;
            }
            if (!file2.isFile()) continue;
            this.loadFile(file2, file2, logger, factory);
        }
        MergingException.throwIfNonEmpty(errors);
        this.checkItems();
    }

    public F loadFile(File sourceFolder, File dataFile, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        return this.handleNewFile(sourceFolder, dataFile, logger, factory);
    }

    void appendToXml(Node setNode, Document document, MergeConsumer<I> consumer2, boolean includeTimestamps) {
        NodeUtils.addAttribute(document, setNode, null, ATTR_CONFIG, this.mConfigName);
        NodeUtils.addAttribute(document, setNode, null, ATTR_IGNORE_PATTERN, this.mFileFilter.getAaptStyleIgnoredPattern());
        for (File sourceFile : this.mSourceFiles) {
            Element sourceNode = document.createElement(NODE_SOURCE);
            setNode.appendChild(sourceNode);
            NodeUtils.addAttribute(document, sourceNode, null, ATTR_PATH, sourceFile.getAbsolutePath());
            Collection dataFiles = this.mSourceFileToDataFilesMap.get((Object)sourceFile);
            block5: for (DataFile dataFile : dataFiles) {
                if (!dataFile.hasNotRemovedItems()) {
                    if (!dataFile.mFile.exists()) continue;
                    this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                    continue;
                }
                Node fileNode = null;
                switch (dataFile.getType()) {
                    case GENERATED_FILES: 
                    case XML_VALUES: {
                        for (DataItem item : dataFile.getItems()) {
                            Node adoptedNode;
                            if (item.isRemoved() || consumer2.ignoreItemInMerge(item)) continue;
                            if (fileNode == null) {
                                fileNode = this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                            }
                            if ((adoptedNode = item.getDetailsXml(document)) == null) continue;
                            fileNode.appendChild(adoptedNode);
                        }
                        continue block5;
                    }
                    case SINGLE_FILE: {
                        Object dataItem = dataFile.getItem();
                        if (consumer2.ignoreItemInMerge((DataItem)dataItem)) continue block5;
                        fileNode = this.createFileElement(document, sourceNode, dataFile, includeTimestamps);
                        NodeUtils.addAttribute(document, fileNode, null, ATTR_NAME, ((DataItem)dataItem).getName());
                        ((DataItem)dataItem).addExtraAttributes(document, fileNode, null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private Node createFileElement(Document document, Node sourceNode, F dataFile, boolean includeTimestamps) {
        long timestamp;
        Element fileNode = document.createElement(NODE_FILE);
        sourceNode.appendChild(fileNode);
        NodeUtils.addAttribute(document, fileNode, null, ATTR_PATH, ((DataFile)dataFile).getFile().getAbsolutePath());
        if (includeTimestamps && (timestamp = ((DataFile)dataFile).getFile().lastModified()) != 0L) {
            NodeUtils.addAttribute(document, fileNode, null, ATTR_TIMESTAMP, Long.toString(timestamp));
        }
        ((DataFile)dataFile).addExtraAttributes(document, fileNode, null);
        return fileNode;
    }

    DataSet<I, F> createFromXml(Node dataSetNode, String aaptEnv) throws MergingException {
        Attr configNameAttr = (Attr)dataSetNode.getAttributes().getNamedItem(ATTR_CONFIG);
        if (configNameAttr == null) {
            return null;
        }
        DataSet<I, F> dataSet = this.createSet(configNameAttr.getValue(), aaptEnv);
        Attr ignoredPatternAttr = (Attr)dataSetNode.getAttributes().getNamedItem(ATTR_IGNORE_PATTERN);
        if (ignoredPatternAttr != null) {
            dataSet.setIgnoredPatterns(ignoredPatternAttr.getValue());
        }
        NodeList sourceNodes = dataSetNode.getChildNodes();
        int n2 = sourceNodes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attr pathAttr;
            Node sourceNode = sourceNodes.item(i2);
            if (sourceNode.getNodeType() != 1 || !NODE_SOURCE.equals(sourceNode.getLocalName()) || (pathAttr = (Attr)sourceNode.getAttributes().getNamedItem(ATTR_PATH)) == null) continue;
            File sourceFolder = new File(pathAttr.getValue());
            dataSet.mSourceFiles.add(sourceFolder);
            NodeList fileNodes = sourceNode.getChildNodes();
            int m4 = fileNodes.getLength();
            for (int j2 = 0; j2 < m4; ++j2) {
                F dataFile;
                Node fileNode = fileNodes.item(j2);
                if (fileNode.getNodeType() != 1 || !NODE_FILE.equals(fileNode.getLocalName()) || (pathAttr = (Attr)fileNode.getAttributes().getNamedItem(ATTR_PATH)) == null) continue;
                File actualFile = new File(pathAttr.getValue());
                Attr timestampAttr = (Attr)fileNode.getAttributes().getNamedItem(ATTR_TIMESTAMP);
                if (timestampAttr != null) {
                    try {
                        long blobDataFileTimestamp = Long.parseLong(timestampAttr.getValue());
                        long actualFileTimestamp = actualFile.lastModified();
                        if (actualFileTimestamp == 0L) continue;
                        if (blobDataFileTimestamp < actualFileTimestamp) {
                        }
                    }
                    catch (NumberFormatException e2) {}
                    continue;
                }
                if ((dataFile = this.createFileAndItemsFromXml(actualFile, fileNode)) == null) continue;
                dataSet.processNewDataFile(sourceFolder, dataFile, false);
            }
        }
        return dataSet;
    }

    protected void checkItems() throws DuplicateDataException {
        if (!this.mValidateEnabled) {
            return;
        }
        ArrayList duplicateCollections = new ArrayList();
        for (Map.Entry<String, Collection<I>> entry : this.mItems.asMap().entrySet()) {
            Collection<I> items = entry.getValue();
            DataItem lastItem = null;
            for (DataItem item : items) {
                if (item.isRemoved()) continue;
                if (lastItem == null) {
                    lastItem = item;
                    continue;
                }
                duplicateCollections.add(items);
            }
        }
        if (!duplicateCollections.isEmpty()) {
            throw new DuplicateDataException(DuplicateDataException.createMessages(duplicateCollections));
        }
    }

    public boolean updateWith(File sourceFolder, File changedFile, FileStatus fileStatus, ILogger logger) throws MergingException {
        switch (fileStatus) {
            case NEW: {
                this.handleNewFile(sourceFolder, changedFile, logger, DocumentBuilderFactory.newInstance());
                return true;
            }
            case CHANGED: {
                return this.handleChangedFile(sourceFolder, changedFile, logger, DocumentBuilderFactory.newInstance());
            }
            case REMOVED: {
                return this.handleRemovedFile(changedFile);
            }
        }
        return false;
    }

    protected boolean handleRemovedFile(File removedFile) {
        F dataFile = this.getDataFile(removedFile);
        if (dataFile == null) {
            return false;
        }
        for (DataItem dataItem : ((DataFile)dataFile).getItems()) {
            dataItem.setRemoved();
        }
        return true;
    }

    protected boolean isValidSourceFile(File sourceFolder, File file2) {
        return this.checkFileForAndroidRes(file2);
    }

    protected F handleNewFile(File sourceFolder, File file2, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        F dataFile = this.createFileAndItems(sourceFolder, file2, logger, factory);
        if (dataFile != null) {
            this.processNewDataFile(sourceFolder, dataFile, true);
        }
        return dataFile;
    }

    protected void processNewDataFile(File sourceFolder, F dataFile, boolean setTouched) throws MergingException {
        Collection dataItems = ((DataFile)dataFile).getItems();
        this.addDataFile(sourceFolder, dataFile);
        for (DataItem dataItem : dataItems) {
            this.mItems.put(dataItem.getKey(), dataItem);
            if (!setTouched) continue;
            dataItem.setTouched();
        }
    }

    protected boolean handleChangedFile(File sourceFolder, File changedFile, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        DataFile dataFile = (DataFile)this.mDataFileMap.get(changedFile);
        for (DataItem item : dataFile.getItems()) {
            item.setTouched();
        }
        return true;
    }

    protected void addItem(I item, String key) throws MergingException {
        if (key == null) {
            key = ((DataItem)item).getKey();
        }
        this.mItems.put(key, item);
    }

    protected F getDataFile(File file2) {
        return (F)((DataFile)this.mDataFileMap.get(file2));
    }

    @VisibleForTesting
    void addDataFile(File sourceFile, F dataFile) {
        this.mSourceFileToDataFilesMap.put(sourceFile, dataFile);
        this.mDataFileMap.put(((DataFile)dataFile).getFile(), dataFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).addValue(this.mConfigName).add("sources", Arrays.toString(this.mSourceFiles.toArray())).toString();
    }

    protected boolean checkFileForAndroidRes(File file2) {
        return !this.mFileFilter.isIgnored(file2);
    }

    @Deprecated
    public void setIgnoredPatterns(String aaptStylePattern) {
        this.mFileFilter = new PatternBasedFileFilter(aaptStylePattern);
    }

    public void setIgnoredPatterns(List<String> ignoredPatterns) {
        this.mFileFilter = new PatternBasedFileFilter(ignoredPatterns);
    }

    public void setAllowedFolderPrefix(String allowedFolderPrefix) {
        this.allowedFolderPrefix = allowedFolderPrefix;
    }

    public boolean isIgnored(File file2) {
        return this.mFileFilter.isIgnored(file2) || file2.isDirectory() && !file2.getName().startsWith(this.allowedFolderPrefix);
    }

    protected boolean getValidateEnabled() {
        return this.mValidateEnabled;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)o2;
        return this.mValidateEnabled == dataSet.mValidateEnabled && Objects.equals(this.mConfigName, dataSet.mConfigName) && Objects.equals(this.mSourceFiles, dataSet.mSourceFiles) && Objects.equals(this.mItems, dataSet.mItems) && Objects.equals(this.mSourceFileToDataFilesMap, dataSet.mSourceFileToDataFilesMap) && Objects.equals(this.mDataFileMap, dataSet.mDataFileMap) && Objects.equals(this.mFileFilter, dataSet.mFileFilter);
    }

    public int hashCode() {
        return HashCodes.mix(this.mConfigName.hashCode(), Boolean.hashCode(this.mValidateEnabled), this.mSourceFiles.hashCode(), this.mItems.hashCode(), this.mSourceFileToDataFilesMap.hashCode(), this.mDataFileMap.hashCode(), this.mFileFilter.hashCode());
    }
}

