/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.MergingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class DuplicateDataException
extends MergingException {
    private static final String DUPLICATE_RESOURCES = "Duplicate resources";

    DuplicateDataException(Message[] messages) {
        super(null, messages);
    }

    static <I extends DataItem> Message[] createMessages(Collection<Collection<I>> duplicateDataItemSets) {
        ArrayList<Message> messages = Lists.newArrayListWithCapacity(duplicateDataItemSets.size());
        for (Collection<I> duplicateItems : duplicateDataItemSets) {
            ImmutableList.Builder positions = ImmutableList.builder();
            for (DataItem item : duplicateItems) {
                if (item.isRemoved()) continue;
                positions.add(DuplicateDataException.getPosition(item));
            }
            messages.add(new Message(Message.Kind.ERROR, DUPLICATE_RESOURCES, DUPLICATE_RESOURCES, "Resource and asset merger", (ImmutableList<SourceFilePosition>)positions.build()));
        }
        return Iterables.toArray(messages, Message.class);
    }

    private static SourceFilePosition getPosition(DataItem item) {
        Object dataFile = item.getSourceFile();
        if (dataFile == null) {
            return new SourceFilePosition(new SourceFile(item.getKey()), SourcePosition.UNKNOWN);
        }
        File f2 = ((DataFile)dataFile).getFile();
        SourcePosition sourcePosition = SourcePosition.UNKNOWN;
        return new SourceFilePosition(new SourceFile(f2, item.getKey()), sourcePosition);
    }
}

