/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.MergingException;
import com.android.resources.ResourceFolderType;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.List;
import java.util.function.IntPredicate;
import javax.lang.model.SourceVersion;

public final class FileResourceNameValidator {
    private FileResourceNameValidator() {
    }

    public static void validate(File file2, ResourceFolderType resourceType) throws MergingException {
        String error = FileResourceNameValidator.getErrorTextForFileResource(file2.getName(), resourceType);
        if (error != null) {
            throw MergingException.withMessage(error, new Object[0]).withFile(file2).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getErrorTextForFileResource(String fileNameWithExt, ResourceFolderType resourceFolderType) {
        String fileName;
        if (fileNameWithExt.trim().isEmpty()) {
            return "Resource must have a name";
        }
        if (resourceFolderType == ResourceFolderType.RAW) {
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.DRAWABLE || resourceFolderType == ResourceFolderType.MIPMAP) {
            if (SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".xml")) {
                fileName = fileNameWithExt.substring(0, fileNameWithExt.length() - ".xml".length());
                return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
            } else {
                if (!SdkUtils.hasImageExtension(fileNameWithExt)) return "The file name must end with .xml or .png";
                fileName = SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".9.png") ? fileNameWithExt.substring(0, fileNameWithExt.length() - ".9.png".length()) : fileNameWithExt.substring(0, fileNameWithExt.lastIndexOf(46));
            }
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.XML) {
            if (!SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".xml") && !SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".xsd")) return "The file name must end with .xml";
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.FONT) {
            if (!SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".xml") && !SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".ttf") && !SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".otf") && !SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".ttc")) return "The file name must end with .xml, .ttf, .ttc or .otf";
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else {
            if (!SdkUtils.endsWithIgnoreCase(fileNameWithExt, ".xml")) return "The file name must end with .xml";
            fileName = fileNameWithExt.substring(0, fileNameWithExt.length() - ".xml".length());
        }
        return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
    }

    public static String getErrorTextForNameWithoutExtension(String fileNameWithoutExt, ResourceFolderType resourceFolderType) {
        if (resourceFolderType == ResourceFolderType.VALUES) {
            return null;
        }
        if (fileNameWithoutExt.isEmpty() || !Character.isJavaIdentifierStart(fileNameWithoutExt.codePointAt(0))) {
            return "The resource name must start with a letter";
        }
        for (int c2 : fileNameWithoutExt.codePoints().toArray()) {
            if (FileResourceNameValidator.isValidCharacter(c2)) continue;
            return String.format("'%1$c' is not a valid file-based resource name character: File-based resource names must contain only lowercase a-z, 0-9, or underscore", c2);
        }
        if (SourceVersion.isKeyword(fileNameWithoutExt)) {
            return String.format("%1$s is not a valid resource name (reserved Java keyword)", fileNameWithoutExt);
        }
        return null;
    }

    private static boolean isValidCharacter(int c2) {
        return c2 >= 97 && c2 <= 122 || c2 >= 48 && c2 <= 57 || c2 == 95;
    }

    public static String getValidResourceFileName(String fileNameWithoutExtension) {
        if (fileNameWithoutExtension.isEmpty()) {
            return "resource";
        }
        if (SourceVersion.isKeyword(fileNameWithoutExtension)) {
            return "resource_" + fileNameWithoutExtension;
        }
        StringBuilder result2 = new StringBuilder();
        int first2 = fileNameWithoutExtension.codePointAt(0);
        FileResourceNameValidator.checkAndAppend(first2, result2, c2 -> Character.isJavaIdentifierStart(c2) && FileResourceNameValidator.isValidCharacter(c2));
        fileNameWithoutExtension.codePoints().skip(1L).forEach(c2 -> FileResourceNameValidator.checkAndAppend(c2, result2, FileResourceNameValidator::isValidCharacter));
        return result2.toString();
    }

    private static void checkAndAppend(int codePoint, StringBuilder result2, IntPredicate predicate) {
        if (predicate.test(codePoint)) {
            result2.appendCodePoint(codePoint);
        } else {
            int lowerCase = Character.toLowerCase(codePoint);
            if (predicate.test(lowerCase)) {
                result2.appendCodePoint(lowerCase);
            } else {
                result2.append('_');
            }
        }
    }

    private static String removeSingleExtension(String fileNameWithExt) {
        int lastDot = fileNameWithExt.lastIndexOf(46);
        if (lastDot != -1) {
            return fileNameWithExt.substring(0, lastDot);
        }
        return fileNameWithExt;
    }

    private static boolean oneOfStartsWithIgnoreCase(List<String> strings2, String prefix) {
        boolean matches2 = false;
        for (String allowedString : strings2) {
            if (!SdkUtils.startsWithIgnoreCase(allowedString, prefix)) continue;
            matches2 = true;
            break;
        }
        return matches2;
    }
}

