/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
class IdGeneratingResourceParser {
    private final ResourceMergerItem mFileResourceMergerItem;
    private final Set<ResourceMergerItem> mIdResourceMergerItems;
    private final ResourceNamespace mNamespace;
    private final String mLibraryName;

    IdGeneratingResourceParser(File file2, String sourceName, ResourceType sourceType, ResourceNamespace namespace, String libraryName) throws MergingException {
        this.mLibraryName = libraryName;
        Document mDocument = IdGeneratingResourceParser.readDocument(file2);
        if (IdGeneratingResourceParser.hasDataBindings(mDocument)) {
            throw MergingException.withMessage("Does not handle data-binding files", new Object[0]).build();
        }
        this.mNamespace = namespace;
        this.mFileResourceMergerItem = new IdResourceMergerItem(sourceName, this.mNamespace, sourceType, libraryName);
        this.mIdResourceMergerItems = new LinkedHashSet<ResourceMergerItem>();
        LinkedHashSet<String> pendingResourceIds = new LinkedHashSet<String>();
        NodeList nodes = mDocument.getChildNodes();
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node child = nodes.item(i2);
            this.parseIds(this.mIdResourceMergerItems, child, pendingResourceIds);
        }
        for (String id2 : pendingResourceIds) {
            IdResourceMergerItem resourceItem = new IdResourceMergerItem(id2, this.mNamespace, ResourceType.ID, libraryName);
            this.mIdResourceMergerItems.add(resourceItem);
        }
    }

    private static Document readDocument(File file2) throws MergingException {
        try {
            return XmlUtils.parseUtfXmlFile(file2, true);
        }
        catch (IOException | SAXException e2) {
            throw MergingException.wrapException(e2).withFile(file2).build();
        }
    }

    private static boolean hasDataBindings(Document document) {
        Element rootNode = document.getDocumentElement();
        return rootNode != null && "layout".equals(rootNode.getNodeName());
    }

    public ResourceMergerItem getFileResourceMergerItem() {
        return this.mFileResourceMergerItem;
    }

    public Collection<ResourceMergerItem> getIdResourceMergerItems() {
        return this.mIdResourceMergerItems;
    }

    private void parseIds(Set<ResourceMergerItem> items, Node node, Set<String> pendingResourceIds) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String id2;
                Node attribute = attributes.item(i2);
                String value = attribute.getNodeValue();
                if (value == null) continue;
                if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) && "id".equals(attribute.getLocalName())) {
                    if (value.startsWith("@id/")) {
                        id2 = value.substring("@id/".length());
                        if (!pendingResourceIds.contains(id2)) {
                            continue;
                        }
                    } else {
                        if (!value.startsWith("@+id/")) continue;
                        id2 = value.substring("@+id/".length());
                    }
                    pendingResourceIds.remove(id2);
                    if (id2.isEmpty()) continue;
                    IdResourceMergerItem item = new IdResourceMergerItem(id2, this.mNamespace, ResourceType.ID, this.mLibraryName);
                    items.add(item);
                    continue;
                }
                if (!value.startsWith("@+id/") || (id2 = value.substring("@+id/".length())).isEmpty()) continue;
                pendingResourceIds.add(id2);
            }
        }
        NodeList children2 = node.getChildNodes();
        for (int i3 = 0; i3 < children2.getLength(); ++i3) {
            Node child = children2.item(i3);
            this.parseIds(items, child, pendingResourceIds);
        }
    }

    public static class IdResourceMergerItem
    extends ResourceMergerItem {
        public IdResourceMergerItem(String name2, ResourceNamespace namespace, ResourceType type, String libraryName) {
            super(name2, namespace, type, null, null, libraryName);
        }

        @Override
        Node getDetailsXml(Document document) {
            Element newNode = document.createElement("item");
            NodeUtils.addAttribute(document, newNode, null, "name", this.getName());
            NodeUtils.addAttribute(document, newNode, null, "type", this.getType().getName());
            if (this.isFileBased()) {
                ResourceFile sourceFile = (ResourceFile)this.getSourceFile();
                assert (sourceFile != null);
                newNode.setTextContent(sourceFile.getFile().getAbsolutePath());
            }
            return newNode;
        }

        @Override
        public boolean isFileBased() {
            return this.getType() != ResourceType.ID;
        }
    }
}

