/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStringUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u001a4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00130\u0012\u001a.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\""}, d2={"RESOURCE_PROTOCOLS", "", "", "[Ljava/lang/String;", "colorToString", "color", "Ljava/awt/Color;", "colorToStringWithAlpha", "extend", "", "nibble", "fileNameToResourceName", "fileName", "findUnusedResources", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resources", "rootsConsumer", "Lkotlin/Function1;", "", "Ljava/util/function/Consumer;", "isInvalidResourceFieldNameCharacter", "", "c", "", "parseColor", "s", "resourceNameToFieldName", "resourceName", "stripPrefixFromId", "id", "toFileResourcePathString", "Lcom/android/ide/common/util/PathString;", "resourcePath", "sdk-common"})
@JvmName(name="ResourcesUtil")
@SourceDebugExtension(value={"SMAP\nResourcesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesUtil.kt\ncom/android/ide/common/resources/ResourcesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n766#2:248\n857#2,2:249\n1855#2,2:251\n1855#2,2:253\n*S KotlinDebug\n*F\n+ 1 ResourcesUtil.kt\ncom/android/ide/common/resources/ResourcesUtil\n*L\n132#1:248\n132#1:249,2\n134#1:251,2\n129#1:253,2\n*E\n"})
public final class ResourcesUtil {
    @NotNull
    private static final String[] RESOURCE_PROTOCOLS;

    @NotNull
    public static final String resourceNameToFieldName(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        int n2 = resourceName.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = resourceName.charAt(i2);
            if (!ResourcesUtil.isInvalidResourceFieldNameCharacter(c2)) continue;
            char[] buffer = new char[resourceName.length()];
            String string2 = resourceName;
            int n3 = 0;
            int n4 = 0;
            string2.getChars(n4, i2, buffer, n3);
            buffer[i2] = 95;
            for (int j2 = i2 + 1; j2 < n2; ++j2) {
                c2 = resourceName.charAt(j2);
                buffer[j2] = ResourcesUtil.isInvalidResourceFieldNameCharacter(c2) ? 95 : (int)c2;
            }
            return new String(buffer);
        }
        return resourceName;
    }

    public static final boolean isInvalidResourceFieldNameCharacter(char c2) {
        return c2 == ':' || c2 == '.' || c2 == '-';
    }

    @NotNull
    public static final String fileNameToResourceName(@NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        int lastExtension = StringsKt.lastIndexOf$default((CharSequence)fileName, '.', 0, false, 6, null);
        if (lastExtension <= 0) {
            string2 = fileName;
        } else if (StringsKt.endsWith(fileName, ".9.png", true)) {
            if (fileName.length() > 6) {
                String string3 = fileName.substring(0, fileName.length() - 6);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            } else {
                string2 = fileName;
            }
        } else {
            String string4 = fileName.substring(0, lastExtension);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        }
        return string2;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Consumer<List<ResourceUsageModel.Resource>> rootsConsumer) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, "rootsConsumer");
        return ResourcesUtil.findUnusedResources(resources, (Function1<? super List<? extends ResourceUsageModel.Resource>, Unit>)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(rootsConsumer){
            final /* synthetic */ Consumer<List<ResourceUsageModel.Resource>> $rootsConsumer;
            {
                this.$rootsConsumer = $rootsConsumer;
                super(1);
            }

            public final void invoke(@NotNull List<? extends ResourceUsageModel.Resource> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$rootsConsumer.accept(it);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceUsageModel.Resource> findUnusedResources(@NotNull List<? extends ResourceUsageModel.Resource> resources, @NotNull Function1<? super List<? extends ResourceUsageModel.Resource>, Unit> rootsConsumer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(rootsConsumer, "rootsConsumer");
        Set<ResourceUsageModel.Resource> seen = Collections.newSetFromMap(new IdentityHashMap());
        Iterable $this$filter$iv = resources;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl2 = false;
            if (!(it.isReachable() || it.isKeep() || it.isPublic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        rootsConsumer.invoke(roots);
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
            boolean bl3 = false;
            ResourcesUtil.findUnusedResources$visit(seen, it, null);
        }
        return SequencesKt.toList(SequencesKt.filterNot(SequencesKt.filter(SequencesKt.filter(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)resources), findUnusedResources.3.INSTANCE), findUnusedResources.4.INSTANCE), findUnusedResources.5.INSTANCE), findUnusedResources.6.INSTANCE));
    }

    @Nullable
    public static final PathString toFileResourcePathString(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter(resourcePath, "resourcePath");
        for (String protocol : RESOURCE_PROTOCOLS) {
            if (!StringsKt.startsWith$default(resourcePath, protocol, false, 2, null) || resourcePath.length() <= protocol.length() || resourcePath.charAt(protocol.length()) != ':') continue;
            int prefixLength = protocol.length() + 1;
            if (StringsKt.startsWith$default(resourcePath, "//", prefixLength, false, 4, null)) {
                prefixLength += 2;
            }
            String string2 = resourcePath.substring(prefixLength);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return new PathString(protocol, string2);
        }
        File file2 = new File(resourcePath);
        return file2.isFile() ? PathStringUtil.toPathString(file2) : null;
    }

    @Deprecated(message="Use `ResourceUrl.parse` instead and handle wrong resource type, invalid name, trailing whitespace etc.", replaceWith=@ReplaceWith(expression="ResourceUrl.parse(id)?.name ?: id", imports={"com.android.resources.ResourceUrl"}))
    @NotNull
    public static final String stripPrefixFromId(@NotNull String id2) {
        String string2;
        Intrinsics.checkNotNullParameter(id2, "id");
        if (StringsKt.startsWith$default(id2, "@+id/", false, 2, null)) {
            String string3 = id2.substring(5);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        } else if (StringsKt.startsWith$default(id2, "@id/", false, 2, null)) {
            String string4 = id2.substring(4);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
        } else {
            string2 = id2;
        }
        return string2;
    }

    @NotNull
    public static final String colorToString(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            String string2 = "#%08X";
            Object[] objectArray = new Object[]{longColor |= (long)color.getAlpha() << 24};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            return string3;
        }
        String string4 = "#%06X";
        Object[] objectArray = new Object[]{longColor};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
        return string5;
    }

    @NotNull
    public static final String colorToStringWithAlpha(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        String string2 = "0x%08X";
        Object[] objectArray = new Object[]{(long)(color.getRed() << 16 | color.getGreen() << 8 | color.getBlue()) | (long)color.getAlpha() << 24};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    @Nullable
    public static final Color parseColor(@Nullable String s2) {
        String string2 = s2;
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return null;
        }
        String trimmed = string2;
        if (((CharSequence)trimmed).length() == 0) {
            return null;
        }
        if (trimmed.charAt(0) == '#') {
            String string3 = trimmed.substring(1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            Long l2 = StringsKt.toLongOrNull(string3, 16);
            if (l2 == null) {
                return null;
            }
            long longColor = l2;
            if (trimmed.length() == 4 || trimmed.length() == 5) {
                long a2 = trimmed.length() == 4 ? 255L : ResourcesUtil.extend((longColor & 0xF000L) >> 12);
                long r2 = ResourcesUtil.extend((longColor & 0xF00L) >> 8);
                long g2 = ResourcesUtil.extend((longColor & 0xF0L) >> 4);
                long b2 = ResourcesUtil.extend(longColor & 0xFL);
                longColor = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                return new Color((int)longColor, true);
            }
            if (trimmed.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (trimmed.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    private static final long extend(long nibble) {
        return nibble | nibble << 4;
    }

    private static final void findUnusedResources$visit(Set<ResourceUsageModel.Resource> seen, ResourceUsageModel.Resource resource, ResourceUsageModel.Resource parent) {
        block3: {
            if (parent != null && parent.reachableParents != null) {
                resource.addReachableParent(new ResourceUsageModel.ResourceReachableOrigin(parent));
            }
            if (seen.contains(resource)) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue(seen, "seen");
            ((Collection)seen).add(resource);
            resource.setReachable(true);
            List<ResourceUsageModel.Resource> list2 = resource.references;
            if (list2 == null) break block3;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceUsageModel.Resource it = (ResourceUsageModel.Resource)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                ResourcesUtil.findUnusedResources$visit(seen, it, resource);
            }
        }
    }

    static {
        String[] stringArray = new String[]{"apk", "jar", "file"};
        RESOURCE_PROTOCOLS = stringArray;
    }
}

