/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.MergingException;
import com.android.resources.ResourceType;
import java.io.File;
import javax.lang.model.SourceVersion;

public final class ValueResourceNameValidator {
    private ValueResourceNameValidator() {
    }

    public static void validate(String resourceName, ResourceType resourceType, File file2) throws MergingException {
        String error = ValueResourceNameValidator.getErrorText(resourceName, resourceType);
        if (error != null) {
            MergingException.Builder exception = MergingException.withMessage(error, new Object[0]);
            if (file2 != null) {
                exception.withFile(file2);
            }
            throw exception.build();
        }
    }

    public static String getErrorText(String fullResourceName, ResourceType resourceType) {
        if (resourceType == ResourceType.ATTR && fullResourceName.startsWith("android:")) {
            fullResourceName = fullResourceName.substring(8);
        }
        if (resourceType == ResourceType.OVERLAYABLE) {
            return null;
        }
        String resourceName = ValueResourceNameValidator.normalizeName(fullResourceName);
        if (!SourceVersion.isIdentifier(resourceName)) {
            if (resourceName.isEmpty()) {
                return "The resource name shouldn't be empty";
            }
            if (!Character.isJavaIdentifierStart(resourceName.charAt(0))) {
                return "The resource name must start with a letter";
            }
            int n2 = resourceName.length();
            for (int i2 = 1; i2 < n2; ++i2) {
                char c2 = resourceName.charAt(i2);
                if (Character.isJavaIdentifierPart(c2)) continue;
                return String.format("'%1$c' is not a valid resource name character", Character.valueOf(c2));
            }
        }
        if (SourceVersion.isKeyword(resourceName)) {
            return String.format("%1$s is not a valid resource name (reserved Java keyword)", resourceName);
        }
        return null;
    }

    public static String normalizeName(String fullResourceName) {
        return fullResourceName.replace('.', '_');
    }
}

