/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SmallestScreenWidthQualifier
extends ResourceQualifier {
    static final int DEFAULT_SIZE = -1;
    private static final Pattern sParsePattern = Pattern.compile("^sw(\\d+)dp$");
    private static final String sPrintPattern = "sw%1$ddp";
    public static final String NAME = "Smallest Screen Width";
    private int mValue = -1;

    public SmallestScreenWidthQualifier() {
    }

    public SmallestScreenWidthQualifier(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 13;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.mValue != -1;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        String v2;
        SmallestScreenWidthQualifier qualifier;
        Matcher m4 = sParsePattern.matcher(value);
        if (m4.matches() && (qualifier = SmallestScreenWidthQualifier.getQualifier(v2 = m4.group(1))) != null) {
            config.setSmallestScreenWidthQualifier(qualifier);
            return true;
        }
        return false;
    }

    public static SmallestScreenWidthQualifier getQualifier(String value) {
        try {
            int dp = Integer.parseInt(value);
            SmallestScreenWidthQualifier qualifier = new SmallestScreenWidthQualifier();
            qualifier.mValue = dp;
            return qualifier;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof SmallestScreenWidthQualifier) {
            return this.mValue <= ((SmallestScreenWidthQualifier)qualifier).mValue;
        }
        return false;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        SmallestScreenWidthQualifier compareQ = (SmallestScreenWidthQualifier)compareTo2;
        SmallestScreenWidthQualifier referenceQ = (SmallestScreenWidthQualifier)reference;
        if (compareQ.mValue == referenceQ.mValue) {
            return false;
        }
        if (this.mValue == referenceQ.mValue) {
            return true;
        }
        return this.mValue > compareQ.mValue;
    }

    @Override
    public String getFolderSegment() {
        return String.format(sPrintPattern, this.mValue);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.isValid()) {
            return this.getFolderSegment();
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.isValid()) {
            return this.getFolderSegment();
        }
        return "";
    }

    @Override
    public int hashCode() {
        return this.mValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmallestScreenWidthQualifier other = (SmallestScreenWidthQualifier)obj;
        return this.mValue == other.mValue;
    }
}

