/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.EnumBasedResourceQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceEnum;
import com.android.resources.UiMode;

public final class UiModeQualifier
extends EnumBasedResourceQualifier {
    public static final String NAME = "UI Mode";
    private UiMode mValue;

    public UiModeQualifier() {
    }

    public UiModeQualifier(UiMode value) {
        this.mValue = value;
    }

    public UiMode getValue() {
        return this.mValue;
    }

    @Override
    public ResourceEnum getEnumValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        if (this.mValue != null) {
            return this.mValue.since();
        }
        return 8;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        UiMode mode = UiMode.getEnum(value);
        if (mode != null) {
            UiModeQualifier qualifier = new UiModeQualifier(mode);
            config.setUiModeQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (this.mValue == UiMode.NORMAL) {
            return true;
        }
        return ((UiModeQualifier)qualifier).mValue == this.mValue;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        UiModeQualifier compareQualifier = (UiModeQualifier)compareTo2;
        UiModeQualifier referenceQualifier = (UiModeQualifier)reference;
        if (compareQualifier.getValue() == referenceQualifier.getValue()) {
            return false;
        }
        if (this.mValue == referenceQualifier.mValue) {
            return true;
        }
        return this.mValue == UiMode.NORMAL;
    }
}

