/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.escape.string;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007J\f\u0010\u000b\u001a\u00020\u0006*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/android/ide/common/resources/escape/string/StringResourceEscaper;", "", "()V", "buildEscaper", "Lcom/google/common/escape/Escaper;", "escapeApostrophes", "", "escapeMarkupDelimiters", "escape", "", "string", "startsOrEndsWithSpace", "sdk-common"})
public final class StringResourceEscaper {
    @NotNull
    public static final StringResourceEscaper INSTANCE = new StringResourceEscaper();

    private StringResourceEscaper() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String escape(@NotNull String string2, boolean escapeMarkupDelimiters) {
        Intrinsics.checkNotNullParameter(string2, "string");
        if (((CharSequence)string2).length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(string2.length() * 3 / 2);
        if (StringsKt.startsWith$default(string2, "?", false, 2, null) || StringsKt.startsWith$default(string2, "@", false, 2, null)) {
            builder.append("\\");
        }
        Escaper escaper = INSTANCE.buildEscaper(!INSTANCE.startsOrEndsWithSpace(string2), escapeMarkupDelimiters);
        builder.append(escaper.escape(string2));
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "builder.toString()");
        String s2 = string3;
        return INSTANCE.startsOrEndsWithSpace(s2) ? "\"" + s2 + "\"" : s2;
    }

    public static /* synthetic */ String escape$default(String string2, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        return StringResourceEscaper.escape(string2, bl2);
    }

    private final Escaper buildEscaper(boolean escapeApostrophes, boolean escapeMarkupDelimiters) {
        Escapers.Builder builder = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").addEscape('\t', "\\t");
        if (escapeApostrophes) {
            builder.addEscape('\'', "\\'");
        }
        if (escapeMarkupDelimiters) {
            builder.addEscape('&', "&amp;").addEscape('<', "&lt;");
        }
        Escaper escaper = builder.build();
        Intrinsics.checkNotNullExpressionValue(escaper, "builder.build()");
        return escaper;
    }

    private final boolean startsOrEndsWithSpace(String $this$startsOrEndsWithSpace) {
        return StringsKt.startsWith$default($this$startsOrEndsWithSpace, " ", false, 2, null) || StringsKt.endsWith$default($this$startsOrEndsWithSpace, " ", false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String escape(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "string");
        return StringResourceEscaper.escape$default(string2, false, 2, null);
    }
}

