/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.escape.xml;

import java.util.function.Consumer;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;

final class StringResourceContentHandler
extends DefaultHandler2 {
    static final String STRING_ELEMENT_NAME = "string";
    private final StringBuilder mBuilder;
    private final Consumer<String> mCharacterHandler;
    private boolean mHandlingEntity;
    private boolean mHandlingCdata;
    private int mStartElementBuilderLength;

    StringResourceContentHandler(StringBuilder builder, Consumer<String> characterHandler) {
        this.mBuilder = builder;
        this.mCharacterHandler = characterHandler;
    }

    @Override
    public void characters(char[] chars, int offset, int length) {
        if (this.mHandlingEntity) {
            this.mHandlingEntity = false;
            return;
        }
        if (this.mHandlingCdata) {
            this.mBuilder.append(chars, offset, length);
        } else {
            this.mCharacterHandler.accept(new String(chars, offset, length));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) {
        if (qualifiedName.equals(STRING_ELEMENT_NAME)) {
            return;
        }
        this.mBuilder.append('<').append(qualifiedName);
        int length = attributes.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            this.mBuilder.append(' ').append(attributes.getQName(i2)).append("=\"").append(attributes.getValue(i2)).append('\"');
        }
        this.mBuilder.append('>');
        this.mStartElementBuilderLength = this.mBuilder.length();
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) {
        if (qualifiedName.equals(STRING_ELEMENT_NAME)) {
            return;
        }
        if (this.mBuilder.length() == this.mStartElementBuilderLength) {
            this.mBuilder.setCharAt(this.mBuilder.length() - 1, '/');
            this.mBuilder.append('>');
        } else {
            this.mBuilder.append("</").append(qualifiedName).append('>');
        }
    }

    @Override
    public void startEntity(String name2) {
        this.mBuilder.append('&').append(name2).append(';');
        this.mHandlingEntity = true;
    }

    @Override
    public void startCDATA() {
        this.mBuilder.append("<![CDATA[");
        this.mHandlingCdata = true;
    }

    @Override
    public void endCDATA() {
        this.mBuilder.append("]]>");
        this.mHandlingCdata = false;
    }

    @Override
    public void comment(char[] chars, int offset, int length) {
        this.mBuilder.append("<!--").append(chars, offset, length).append("-->");
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.mBuilder.append("<?").append(target).append(' ').append(data).append("?>");
    }
}

