/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.usage.ResourceUsageKt;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.utils.XmlUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\t\u001a\u00020\u0004\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"getDeclaredAndReferencedResourcesFrom", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resourceFile", "Ljava/io/File;", "resourceUsageModel", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "getResourcesFromDirectory", "", "directory", "getResourcesFromExplodedAarToFile", "explodedAar", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nResourceUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUsage.kt\ncom/android/ide/common/resources/usage/ResourceUsageKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n1549#2:56\n1620#2,3:57\n*S KotlinDebug\n*F\n+ 1 ResourceUsage.kt\ncom/android/ide/common/resources/usage/ResourceUsageKt\n*L\n28#1:54,2\n32#1:56\n32#1:57,3\n*E\n"})
public final class ResourceUsageKt {
    @NotNull
    public static final List<String> getResourcesFromExplodedAarToFile(@NotNull File explodedAar) {
        Intrinsics.checkNotNullParameter(explodedAar, "explodedAar");
        File resourceDir = FilesKt.resolve(explodedAar, "res");
        return ResourceUsageKt.getResourcesFromDirectory(resourceDir);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getResourcesFromDirectory(@NotNull File directory) {
        void $this$mapTo$iv$iv;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(directory, "directory");
                if (directory.list() == null) break block4;
                File[] fileArray = directory.listFiles();
                Intrinsics.checkNotNull(fileArray);
                if (!ArraysKt.none(fileArray)) break block5;
            }
            return CollectionsKt.emptyList();
        }
        ResourceUsageModel resourceUsageModel = new ResourceUsageModel();
        Iterable $this$forEach$iv = SequencesKt.toSet(SequencesKt.filter(FilesKt.walk$default(directory, null, 1, null), getResourcesFromDirectory.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            ResourceUsageKt.getDeclaredAndReferencedResourcesFrom(it, resourceUsageModel);
        }
        List<ResourceUsageModel.Resource> list2 = resourceUsageModel.getResources();
        Intrinsics.checkNotNullExpressionValue(list2, "resourceUsageModel.resources");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.toString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> getDeclaredAndReferencedResourcesFrom(@NotNull File resourceFile, @NotNull ResourceUsageModel resourceUsageModel) {
        Intrinsics.checkNotNullParameter(resourceFile, "resourceFile");
        Intrinsics.checkNotNullParameter(resourceUsageModel, "resourceUsageModel");
        ResourceFolderType resFolderType = ResourceFolderType.getTypeByName(resourceFile.getParentFile().getName());
        String string2 = resourceFile.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "resourceFile.name");
        if (StringsKt.endsWith$default(string2, ".xml", false, 2, null) && resFolderType != ResourceFolderType.RAW) {
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            String resourceString = FilesKt.readText(resourceFile, charset);
            Document document = XmlUtils.parseDocument(resourceString, false);
            resourceUsageModel.visitXmlDocument(resourceFile, resFolderType, document);
        } else {
            resourceUsageModel.visitBinaryResource(resFolderType, resourceFile);
        }
        List<ResourceUsageModel.Resource> list2 = resourceUsageModel.getResources();
        Intrinsics.checkNotNullExpressionValue(list2, "resourceUsageModel.resources");
        return list2;
    }

    public static /* synthetic */ List getDeclaredAndReferencedResourcesFrom$default(File file2, ResourceUsageModel resourceUsageModel, int n2, Object object) {
        if ((n2 & 2) != 0) {
            resourceUsageModel = new ResourceUsageModel();
        }
        return ResourceUsageKt.getDeclaredAndReferencedResourcesFrom(file2, resourceUsageModel);
    }
}

