/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.WebTokenizers;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.support.FragmentTagUtil;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceUsageModel {
    protected ResourceStore mResourceStore;
    private int nextInlinedResourceSuffix;
    private static final String ANDROID_RES = "android_res/";
    private static final int RESOURCE_DECLARED = 2;
    private static final int RESOURCE_PUBLIC = 4;
    private static final int RESOURCE_KEEP = 8;
    private static final int RESOURCE_DISCARD = 16;
    private static final int RESOURCE_REACHABLE = 32;
    private static final String ANALYTICS_FILE = "analytics.xml";
    private static byte[] sAndroidResBytes;

    public ResourceUsageModel() {
        this.mResourceStore = new ResourceStore();
    }

    public ResourceUsageModel(ResourceStore resourceStore) {
        this.mResourceStore = resourceStore;
    }

    public static String getResourceFieldName(Element element) {
        return ResourcesUtil.resourceNameToFieldName(element.getAttribute("name"));
    }

    public Resource getResource(Element element) {
        return this.getResource(element, false);
    }

    public Resource getResource(Element element, boolean declare) {
        ResourceType type = ResourceType.fromXmlTag(element);
        if (type != null) {
            String name2 = ResourceUsageModel.getResourceFieldName(element);
            Resource resource = this.getResource(type, name2);
            if (resource == null && declare) {
                resource = this.addResource(type, name2, null);
                resource.setDeclared(true);
            }
            return resource;
        }
        return null;
    }

    public Resource getResource(Integer value) {
        return this.mResourceStore.getResource(value);
    }

    public Resource getResource(ResourceType type, String name2) {
        return Iterables.getFirst(this.mResourceStore.getResources(type, name2), null);
    }

    public Resource getResourceFromUrl(String possibleUrlReference) {
        ResourceUrl url = ResourceUrl.parse(possibleUrlReference);
        if (url != null && !url.isFramework()) {
            return this.addResource(url.type, ResourcesUtil.resourceNameToFieldName(url.name), null);
        }
        return null;
    }

    public Resource getResourceFromFilePath(String url) {
        List<ResourceType> types;
        String folderName;
        ResourceFolderType folderType;
        int slash;
        int nameSlash = url.lastIndexOf(47);
        if (nameSlash == -1) {
            return null;
        }
        int androidRes = url.indexOf(ANDROID_RES);
        if (androidRes != -1 && (slash = url.indexOf(47, androidRes += ANDROID_RES.length())) != -1 && (folderType = ResourceFolderType.getFolderType(folderName = url.substring(androidRes, slash))) != null && !(types = FolderTypeRelationship.getRelatedResourceTypes(folderType)).isEmpty()) {
            int nameBegin;
            ResourceType type = types.get(0);
            int dot = url.indexOf(46, nameBegin = slash + 1);
            String name2 = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type, name2);
        }
        int typeSlash = url.lastIndexOf(47, nameSlash - 1);
        ResourceType type = ResourceType.fromXmlValue(url.substring(typeSlash + 1, nameSlash));
        if (type != null) {
            int nameBegin;
            int dot = url.indexOf(46, nameBegin = nameSlash + 1);
            String name3 = url.substring(nameBegin, dot != -1 ? dot : url.length());
            return this.getResource(type, name3);
        }
        return null;
    }

    public static boolean markReachable(Resource resource) {
        if (resource != null) {
            boolean wasReachable = resource.isReachable();
            resource.setReachable(true);
            return !wasReachable;
        }
        return false;
    }

    public static boolean markReachable(Resource resource, ReachableOrigin reachableParent) {
        if (resource != null && reachableParent != null) {
            resource.addReachableParent(reachableParent);
        }
        return ResourceUsageModel.markReachable(resource);
    }

    private static void markUnreachable(Resource resource) {
        if (resource != null) {
            resource.setReachable(false);
        }
    }

    public void recordManifestUsages(Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n2 = attributes.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attr attr = (Attr)attributes.item(i2);
                ResourceUsageModel.markReachable(this.getResourceFromUrl(attr.getValue()));
            }
        } else if (nodeType == 3) {
            String text = node.getNodeValue().trim();
            ResourceUsageModel.markReachable(this.getResourceFromUrl(text));
        }
        NodeList children2 = node.getChildNodes();
        int n3 = children2.getLength();
        for (int i3 = 0; i3 < n3; ++i3) {
            Node child = children2.item(i3);
            this.recordManifestUsages(child);
        }
    }

    public List<Resource> findUnused() {
        return this.findUnused(this.mResourceStore.getResources());
    }

    public String dumpKeepResources() {
        return this.mResourceStore.dumpKeepResources();
    }

    public String dumpConfig() {
        return this.mResourceStore.dumpConfig();
    }

    public String dumpReferences() {
        return this.mResourceStore.dumpReferences();
    }

    public String dumpResourceModel() {
        return this.mResourceStore.dumpResourceModel();
    }

    public String serialize(boolean includeValues) {
        return ResourceStore.Companion.serialize(this.mResourceStore, includeValues);
    }

    public static ResourceUsageModel deserialize(String s2) {
        ResourceStore store = ResourceStore.Companion.deserialize(s2);
        return new ResourceUsageModel(store);
    }

    public void merge(ResourceUsageModel other) {
        this.mResourceStore.merge(other.mResourceStore);
    }

    public List<Resource> findUnused(List<Resource> resources) {
        return ResourcesUtil.findUnusedResources(resources, this::onRootResourcesFound);
    }

    protected void onRootResourcesFound(List<Resource> roots) {
    }

    public Resource addDeclaredResource(ResourceType type, String name2, String value, boolean declared) {
        Resource resource = this.addResource(type, name2, value);
        if (declared) {
            resource.setDeclared(true);
        }
        return resource;
    }

    public Resource addResource(ResourceType type, String name2, String value) {
        return this.addResource(type, name2, value != null ? Integer.decode(value) : -1);
    }

    public Resource addResource(ResourceType type, String name2, int realValue) {
        return this.mResourceStore.addResource(this.createResource(type, ResourcesUtil.resourceNameToFieldName(name2), realValue));
    }

    protected Resource createResource(ResourceType type, String name2, int realValue) {
        return new Resource(type, name2, realValue);
    }

    public boolean isSafeMode() {
        return this.mResourceStore.getSafeMode();
    }

    public void processToolsAttributes() {
        this.mResourceStore.processToolsAttributes();
    }

    public void recordToolsAttributes(Attr attr) {
        if (attr == null) {
            return;
        }
        String localName = attr.getLocalName();
        String value = attr.getValue();
        if ("keep".equals(localName)) {
            this.mResourceStore.recordKeepToolAttribute(value);
        } else if ("discard".equals(localName)) {
            this.mResourceStore.recordDiscardToolAttribute(value);
        } else if ("shrinkMode".equals(localName)) {
            this.recordShrinkModeAttribute(value);
        }
    }

    public void recordShrinkModeAttribute(String value) {
        if ("strict".equals(value)) {
            this.mResourceStore.setSafeMode(false);
        } else if ("safe".equals(value)) {
            this.mResourceStore.setSafeMode(true);
        }
    }

    protected Resource declareResource(ResourceType type, String name2, Node node) {
        return this.addDeclaredResource(type, name2, null, true);
    }

    protected String readText(File file2) {
        try {
            return Files.asCharSource(file2, Charsets.UTF_8).read();
        }
        catch (IOException ignore) {
            return "";
        }
    }

    public void visitBinaryResource(ResourceFolderType folderType, File file2) {
        Resource from2 = null;
        if (folderType != null && folderType != ResourceFolderType.VALUES) {
            List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(folderType);
            ResourceType type = types.get(0);
            assert (type != ResourceType.ID) : folderType;
            String fileName = file2.getName();
            if (fileName.startsWith(".") || fileName.endsWith("~") || fileName.equals("Thumbs.db")) {
                return;
            }
            String name2 = SdkUtils.fileNameToResourceName(fileName);
            from2 = this.declareResource(type, name2, null);
        }
        if (folderType == ResourceFolderType.RAW) {
            String path = file2.getPath();
            if (SdkUtils.endsWithIgnoreCase(path, ".html") || SdkUtils.endsWithIgnoreCase(path, ".htm")) {
                this.tokenizeHtml(from2, this.readText(file2));
            } else if (SdkUtils.endsWithIgnoreCase(path, ".css")) {
                this.tokenizeCss(from2, this.readText(file2));
            } else if (SdkUtils.endsWithIgnoreCase(path, ".js")) {
                this.tokenizeJs(from2, this.readText(file2));
            } else if (file2.isFile() && !SdkUtils.isBitmapFile(file2)) {
                this.tokenizeUnknownBinary(from2, file2);
            }
        }
    }

    public void visitXmlDocument(File file2, ResourceFolderType folderType, Document document) {
        if (folderType == null) {
            this.recordManifestUsages(document.getDocumentElement());
            return;
        }
        Resource from2 = null;
        if (folderType != ResourceFolderType.VALUES) {
            List<ResourceType> types = FolderTypeRelationship.getRelatedResourceTypes(folderType);
            ResourceType type = types.get(0);
            assert (type != ResourceType.ID) : folderType;
            String name2 = SdkUtils.fileNameToResourceName(file2.getName());
            from2 = this.declareResource(type, name2, document.getDocumentElement());
        } else if (ResourceUsageModel.isAnalyticsFile(file2)) {
            return;
        }
        this.nextInlinedResourceSuffix = 1;
        this.recordResourceReferences(folderType, document.getDocumentElement(), from2);
        if (folderType == ResourceFolderType.XML) {
            this.tokenizeUnknownText(this.readText(file2));
        }
    }

    public static boolean isAnalyticsFile(File file2) {
        return file2.getPath().endsWith(ANALYTICS_FILE) && file2.getName().equals(ANALYTICS_FILE);
    }

    protected boolean ignoreToolsAttributes() {
        return false;
    }

    public void recordResourceReferences(ResourceFolderType folderType, Node node, Resource from2) {
        block38: {
            String text;
            Resource textResource;
            short nodeType;
            block37: {
                String name2;
                String tagName;
                Resource definition;
                Element element;
                block39: {
                    int index2;
                    Resource ps;
                    block40: {
                        Node child;
                        nodeType = node.getNodeType();
                        if (nodeType != 1) break block37;
                        element = (Element)node;
                        if ("attr".equals(element.getLocalName()) && "http://schemas.android.com/aapt".equals(element.getNamespaceURI()) && from2 != null) {
                            String base = from2.name;
                            for (Node child2 = element.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                                if (child2.getNodeType() != 1) continue;
                                String name3 = base + "_" + Integer.toString(this.nextInlinedResourceSuffix++);
                                Resource inlined2 = this.addResource(from2.type, name3, null);
                                from2.addReference(inlined2);
                            }
                        }
                        if (from2 != null) {
                            NamedNodeMap attributes = element.getAttributes();
                            int n2 = attributes.getLength();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                int resourceEndIndex;
                                int dbExpressionStartIndex;
                                String value;
                                Attr attr = (Attr)attributes.item(i2);
                                if ("http://schemas.android.com/tools".equals(attr.getNamespaceURI())) {
                                    this.recordToolsAttributes(attr);
                                    if (this.ignoreToolsAttributes()) continue;
                                }
                                if (!(value = attr.getValue()).startsWith("@") && !value.startsWith("?")) {
                                    String name4 = attr.getLocalName();
                                    if (!"constraint_referenced_ids".equals(name4)) continue;
                                    Splitter splitter = Splitter.on(',').trimResults().omitEmptyStrings();
                                    for (String id2 : splitter.split(value)) {
                                        ResourceUsageModel.markReachable(this.addResource(ResourceType.ID, id2, null));
                                    }
                                    continue;
                                }
                                ResourceUrl url = ResourceUrl.parse(value);
                                if (url != null && !url.isFramework()) {
                                    if (url.isCreate()) {
                                        boolean isId = "id".equals(attr.getLocalName());
                                        if (isId && "layout".equals(element.getOwnerDocument().getDocumentElement().getTagName())) {
                                            ResourceUsageModel.markReachable(this.addResource(url.type, url.name, null));
                                            continue;
                                        }
                                        if (isId && "action".equals(element.getTagName()) && "navigation".equals(element.getOwnerDocument().getDocumentElement().getTagName())) {
                                            ResourceUsageModel.markReachable(this.addResource(url.type, url.name, null));
                                            continue;
                                        }
                                        Resource resource = this.declareResource(url.type, url.name, attr);
                                        if (!isId || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                                            from2.addReference(resource);
                                            continue;
                                        }
                                        if (!FragmentTagUtil.isFragmentTag(element.getTagName())) continue;
                                        ResourceUsageModel.markReachable(resource);
                                        continue;
                                    }
                                    Resource resource = this.addResource(url.type, url.name, null);
                                    from2.addReference(resource);
                                    continue;
                                }
                                if (!value.startsWith("@{") && !value.startsWith("@={")) continue;
                                int length = value.length();
                                int resourceStartIndex = dbExpressionStartIndex = value.startsWith("@={") ? "@={".length() : "@{".length();
                                while ((resourceStartIndex = value.indexOf(64, resourceStartIndex)) != -1) {
                                    char c2;
                                    for (resourceEndIndex = resourceStartIndex + 1; resourceEndIndex < length && (Character.isJavaIdentifierPart(c2 = value.charAt(resourceEndIndex)) || c2 == '_' || c2 == '.' || c2 == '/' || c2 == '+'); ++resourceEndIndex) {
                                    }
                                    url = ResourceUrl.parse(value.substring(resourceStartIndex, resourceEndIndex));
                                    if (url != null && !url.isFramework()) {
                                        Resource resource = url.isCreate() ? this.declareResource(url.type, url.name, attr) : this.addResource(url.type, url.name, null);
                                        from2.addReference(resource);
                                    }
                                    resourceStartIndex = resourceEndIndex;
                                }
                                resourceStartIndex = dbExpressionStartIndex;
                                while ((resourceStartIndex = value.indexOf("R.", resourceStartIndex)) != -1) {
                                    ResourceType type;
                                    if (Character.isJavaIdentifierPart(value.charAt(resourceStartIndex - 1))) {
                                        resourceStartIndex += 2;
                                        continue;
                                    }
                                    for (resourceEndIndex = resourceStartIndex + 2; resourceEndIndex < length && (Character.isJavaIdentifierPart(value.charAt(resourceEndIndex)) || value.charAt(resourceEndIndex) == '.'); ++resourceEndIndex) {
                                    }
                                    String[] tokens = value.substring(resourceStartIndex + 2, resourceEndIndex).split("\\.");
                                    if (tokens.length == 2 && (type = ResourceType.fromClassName(tokens[0])) != null) {
                                        from2.addReference(this.addResource(type, tokens[1], null));
                                    }
                                    resourceStartIndex = resourceEndIndex;
                                }
                            }
                            if ("rawPathResId".equals(element.getTagName())) {
                                StringBuilder sb = new StringBuilder();
                                NodeList children2 = node.getChildNodes();
                                int n3 = children2.getLength();
                                for (int i3 = 0; i3 < n3; ++i3) {
                                    child = children2.item(i3);
                                    if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                                    sb.append(child.getNodeValue());
                                }
                                if (sb.length() > 0) {
                                    Resource resource = this.getResource(ResourceType.RAW, sb.toString().trim());
                                    from2.addReference(resource);
                                }
                            }
                        } else {
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "keep"));
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "discard"));
                            this.recordToolsAttributes(element.getAttributeNodeNS("http://schemas.android.com/tools", "shrinkMode"));
                        }
                        if (folderType != ResourceFolderType.VALUES) break block38;
                        definition = null;
                        ResourceType type = ResourceType.fromXmlTag(element);
                        if (type != null) {
                            String name5 = ResourceUsageModel.getResourceFieldName(element);
                            if (name5.isEmpty()) {
                                return;
                            }
                            if (type == ResourceType.PUBLIC) {
                                String typeName = element.getAttribute("type");
                                if (!typeName.isEmpty() && (type = ResourceType.fromXmlValue(typeName)) != null) {
                                    definition = this.declareResource(type, name5, element);
                                    definition.setPublic(true);
                                }
                            } else {
                                definition = this.declareResource(type, name5, element);
                            }
                        }
                        if (definition != null) {
                            from2 = definition;
                        }
                        if (type == ResourceType.STRING) {
                            NodeList children3 = node.getChildNodes();
                            int n4 = children3.getLength();
                            for (int i4 = 0; i4 < n4; ++i4) {
                                child = children3.item(i4);
                                if (child.getNodeType() == 1) continue;
                                this.recordResourceReferences(folderType, child, from2);
                            }
                            return;
                        }
                        tagName = element.getTagName();
                        if (!"style".equals(tagName)) break block39;
                        if (!element.hasAttribute("parent")) break block40;
                        String parent = element.getAttribute("parent");
                        if (parent.isEmpty() || parent.startsWith("@android:style/") || parent.startsWith("android:")) break block39;
                        Object parentStyle = parent;
                        if (!((String)parentStyle).startsWith("@style/")) {
                            parentStyle = ((String)parentStyle).startsWith("style/") ? "@" + (String)parentStyle : "@style/" + (String)parentStyle;
                        }
                        if ((ps = this.getResourceFromUrl(ResourcesUtil.resourceNameToFieldName((String)parentStyle))) == null || definition == null) break block39;
                        definition.addReference(ps);
                        break block39;
                    }
                    String name6 = ResourceUsageModel.getResourceFieldName(element);
                    while ((index2 = name6.lastIndexOf(95)) != -1) {
                        ps = this.getResourceFromUrl("@style/" + ResourcesUtil.resourceNameToFieldName(name6 = name6.substring(0, index2)));
                        if (ps == null || definition == null) continue;
                        definition.addReference(ps);
                    }
                }
                if ("item".equals(tagName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("style") && !(name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty() && !name2.startsWith("android:")) {
                    Element style;
                    Resource resource = this.getResource(ResourceType.ATTR, name2);
                    if (definition == null && (definition = this.getResource(style = (Element)element.getParentNode())) != null) {
                        from2 = definition;
                        definition.addReference(resource);
                    }
                }
                break block38;
            }
            if ((nodeType == 3 || nodeType == 4) && (textResource = this.getResourceFromUrl(ResourcesUtil.resourceNameToFieldName(text = node.getNodeValue().trim()))) != null && from2 != null) {
                from2.addReference(textResource);
            }
        }
        NodeList children4 = node.getChildNodes();
        int n5 = children4.getLength();
        for (int i5 = 0; i5 < n5; ++i5) {
            Node child = children4.item(i5);
            this.recordResourceReferences(folderType, child, from2);
        }
    }

    public void tokenizeHtml(Resource from2, String html) {
        new WebTokenizers(new ReferencesWebTokensCallback(from2)).tokenizeHtml(html);
    }

    public void tokenizeJs(Resource from2, String js) {
        new WebTokenizers(new ReferencesWebTokensCallback(from2)).tokenizeJs(js);
    }

    public void tokenizeCss(Resource from2, String css) {
        new WebTokenizers(new ReferencesWebTokensCallback(from2)).tokenizeCss(css);
    }

    public void tokenizeUnknownBinary(Resource from2, File file2) {
        try {
            this.tokenizeUnknownBinary(from2, Files.toByteArray(file2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void tokenizeUnknownBinary(Resource from2, byte[] bytes2) throws IOException {
        if (sAndroidResBytes == null) {
            sAndroidResBytes = ANDROID_RES.getBytes("UTF-8");
        }
        int index2 = 0;
        block0: while (index2 != -1) {
            int begin;
            if ((index2 = ResourceUsageModel.indexOf(bytes2, sAndroidResBytes, index2)) == -1) continue;
            for (int end = begin = (index2 += sAndroidResBytes.length); end < bytes2.length; ++end) {
                byte c2 = bytes2[end];
                if (c2 == 47 || Character.isJavaIdentifierPart((char)c2)) continue;
                String url = "@" + new String(bytes2, begin, end - begin, Charsets.UTF_8);
                Resource resource = this.getResourceFromUrl(url);
                if (resource == null) continue block0;
                if (from2 != null) {
                    from2.addReference(resource);
                    continue block0;
                }
                ResourceUsageModel.markReachable(resource);
                continue block0;
            }
        }
    }

    private static int indexOf(byte[] array2, byte[] target, int fromIndex) {
        block0: for (int i2 = fromIndex; i2 < array2.length - target.length + 1; ++i2) {
            for (int j2 = 0; j2 < target.length; ++j2) {
                if (array2[i2 + j2] != target[j2]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    private void tokenizeUnknownText(String text) {
        int index2 = 0;
        block0: while (index2 != -1) {
            int begin;
            if ((index2 = text.indexOf(ANDROID_RES, index2)) == -1) continue;
            int length = text.length();
            for (int end = begin = (index2 += ANDROID_RES.length()); end < length; ++end) {
                char c2 = text.charAt(end);
                if (c2 == '/' || Character.isJavaIdentifierPart(c2)) continue;
                ResourceUsageModel.markReachable(this.getResourceFromUrl("@" + text.substring(begin, end)));
                continue block0;
            }
        }
    }

    public void tokenizeKotlinCode(String s2) {
        this.tokenizeJavaCode(s2);
    }

    public void tokenizeJavaCode(String s2) {
        if (s2.length() <= 2) {
            return;
        }
        int length = s2.length();
        block0: for (int index2 = 0; index2 < length; ++index2) {
            char c2 = s2.charAt(index2);
            if (index2 == length - 1) break;
            char next = s2.charAt(index2 + 1);
            if (Character.isWhitespace(c2)) continue;
            if (c2 == '/') {
                if (next == '*') {
                    while (index2 < length - 2 && (s2.charAt(index2) != '*' || s2.charAt(index2 + 1) != '/')) {
                        ++index2;
                    }
                    ++index2;
                    continue;
                }
                if (next != '/') continue;
                while (index2 < length && s2.charAt(index2) != '\n') {
                    ++index2;
                }
                continue;
            }
            if (c2 == '\'') {
                if (next == '\\') {
                    index2 += 2;
                    continue;
                }
                ++index2;
                continue;
            }
            if (c2 == '\"') {
                ++index2;
                while (index2 < length - 1) {
                    char t2 = s2.charAt(index2);
                    if (t2 == '\\') {
                        ++index2;
                    } else if (t2 == '\"') continue block0;
                    ++index2;
                }
                continue;
            }
            if (c2 == 'R' && next == '.') {
                int begin = index2;
                index2 += 2;
                while (index2 < length) {
                    char t3 = s2.charAt(index2);
                    if (t3 == '.') {
                        String typeName = s2.substring(begin + 2, index2);
                        ResourceType type = ResourceType.fromClassName(typeName);
                        if (type != null) {
                            begin = ++index2;
                            while (index2 < length && Character.isJavaIdentifierPart(s2.charAt(index2))) {
                                ++index2;
                            }
                            if (index2 > begin) {
                                String name2 = s2.substring(begin, index2);
                                Resource resource = this.addResource(type, name2, null);
                                ResourceUsageModel.markReachable(resource);
                            }
                        }
                        --index2;
                        continue block0;
                    }
                    if (!Character.isJavaIdentifierStart(t3)) continue block0;
                    ++index2;
                }
                continue;
            }
            if (!Character.isJavaIdentifierPart(c2)) continue;
            while (index2 < length && Character.isJavaIdentifierPart(s2.charAt(index2))) {
                ++index2;
            }
            --index2;
        }
    }

    protected void referencedString(String string2) {
    }

    private void recordCssUrl(Resource from2, String value) {
        if (!this.referencedUrl(from2, value)) {
            this.referencedString(value);
        }
    }

    private boolean referencedUrl(Resource from2, String url) {
        Resource resource = this.getResourceFromFilePath(url);
        if (resource == null && url.indexOf(47) == -1) {
            resource = this.getResource(ResourceType.RAW, ResourcesUtil.resourceNameToFieldName(SdkUtils.fileNameToResourceName(url)));
        }
        if (resource != null) {
            if (from2 != null) {
                from2.addReference(resource);
            } else {
                ResourceUsageModel.markReachable(resource);
            }
            return true;
        }
        return false;
    }

    private void recordHtmlAttributeValue(Resource from2, String tagName, String attribute, String value) {
        if ("href".equals(attribute) || "src".equals(attribute)) {
            if (!this.referencedUrl(from2, value)) {
                this.referencedString(value);
            }
            if (from2 != null) {
                from2.addReference(this.getResourceFromFilePath(attribute));
            }
        }
    }

    private void recordJsString(String string2) {
        this.referencedString(string2);
    }

    public List<Resource> getResources() {
        return this.mResourceStore.getResources();
    }

    public Collection<ListMultimap<String, Resource>> getResourceMaps() {
        return this.mResourceStore.getResourceMaps();
    }

    public static class Resource
    implements Comparable<Resource> {
        int mFlags;
        public final ResourceType type;
        public final String name;
        public String packageName;
        public int value;
        public List<Resource> references;
        public List<Path> declarations;
        public Set<ReachableOrigin> reachableParents;

        public String flagString() {
            switch (this.mFlags) {
                case 0: {
                    return "E";
                }
                case 2: {
                    return "D";
                }
                case 34: {
                    return "U";
                }
            }
            StringBuilder sb = new StringBuilder();
            if (this.isDeclared()) {
                sb.append('D');
            }
            if (this.isReachable()) {
                sb.append('R');
            }
            if (this.isPublic()) {
                sb.append('P');
            }
            if (this.isKeep()) {
                sb.append('K');
            }
            if (this.isDiscard()) {
                sb.append('X');
            }
            return sb.toString();
        }

        public static int stringToFlag(String s2) {
            int flags = 0;
            block9: for (int i2 = 0; i2 < s2.length(); ++i2) {
                switch (s2.charAt(i2)) {
                    case 'E': {
                        return 0;
                    }
                    case 'U': {
                        flags = flags | 2 | 0x20;
                        continue block9;
                    }
                    case 'D': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'R': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'P': {
                        flags |= 4;
                        continue block9;
                    }
                    case 'K': {
                        flags |= 8;
                        continue block9;
                    }
                    case 'X': {
                        flags |= 0x10;
                        continue block9;
                    }
                    default: {
                        assert (false) : s2;
                        continue block9;
                    }
                }
            }
            return flags;
        }

        public boolean isDeclared() {
            return (this.mFlags & 2) != 0;
        }

        public void setDeclared(boolean on) {
            this.mFlags = on ? this.mFlags | 2 : this.mFlags & 0xFFFFFFFD;
        }

        public boolean isPublic() {
            return (this.mFlags & 4) != 0;
        }

        public void setPublic(boolean on) {
            this.mFlags = on ? this.mFlags | 4 : this.mFlags & 0xFFFFFFFB;
        }

        public boolean isKeep() {
            return (this.mFlags & 8) != 0;
        }

        public void setKeep(boolean on) {
            this.mFlags = on ? this.mFlags | 8 : this.mFlags & 0xFFFFFFF7;
        }

        public boolean isDiscard() {
            return (this.mFlags & 0x10) != 0;
        }

        public void setDiscard(boolean on) {
            this.mFlags = on ? this.mFlags | 0x10 : this.mFlags & 0xFFFFFFEF;
        }

        public boolean isReachable() {
            return (this.mFlags & 0x20) != 0;
        }

        public void setReachable(boolean on) {
            this.mFlags = on ? this.mFlags | 0x20 : this.mFlags & 0xFFFFFFDF;
        }

        public Resource(ResourceType type, String name2, int value) {
            this(null, type, name2, value);
        }

        public Resource(String packageName, ResourceType type, String name2, int value) {
            this.packageName = packageName;
            this.type = type;
            this.name = name2;
            this.value = value;
        }

        public String toString() {
            return this.type + ":" + this.name + ":" + this.value;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Resource resource = (Resource)o2;
            return Objects.equals(this.packageName, resource.packageName) && Objects.equals(this.name, resource.name) && this.type == resource.type;
        }

        public int hashCode() {
            int result2 = this.type != null ? this.type.hashCode() : 0;
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            return result2;
        }

        public void addLocation(File file2) {
            this.addLocation(file2.toPath());
        }

        public void addReachableParent(ReachableOrigin parent) {
            if (this.reachableParents == null) {
                this.reachableParents = Sets.newHashSet();
            }
            this.reachableParents.add(parent);
        }

        public void addLocation(Path path) {
            if (this.declarations == null) {
                this.declarations = Lists.newArrayList();
            }
            this.declarations.add(path);
        }

        public void addReference(Resource resource) {
            if (resource != null) {
                if (this.references == null) {
                    this.references = Lists.newArrayList();
                } else if (this.references.contains(resource)) {
                    return;
                }
                this.references.add(resource);
            }
        }

        public String getUrl() {
            String packagePart = this.packageName == null ? "" : this.packageName + ":";
            return "@" + packagePart + this.type.getName() + "/" + this.name;
        }

        public String getField() {
            return "R." + this.type.getName() + "." + this.name;
        }

        @Override
        public int compareTo(Resource other) {
            if (this.type != other.type) {
                return this.type.compareTo(other.type);
            }
            return this.name.compareTo(other.name);
        }
    }

    public static interface ReachableOrigin {
        public Set<ReachableOrigin> getParents();

        public String toString();
    }

    private class ReferencesWebTokensCallback
    implements WebTokenizers.WebTokensCallback {
        private final Resource from;

        public ReferencesWebTokensCallback(Resource from2) {
            this.from = from2;
        }

        @Override
        public void referencedHtmlAttribute(String tag, String attribute, String value) {
            ResourceUsageModel.this.recordHtmlAttributeValue(this.from, tag, attribute, value);
        }

        @Override
        public void referencedJsString(String jsString) {
            ResourceUsageModel.this.recordJsString(jsString);
        }

        @Override
        public void referencedCssUrl(String url) {
            ResourceUsageModel.this.recordCssUrl(this.from, url);
        }
    }

    public static class ResourceReachableOrigin
    implements ReachableOrigin {
        private final Resource resource;

        public ResourceReachableOrigin(Resource resource) {
            this.resource = resource;
        }

        @Override
        public Set<ReachableOrigin> getParents() {
            return this.resource.reachableParents;
        }

        @Override
        public String toString() {
            return this.resource.type + ":" + this.resource.name + ":" + Integer.toHexString(this.resource.value);
        }
    }
}

